/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.DirectionSet;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0010J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lmods/eln/mechanical/VerticalHubElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "connectedSides", "Lmods/eln/misc/DirectionSet;", "shaftConnectivity", "", "Lmods/eln/misc/Direction;", "getShaftConnectivity", "()[Lmods/eln/misc/Direction;", "standingSides", "connectedOnSide", "", "direction", "net", "Lmods/eln/mechanical/ShaftNetwork;", "coordonate", "Lmods/eln/misc/Coordinate;", "disconnectedOnSide", "initialize", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onNeighborBlockChange", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "scanStandingSides", "writeToNBT", "Eln"})
public final class VerticalHubElement
extends SimpleShaftElement {
    @NotNull
    private DirectionSet connectedSides;
    @NotNull
    private DirectionSet standingSides;

    public VerticalHubElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.connectedSides = new DirectionSet();
        this.standingSides = new DirectionSet();
    }

    @Override
    @NotNull
    public Direction[] getShaftConnectivity() {
        Direction[] directionArray = new Direction[]{Direction.XP, Direction.YP, Direction.ZP, Direction.XN, Direction.YN, Direction.ZN};
        return directionArray;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.scanStandingSides();
    }

    public final void scanStandingSides() {
        this.standingSides.clear();
        for (Direction dir : Direction.Companion.getAll()) {
            Coordinate test;
            if (this.connectedSides.contains((Object)dir) || !(test = this.coordinate().moved(dir)).getBlock().func_149662_c()) continue;
            this.standingSides.add(dir);
        }
    }

    @Override
    public void connectedOnSide(@NotNull Direction direction, @NotNull ShaftNetwork net) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter(net, "net");
        this.connectedSides.add(direction);
    }

    @Override
    public void disconnectedOnSide(@NotNull Direction direction, @Nullable ShaftNetwork net) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        this.connectedSides.remove((Object)direction);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        this.connectedSides.serialize(stream);
        this.standingSides.serialize(stream);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        this.connectedSides.writeToNBT(nbt, "connectedSides");
        this.standingSides.writeToNBT(nbt, "standingSides");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.connectedSides.readFromNBT(nbt, "connectedSides");
        this.standingSides.readFromNBT(nbt, "standingSides");
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    @Override
    public void onNeighborBlockChange() {
        this.scanStandingSides();
    }
}

