/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataInputStream;
import mods.eln.mechanical.ShaftRender;
import mods.eln.mechanical.VerticalHubDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.DirectionSet;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0015"}, d2={"Lmods/eln/mechanical/VerticalHubRender;", "Lmods/eln/mechanical/ShaftRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "connectedSides", "Lmods/eln/misc/DirectionSet;", "getConnectedSides", "()Lmods/eln/misc/DirectionSet;", "Lmods/eln/mechanical/VerticalHubDescriptor;", "getDesc", "()Lmods/eln/mechanical/VerticalHubDescriptor;", "standingSides", "getStandingSides", "draw", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "Eln"})
public final class VerticalHubRender
extends ShaftRender {
    @NotNull
    private final VerticalHubDescriptor desc;
    @NotNull
    private final DirectionSet connectedSides;
    @NotNull
    private final DirectionSet standingSides;

    public VerticalHubRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(desc, "desc");
        super(entity, desc);
        this.desc = (VerticalHubDescriptor)desc;
        this.connectedSides = new DirectionSet();
        this.standingSides = new DirectionSet();
    }

    @NotNull
    public final VerticalHubDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final DirectionSet getConnectedSides() {
        return this.connectedSides;
    }

    @NotNull
    public final DirectionSet getStandingSides() {
        return this.standingSides;
    }

    @Override
    public void draw() {
        Direction direction = this.front;
        Intrinsics.checkNotNull((Object)direction);
        direction.glRotateXnRef();
        this.desc.draw(this.getAngle(), this.connectedSides, this.standingSides);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.connectedSides.deserialize(stream);
        this.standingSides.deserialize(stream);
    }
}

