/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.node.NodeBlockEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.JvmStatic;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.ranges.RangesKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012B'\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0000J\u0011\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u0000H\u0086\u0002J\u000e\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020\u0000J\u000e\u00107\u001a\u00020/2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u0013\u0010>\u001a\u00020 2\b\u0010?\u001a\u0004\u0018\u00010@H\u0096\u0002J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u000eJ\b\u0010D\u001a\u00020\u000eH\u0016J\u0006\u0010E\u001a\u00020/J\u000e\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u000201J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u000201J\u0006\u0010J\u001a\u00020\u0000J\u001e\u0010K\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0018\u0010L\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010M\u001a\u00020/2\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010N\u001a\u00020/2\u0006\u0010%\u001a\u00020\u000eJ\u000e\u0010O\u001a\u00020/2\u0006\u0010P\u001a\u000209J\u000e\u0010O\u001a\u00020/2\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u00020/2\u0006\u0010S\u001a\u00020\u0014J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010U\u001a\u00020\bH\u0016J\u000e\u0010V\u001a\u00020;2\u0006\u00106\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010W\u001a\u00020\u000eJ\u0018\u0010X\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\"R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lmods/eln/misc/Coordinate;", "Lmods/eln/misc/INBTTReady;", "()V", "coord", "(Lmods/eln/misc/Coordinate;)V", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "(Lnet/minecraft/nbt/NBTTagCompound;Ljava/lang/String;)V", "entity", "Lmods/eln/node/NodeBlockEntity;", "(Lmods/eln/node/NodeBlockEntity;)V", "x", "", "y", "z", "dimention", "(IIII)V", "world", "Lnet/minecraft/world/World;", "(IIILnet/minecraft/world/World;)V", "Lnet/minecraft/tileentity/TileEntity;", "(Lnet/minecraft/tileentity/TileEntity;)V", "b", "Lnet/minecraft/block/Block;", "block", "getBlock", "()Lnet/minecraft/block/Block;", "setBlock", "(Lnet/minecraft/block/Block;)V", "blockExist", "", "getBlockExist", "()Z", "dimension", "isValid", "meta", "getMeta", "()I", "tileEntity", "getTileEntity", "()Lnet/minecraft/tileentity/TileEntity;", "w", "worldExist", "getWorldExist", "applyTransformation", "", "front", "Lmods/eln/misc/Direction;", "coordinate", "compareTo", "o", "copyFrom", "c", "copyTo", "v", "", "distanceTo", "", "e", "Lnet/minecraft/entity/Entity;", "equals", "other", "", "getAxisAlignedBB", "Lnet/minecraft/util/AxisAlignedBB;", "ray", "hashCode", "invalidate", "move", "dir", "moved", "direction", "negate", "newWithOffset", "readFromNBT", "setDimension", "setMetadata", "setPosition", "vp", "Lnet/minecraft/util/Vec3;", "setWorld", "worldObj", "subtract", "toString", "trueDistanceTo", "worldDimension", "writeToNBT", "Companion", "Eln"})
public final class Coordinate
implements INBTTReady {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public int x;
    @JvmField
    public int y;
    @JvmField
    public int z;
    @JvmField
    public int dimension;
    @Nullable
    private World w;

    public Coordinate() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.dimension = 0;
    }

    public Coordinate(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter(coord, "coord");
        this.x = coord.x;
        this.y = coord.y;
        this.z = coord.z;
        this.dimension = coord.dimension;
    }

    public Coordinate(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.readFromNBT(nbt, str);
    }

    public int hashCode() {
        return (this.x + this.y) * 0x10101010 + this.z;
    }

    public final int worldDimension() {
        return this.dimension;
    }

    @NotNull
    public final World world() {
        World world;
        if (this.w == null) {
            WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.worldDimension());
            Intrinsics.checkNotNullExpressionValue(worldServer, "{\n            FMLCommonH\u2026rldDimension())\n        }");
            world = (World)worldServer;
        } else {
            World world2 = this.w;
            world = world2;
            Intrinsics.checkNotNull(world2);
        }
        return world;
    }

    public Coordinate(@NotNull NodeBlockEntity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
        this.dimension = entity.func_145831_w().field_73011_w.field_76574_g;
    }

    public Coordinate(int x, int y, int z, int dimention) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimention;
    }

    public Coordinate(int x, int y, int z, @NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = world.field_73011_w.field_76574_g;
        if (world.field_72995_K) {
            this.w = world;
        }
    }

    public Coordinate(@NotNull TileEntity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
        this.dimension = entity.func_145831_w().field_73011_w.field_76574_g;
        if (entity.func_145831_w().field_72995_K) {
            this.w = entity.func_145831_w();
        }
    }

    @NotNull
    public final Coordinate newWithOffset(int x, int y, int z) {
        return new Coordinate(this.x + x, this.y + y, this.z + z, this.dimension);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Coordinate)) {
            return false;
        }
        return ((Coordinate)other).x == this.x && ((Coordinate)other).y == this.y && ((Coordinate)other).z == this.z && ((Coordinate)other).dimension == this.dimension;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.x = nbt.func_74762_e(str + 'x');
        this.y = nbt.func_74762_e(str + 'y');
        this.z = nbt.func_74762_e(str + 'z');
        this.dimension = nbt.func_74762_e(str + 'd');
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        nbt.func_74768_a(str + 'x', this.x);
        nbt.func_74768_a(str + 'y', this.y);
        nbt.func_74768_a(str + 'z', this.z);
        nbt.func_74768_a(str + 'd', this.dimension);
    }

    @NotNull
    public String toString() {
        return "X : " + this.x + " Y : " + this.y + " Z : " + this.z + " D : " + this.dimension;
    }

    public final void move(@NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)dir, "dir");
        switch (WhenMappings.$EnumSwitchMapping$0[dir.ordinal()]) {
            case 1: {
                int n = this.x;
                this.x = n + -1;
                break;
            }
            case 2: {
                int n = this.x;
                this.x = n + 1;
                break;
            }
            case 3: {
                int n = this.y;
                this.y = n + -1;
                break;
            }
            case 4: {
                int n = this.y;
                this.y = n + 1;
                break;
            }
            case 5: {
                int n = this.z;
                this.z = n + -1;
                break;
            }
            case 6: {
                int n = this.z;
                this.z = n + 1;
            }
        }
    }

    @NotNull
    public final Coordinate moved(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Coordinate moved = new Coordinate(this);
        moved.move(direction);
        return moved;
    }

    @NotNull
    public final Block getBlock() {
        Block block = this.world().func_147439_a(this.x, this.y, this.z);
        Intrinsics.checkNotNullExpressionValue(block, "world().getBlock(x, y, z)");
        return block;
    }

    public final void setBlock(@NotNull Block b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.world().func_147449_b(this.x, this.y, this.z, b);
    }

    @NotNull
    public final AxisAlignedBB getAxisAlignedBB(int ray) {
        AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)(this.x - ray), (double)(this.y - ray), (double)(this.z - ray), (double)(this.x + ray + 1), (double)(this.y + ray + 1), (double)(this.z + ray + 1));
        Intrinsics.checkNotNullExpressionValue(axisAlignedBB, "getBoundingBox((\n       \u2026(z + ray + 1).toDouble())");
        return axisAlignedBB;
    }

    public final double distanceTo(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return Math.abs(e.field_70165_t - ((double)this.x + 0.5)) + Math.abs(e.field_70163_u - ((double)this.y + 0.5)) + Math.abs(e.field_70161_v - ((double)this.z + 0.5));
    }

    public final int getMeta() {
        return this.world().func_72805_g(this.x, this.y, this.z);
    }

    public final boolean getBlockExist() {
        WorldServer worldServer = DimensionManager.getWorld((int)this.dimension);
        if (worldServer == null) {
            return false;
        }
        WorldServer w = worldServer;
        return w.func_72899_e(this.x, this.y, this.z);
    }

    public final boolean getWorldExist() {
        return DimensionManager.getWorld((int)this.dimension) != null;
    }

    public final void copyTo(@NotNull double[] v) {
        Intrinsics.checkNotNullParameter(v, "v");
        v[0] = (double)this.x + 0.5;
        v[1] = (double)this.y + 0.5;
        v[2] = (double)this.z + 0.5;
    }

    public final void setPosition(@NotNull double[] vp) {
        Intrinsics.checkNotNullParameter(vp, "vp");
        this.x = (int)vp[0];
        this.y = (int)vp[1];
        this.z = (int)vp[2];
    }

    public final void setPosition(@NotNull Vec3 vp) {
        Intrinsics.checkNotNullParameter(vp, "vp");
        this.x = (int)vp.field_72450_a;
        this.y = (int)vp.field_72448_b;
        this.z = (int)vp.field_72449_c;
    }

    @Nullable
    public final TileEntity getTileEntity() {
        return this.world().func_147438_o(this.x, this.y, this.z);
    }

    public final void invalidate() {
        this.x = -1;
        this.y = -1;
        this.z = -1;
        this.dimension = -5123;
    }

    public final boolean isValid() {
        return this.dimension != -5123;
    }

    public final double trueDistanceTo(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter(c, "c");
        long dx = this.x - c.x;
        long dy = this.y - c.y;
        long dz = this.z - c.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final void setDimension(int dimension) {
        this.dimension = dimension;
        this.w = null;
    }

    public final void copyFrom(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter(c, "c");
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
        this.dimension = c.dimension;
    }

    public final void applyTransformation(@NotNull Direction front, @NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)front, "front");
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        front.rotateFromXN(this);
        this.x += coordinate.x;
        this.y += coordinate.y;
        this.z += coordinate.z;
    }

    public final void setWorld(@NotNull World worldObj) {
        Intrinsics.checkNotNullParameter(worldObj, "worldObj");
        if (worldObj.field_72995_K) {
            this.w = worldObj;
        }
        this.dimension = worldObj.field_73011_w.field_76574_g;
    }

    public final void setMetadata(int meta) {
        this.world().func_72921_c(this.x, this.y, this.z, meta, 0);
    }

    public final int compareTo(@NotNull Coordinate o) {
        Intrinsics.checkNotNullParameter(o, "o");
        return this.dimension != o.dimension ? this.dimension - o.dimension : (this.x != o.x ? this.x - o.x : (this.y != o.y ? this.y - o.y : (this.z != o.z ? this.z - o.z : 0)));
    }

    @NotNull
    public final Coordinate subtract(@NotNull Coordinate b) {
        Intrinsics.checkNotNullParameter(b, "b");
        return this.newWithOffset(-b.x, -b.y, -b.z);
    }

    @NotNull
    public final Coordinate negate() {
        return new Coordinate(-this.x, -this.y, -this.z, this.dimension);
    }

    @JvmStatic
    @NotNull
    public static final AxisAlignedBB getAxisAlignedBB(@NotNull Coordinate a, @NotNull Coordinate b) {
        return Companion.getAxisAlignedBB(a, b);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.XN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.XP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.YN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.YP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lmods/eln/misc/Coordinate$Companion;", "", "()V", "getAxisAlignedBB", "Lnet/minecraft/util/AxisAlignedBB;", "a", "Lmods/eln/misc/Coordinate;", "b", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AxisAlignedBB getAxisAlignedBB(@NotNull Coordinate a, @NotNull Coordinate b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)RangesKt.coerceAtMost(a.x, b.x), (double)RangesKt.coerceAtMost(a.y, b.y), (double)RangesKt.coerceAtMost(a.z, b.z), (double)((double)RangesKt.coerceAtLeast(a.x, b.x) + 1.0), (double)((double)RangesKt.coerceAtLeast(a.y, b.y) + 1.0), (double)((double)RangesKt.coerceAtLeast(a.z, b.z) + 1.0));
            Intrinsics.checkNotNullExpressionValue(axisAlignedBB, "getBoundingBox(\n        \u2026coerceAtLeast(b.z) + 1.0)");
            return axisAlignedBB;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

