/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.IFunction;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lmods/eln/misc/FunctionTable;", "Lmods/eln/misc/IFunction;", "point", "", "xMax", "", "([DD)V", "getPoint", "()[D", "setPoint", "([D)V", "xDelta", "getXDelta", "()D", "setXDelta", "(D)V", "getXMax", "setXMax", "xMaxInv", "getXMaxInv", "setXMaxInv", "duplicate", "xFactor", "yFactor", "getValue", "x", "Eln"})
public class FunctionTable
implements IFunction {
    @NotNull
    private double[] point;
    private double xMax;
    private double xMaxInv;
    private double xDelta;

    public FunctionTable(@NotNull double[] point, double xMax) {
        Intrinsics.checkNotNullParameter(point, "point");
        this.point = point;
        this.xMax = xMax;
        this.xMaxInv = 1.0 / this.xMax;
        this.xDelta = 1.0 / (double)(this.point.length - 1) * this.xMax;
    }

    @NotNull
    public final double[] getPoint() {
        return this.point;
    }

    public final void setPoint(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter(dArray, "<set-?>");
        this.point = dArray;
    }

    public final double getXMax() {
        return this.xMax;
    }

    public final void setXMax(double d) {
        this.xMax = d;
    }

    public double getXMaxInv() {
        return this.xMaxInv;
    }

    public void setXMaxInv(double d) {
        this.xMaxInv = d;
    }

    public double getXDelta() {
        return this.xDelta;
    }

    public void setXDelta(double d) {
        this.xDelta = d;
    }

    @Override
    public double getValue(double x) {
        double lx = x;
        if ((lx *= this.getXMaxInv()) < 0.0) {
            return this.point[0] + (this.point[1] - this.point[0]) * (double)(this.point.length - 1) * lx;
        }
        if (lx >= 1.0) {
            return this.point[this.point.length - 1] + (this.point[this.point.length - 1] - this.point[this.point.length - 2]) * (double)(this.point.length - 1) * (lx - 1.0);
        }
        int idx = (int)(lx *= (double)(this.point.length - 1));
        return this.point[idx + 1] * (lx -= (double)idx) + this.point[idx] * ((double)1.0f - lx);
    }

    @Nullable
    public FunctionTable duplicate(double xFactor, double yFactor) {
        double[] pointCpy = new double[this.point.length];
        int n = this.point.length;
        for (int idx = 0; idx < n; ++idx) {
            pointCpy[idx] = this.point[idx] * yFactor;
        }
        return new FunctionTable(pointCpy, this.xMax * xFactor);
    }
}

