/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import java.awt.Color;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmOverloads;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\u0019\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006J\u001e\u0010!\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006J\b\u0010'\u001a\u00020(H\u0016R\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010\u00a8\u0006*"}, d2={"Lmods/eln/misc/HSLColor;", "", "rgb", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "h", "", "s", "l", "alpha", "(FFFF)V", "hsl", "", "([FF)V", "<set-?>", "getAlpha", "()F", "complementary", "getComplementary", "()Ljava/awt/Color;", "getHsl", "()[F", "hue", "getHue", "luminance", "getLuminance", "getRgb", "saturation", "getSaturation", "adjustHue", "degrees", "adjustLuminance", "percent", "adjustLuminanceClamped", "min", "max", "adjustSaturation", "adjustShade", "adjustTone", "toString", "", "Companion", "Eln"})
public final class HSLColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Color rgb;
    @Nullable
    private float[] hsl;
    private float alpha;

    @Nullable
    public final Color getRgb() {
        return this.rgb;
    }

    @Nullable
    public final float[] getHsl() {
        return this.hsl;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public HSLColor(@NotNull Color rgb) {
        Intrinsics.checkNotNullParameter(rgb, "rgb");
        this.rgb = rgb;
        this.hsl = Companion.fromRGB(rgb);
        this.alpha = (float)rgb.getAlpha() / 255.0f;
    }

    @JvmOverloads
    public HSLColor(float h, float s, float l, float alpha) {
        float[] fArray = new float[]{h, s, l};
        this.rgb = Companion.toRGB(fArray, alpha);
        this.alpha = alpha;
    }

    public /* synthetic */ HSLColor(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @JvmOverloads
    public HSLColor(@NotNull float[] hsl, float alpha) {
        Intrinsics.checkNotNullParameter(hsl, "hsl");
        this.hsl = hsl;
        this.alpha = alpha;
        this.rgb = Companion.toRGB(hsl, alpha);
    }

    public /* synthetic */ HSLColor(float[] fArray, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(fArray, f);
    }

    @NotNull
    public final Color adjustHue(float degrees) {
        Intrinsics.checkNotNull(this.hsl);
        float f = this.hsl[1];
        Intrinsics.checkNotNull(this.hsl);
        return Companion.toRGB(degrees, f, this.hsl[2], this.alpha);
    }

    @NotNull
    public final Color adjustLuminance(float percent) {
        Intrinsics.checkNotNull(this.hsl);
        float f = this.hsl[0];
        Intrinsics.checkNotNull(this.hsl);
        return Companion.toRGB(f, this.hsl[1], percent, this.alpha);
    }

    @NotNull
    public final Color adjustLuminanceClamped(float percent, float min, float max) {
        return this.adjustLuminance(Math.min(Math.max(percent, min), max));
    }

    @NotNull
    public final Color adjustSaturation(float percent) {
        Intrinsics.checkNotNull(this.hsl);
        float f = this.hsl[0];
        Intrinsics.checkNotNull(this.hsl);
        return Companion.toRGB(f, percent, this.hsl[2], this.alpha);
    }

    @NotNull
    public final Color adjustShade(float percent) {
        float multiplier = (100.0f - percent) / 100.0f;
        Intrinsics.checkNotNull(this.hsl);
        float l = Math.max(0.0f, this.hsl[2] * multiplier);
        Intrinsics.checkNotNull(this.hsl);
        float f = this.hsl[0];
        Intrinsics.checkNotNull(this.hsl);
        return Companion.toRGB(f, this.hsl[1], l, this.alpha);
    }

    @NotNull
    public final Color adjustTone(float percent) {
        float multiplier = (100.0f + percent) / 100.0f;
        Intrinsics.checkNotNull(this.hsl);
        float l = Math.min(100.0f, this.hsl[2] * multiplier);
        Intrinsics.checkNotNull(this.hsl);
        float f = this.hsl[0];
        Intrinsics.checkNotNull(this.hsl);
        return Companion.toRGB(f, this.hsl[1], l, this.alpha);
    }

    @NotNull
    public final Color getComplementary() {
        Intrinsics.checkNotNull(this.hsl);
        float hue = (this.hsl[0] + 180.0f) % 360.0f;
        Intrinsics.checkNotNull(this.hsl);
        float f = this.hsl[1];
        Intrinsics.checkNotNull(this.hsl);
        return mods.eln.misc.HSLColor$Companion.toRGB$default(Companion, hue, f, this.hsl[2], 0.0f, 8, null);
    }

    public final float getHue() {
        Intrinsics.checkNotNull(this.hsl);
        return this.hsl[0];
    }

    public final float getLuminance() {
        Intrinsics.checkNotNull(this.hsl);
        return this.hsl[2];
    }

    public final float getSaturation() {
        Intrinsics.checkNotNull(this.hsl);
        return this.hsl[1];
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("HSLColor[h=");
        Intrinsics.checkNotNull(this.hsl);
        StringBuilder stringBuilder2 = stringBuilder.append(this.hsl[0]).append(",s=");
        Intrinsics.checkNotNull(this.hsl);
        StringBuilder stringBuilder3 = stringBuilder2.append(this.hsl[1]).append(",l=");
        Intrinsics.checkNotNull(this.hsl);
        String toString2 = stringBuilder3.append(this.hsl[2]).append(",alpha=").append(this.alpha).append(']').toString();
        return toString2;
    }

    @JvmOverloads
    public HSLColor(float h, float s, float l) {
        this(h, s, l, 0.0f, 8, null);
    }

    @JvmOverloads
    public HSLColor(@NotNull float[] hsl) {
        Intrinsics.checkNotNullParameter(hsl, "hsl");
        this(hsl, 0.0f, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\u001a\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Lmods/eln/misc/HSLColor$Companion;", "", "()V", "HueToRGB", "", "p", "q", "h", "fromRGB", "", "color", "Ljava/awt/Color;", "toRGB", "s", "l", "alpha", "hsl", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final float[] fromRGB(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            float[] rgb = color.getRGBColorComponents(null);
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float min = Math.min(r, Math.min(g, b));
            float max = Math.max(r, Math.max(g, b));
            float h = 0.0f;
            if (max == min) {
                h = 0.0f;
            } else if (max == r) {
                h = ((float)60 * (g - b) / (max - min) + (float)360) % (float)360;
            } else if (max == g) {
                h = (float)60 * (b - r) / (max - min) + (float)120;
            } else if (max == b) {
                h = (float)60 * (r - g) / (max - min) + (float)240;
            }
            float l = (max + min) / (float)2;
            float s = 0.0f;
            s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
            float[] fArray = new float[]{h, s * (float)100, l * (float)100};
            return fArray;
        }

        @JvmOverloads
        @NotNull
        public final Color toRGB(@NotNull float[] hsl, float alpha) {
            Intrinsics.checkNotNullParameter(hsl, "hsl");
            return this.toRGB(hsl[0], hsl[1], hsl[2], alpha);
        }

        public static /* synthetic */ Color toRGB$default(Companion companion, float[] fArray, float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = 1.0f;
            }
            return companion.toRGB(fArray, f);
        }

        @JvmOverloads
        @NotNull
        public final Color toRGB(float h, float s, float l, float alpha) {
            float hvar = h;
            float svar = s;
            float lvar = l;
            if (svar < 0.0f || svar > 100.0f) {
                String message = "Color parameter outside of expected range - Saturation";
                throw new IllegalArgumentException(message);
            }
            if (lvar < 0.0f || lvar > 100.0f) {
                String message = "Color parameter outside of expected range - Luminance";
                throw new IllegalArgumentException(message);
            }
            if (alpha < 0.0f || alpha > 1.0f) {
                String message = "Color parameter outside of expected range - Alpha";
                throw new IllegalArgumentException(message);
            }
            hvar %= 360.0f;
            float q = 0.0f;
            q = (double)lvar < 0.5 ? lvar * (1.0f + svar) : (lvar /= 100.0f) + (svar /= 100.0f) - svar * lvar;
            float p = (float)2 * lvar - q;
            float r = Math.max(0.0f, this.HueToRGB(p, q, (hvar /= 360.0f) + 0.33333334f));
            float g = Math.max(0.0f, this.HueToRGB(p, q, hvar));
            float b = Math.max(0.0f, this.HueToRGB(p, q, hvar - 0.33333334f));
            r = Math.min(r, 1.0f);
            g = Math.min(g, 1.0f);
            b = Math.min(b, 1.0f);
            return new Color(r, g, b, alpha);
        }

        public static /* synthetic */ Color toRGB$default(Companion companion, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 8) != 0) {
                f4 = 1.0f;
            }
            return companion.toRGB(f, f2, f3, f4);
        }

        private final float HueToRGB(float p, float q, float h) {
            float hvar = h;
            if (hvar < 0.0f) {
                hvar += 1.0f;
            }
            if (hvar > 1.0f) {
                hvar -= 1.0f;
            }
            if ((float)6 * hvar < 1.0f) {
                return p + (q - p) * 6.0f * hvar;
            }
            if ((float)2 * hvar < 1.0f) {
                return q;
            }
            if ((float)3 * hvar < 2.0f) {
                return p + (q - p) * 6.0f * (0.6666667f - hvar);
            }
            return p;
        }

        @JvmOverloads
        @NotNull
        public final Color toRGB(@NotNull float[] hsl) {
            Intrinsics.checkNotNullParameter(hsl, "hsl");
            return mods.eln.misc.HSLColor$Companion.toRGB$default(this, hsl, 0.0f, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final Color toRGB(float h, float s, float l) {
            return mods.eln.misc.HSLColor$Companion.toRGB$default(this, h, s, l, 0.0f, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

