/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0013\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u0019\u0010\r\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000fJ!\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0010H\u0086\u0002R$\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lmods/eln/misc/LRDUCubeMask;", "", "()V", "lrduMaskArray", "", "Lmods/eln/misc/LRDUMask;", "getLrduMaskArray", "()[Lmods/eln/misc/LRDUMask;", "setLrduMaskArray", "([Lmods/eln/misc/LRDUMask;)V", "[Lmods/eln/misc/LRDUMask;", "clear", "", "get", "direction", "Lmods/eln/misc/Direction;", "", "lrdu", "Lmods/eln/misc/LRDU;", "getSide", "getTranslate", "side", "set", "value", "Eln"})
public final class LRDUCubeMask {
    @NotNull
    private LRDUMask[] lrduMaskArray = new LRDUMask[6];

    public LRDUCubeMask() {
        for (int idx = 0; idx < 6; ++idx) {
            this.lrduMaskArray[idx] = new LRDUMask();
        }
    }

    @NotNull
    public final LRDUMask[] getLrduMaskArray() {
        return this.lrduMaskArray;
    }

    public final void setLrduMaskArray(@NotNull LRDUMask[] lRDUMaskArray) {
        Intrinsics.checkNotNullParameter(lRDUMaskArray, "<set-?>");
        this.lrduMaskArray = lRDUMaskArray;
    }

    @Nullable
    public final LRDUMask getSide(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        return this.lrduMaskArray[direction.getInt()];
    }

    public final void clear() {
        LRDUMask[] lRDUMaskArray = this.lrduMaskArray;
        int n = lRDUMaskArray.length;
        for (int i = 0; i < n; ++i) {
            LRDUMask lrduMask;
            LRDUMask lRDUMask = lrduMask = lRDUMaskArray[i];
            Intrinsics.checkNotNull(lRDUMask);
            lRDUMask.set(0);
        }
    }

    public final void set(@NotNull Direction direction, @NotNull LRDU lrdu, boolean value) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        LRDUMask lRDUMask = this.get(direction);
        Intrinsics.checkNotNull(lRDUMask);
        lRDUMask.set(lrdu, value);
    }

    public final boolean get(@NotNull Direction direction, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        LRDUMask lRDUMask = this.get(direction);
        Intrinsics.checkNotNull(lRDUMask);
        return lRDUMask.get(lrdu);
    }

    @Nullable
    public final LRDUMask get(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        return this.lrduMaskArray[direction.getInt()];
    }

    @NotNull
    public final LRDUMask getTranslate(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        LRDUMask mask = new LRDUMask();
        for (LRDU lrdu : LRDU.values()) {
            LRDU otherLrdu;
            Direction otherSide = side.applyLRDU(lrdu);
            LRDU lRDU = otherLrdu = otherSide.getLRDUGoingTo(side);
            Intrinsics.checkNotNull((Object)lRDU);
            mask.set(lrdu, this.get(otherSide, lRDU));
        }
        return mask;
    }
}

