/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.misc;

import mods.eln.misc.INBTTReady;
import mods.eln.misc.RcInterpolator;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.ranges.RangesKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.IProcess;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0018\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0007\"\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0007\"\u0004\b\u001c\u0010\r\u00a8\u0006*"}, d2={"Lmods/eln/misc/WindProcess;", "Lmods/eln/sim/IProcess;", "Lmods/eln/misc/INBTTReady;", "()V", "target", "", "getTarget", "()D", "targetNotFiltered", "getTargetNotFiltered", "windHit", "getWindHit", "setWindHit", "(D)V", "windTarget", "getWindTarget", "setWindTarget", "windTargetFiltered", "Lmods/eln/misc/RcInterpolator;", "getWindTargetFiltered", "()Lmods/eln/misc/RcInterpolator;", "setWindTargetFiltered", "(Lmods/eln/misc/RcInterpolator;)V", "windTargetNoose", "getWindTargetNoose", "setWindTargetNoose", "windVariation", "getWindVariation", "setWindVariation", "getWind", "y", "", "newWindTarget", "", "process", "time", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "writeToNBT", "Eln"})
public final class WindProcess
implements IProcess,
INBTTReady {
    private double windHit = 5.0;
    private double windTarget = 5.0;
    private double windVariation;
    private double windTargetNoose;
    @NotNull
    private RcInterpolator windTargetFiltered = new RcInterpolator(60.0f);

    public final double getWindHit() {
        return this.windHit;
    }

    public final void setWindHit(double d) {
        this.windHit = d;
    }

    public final double getWindTarget() {
        return this.windTarget;
    }

    public final void setWindTarget(double d) {
        this.windTarget = d;
    }

    public final double getWindVariation() {
        return this.windVariation;
    }

    public final void setWindVariation(double d) {
        this.windVariation = d;
    }

    public final double getWindTargetNoose() {
        return this.windTargetNoose;
    }

    public final void setWindTargetNoose(double d) {
        this.windTargetNoose = d;
    }

    @NotNull
    public final RcInterpolator getWindTargetFiltered() {
        return this.windTargetFiltered;
    }

    public final void setWindTargetFiltered(@NotNull RcInterpolator rcInterpolator) {
        Intrinsics.checkNotNullParameter(rcInterpolator, "<set-?>");
        this.windTargetFiltered = rcInterpolator;
    }

    @Override
    public void process(double time) {
        double varF = 0.01;
        this.windHit += this.windVariation * time;
        this.windVariation += (this.getTarget() - this.windHit) * varF * time + (Math.random() * (double)2 - 1.0) * 0.1 * time;
        this.windVariation *= 1.0 - 0.01 * time;
        if (Math.random() < time / (double)1200) {
            this.newWindTarget();
        }
        if (Math.random() < time / (double)120) {
            this.windTargetNoose = (Math.random() * (double)2 - 1.0) * 1.2;
        }
        this.windTargetFiltered.setTarget((float)this.windTarget);
        this.windTargetFiltered.step((float)time);
    }

    public final void newWindTarget() {
        float next = (float)(Math.pow(Math.random(), 3.0) * (double)20);
        this.windTarget += ((double)next - this.windTarget) * 0.7;
    }

    public final double getTarget() {
        return this.windTargetNoose + (double)this.windTargetFiltered.get();
    }

    public final double getTargetNotFiltered() {
        return this.windTargetNoose + (double)this.windTargetFiltered.getTarget();
    }

    public final double getWind(int y) {
        return RangesKt.coerceIn((double)y, this.windHit * (double)y / 100.0, 100.0);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.windHit = nbt.func_74769_h(str + "windHit");
        this.windTarget = nbt.func_74769_h(str + "windTarget");
        this.windVariation = nbt.func_74769_h(str + "windVariation");
        if (nbt.func_74764_b(str + "windTargetFiltred")) {
            this.windTargetFiltered.setValue(nbt.func_74760_g(str + "windTargetFiltred"));
        } else {
            this.windTargetFiltered.setValue(nbt.func_74760_g(str + "windTargetFiltered"));
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        nbt.func_74780_a(str + "windHit", this.windHit);
        nbt.func_74780_a(str + "windTarget", this.windTarget);
        nbt.func_74780_a(str + "windVariation", this.windVariation);
        nbt.func_74776_a(str + "windTargetFiltered", this.windTargetFiltered.get());
    }
}

