/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import java.util.Collection;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.ItemMovingHelper;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.node.INodeElement;
import mods.eln.node.NodeBase;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.ArraysKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006%&'()*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JI\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\"\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\b\"\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J7\u0010\u0014\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\"\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\b\"\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\u00a2\u0006\u0002\u0010\u0015J?\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\"\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\b\"\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ.\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u00192\b\b\u0002\u0010\u001f\u001a\u00020\u0019J8\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u00192\b\b\u0002\u0010\u001f\u001a\u00020\u00192\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006+"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy;", "", "inventory", "Lnet/minecraft/inventory/IInventory;", "(Lnet/minecraft/inventory/IInventory;)V", "getInventory", "()Lnet/minecraft/inventory/IInventory;", "itemAcceptors", "", "Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptor;", "[Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptor;", "acceptAlways", "index", "", "maxItems", "existingItemHandler", "Lmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;", "types", "Ljava/lang/Class;", "(IILmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;[Ljava/lang/Class;)Lmods/eln/node/AutoAcceptInventoryProxy;", "acceptIfEmpty", "(I[Ljava/lang/Class;)Lmods/eln/node/AutoAcceptInventoryProxy;", "acceptIfIncrement", "(II[Ljava/lang/Class;)Lmods/eln/node/AutoAcceptInventoryProxy;", "take", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "nodeElement", "Lmods/eln/node/INodeElement;", "publish", "notifyInventoryChange", "takeFrom", "inv", "Lnet/minecraft/entity/player/InventoryPlayer;", "matchDescriptor", "Lmods/eln/generic/GenericItemUsingDamageDescriptor;", "ExistingItemHandler", "ItemAcceptor", "ItemAcceptorAlways", "ItemAcceptorIfEmpty", "ItemAcceptorIfIncrement", "SimpleItemDropper", "Eln"})
@SourceDebugExtension(value={"SMAP\nAutoAcceptInventoryProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoAcceptInventoryProxy.kt\nmods/eln/node/AutoAcceptInventoryProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1747#2,3:176\n*S KotlinDebug\n*F\n+ 1 AutoAcceptInventoryProxy.kt\nmods/eln/node/AutoAcceptInventoryProxy\n*L\n142#1:176,3\n*E\n"})
public final class AutoAcceptInventoryProxy {
    @NotNull
    private final IInventory inventory;
    @NotNull
    private final ItemAcceptor[] itemAcceptors;

    public AutoAcceptInventoryProxy(@NotNull IInventory inventory) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        this.inventory = inventory;
        this.itemAcceptors = new ItemAcceptor[this.inventory.func_70302_i_()];
    }

    @NotNull
    public final IInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final AutoAcceptInventoryProxy acceptIfEmpty(int index, Class<? extends Object> ... types) {
        Intrinsics.checkNotNullParameter(types, "types");
        if (index >= 0 && index < this.itemAcceptors.length) {
            this.itemAcceptors[index] = new ItemAcceptorIfEmpty(index, types);
        }
        return this;
    }

    @NotNull
    public final AutoAcceptInventoryProxy acceptIfIncrement(int index, int maxItems, Class<? extends Object> ... types) {
        Intrinsics.checkNotNullParameter(types, "types");
        if (index >= 0 && index < this.itemAcceptors.length) {
            this.itemAcceptors[index] = new ItemAcceptorIfIncrement(index, maxItems, types);
        }
        return this;
    }

    @NotNull
    public final AutoAcceptInventoryProxy acceptAlways(int index, int maxItems, @Nullable ExistingItemHandler existingItemHandler, Class<? extends Object> ... types) {
        Intrinsics.checkNotNullParameter(types, "types");
        if (index >= 0 && index < this.itemAcceptors.length) {
            this.itemAcceptors[index] = new ItemAcceptorAlways(index, maxItems, types, existingItemHandler);
        }
        return this;
    }

    public final boolean take(@Nullable ItemStack itemStack) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ArraysKt.filterNotNull(this.itemAcceptors);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ItemAcceptor it = (ItemAcceptor)element$iv;
                    boolean bl2 = false;
                    if (!it.take(itemStack, this.inventory)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean take(@Nullable ItemStack itemStack, @Nullable INodeElement nodeElement, boolean publish, boolean notifyInventoryChange) {
        boolean bl;
        if (this.take(itemStack)) {
            if (publish) {
                INodeElement iNodeElement = nodeElement;
                if (iNodeElement != null) {
                    iNodeElement.needPublish();
                }
            }
            if (notifyInventoryChange) {
                INodeElement iNodeElement = nodeElement;
                if (iNodeElement != null) {
                    iNodeElement.inventoryChange(this.inventory);
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean take$default(AutoAcceptInventoryProxy autoAcceptInventoryProxy, ItemStack itemStack, INodeElement iNodeElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return autoAcceptInventoryProxy.take(itemStack, iNodeElement, bl, bl2);
    }

    public final boolean takeFrom(@NotNull InventoryPlayer inv, @Nullable INodeElement nodeElement, boolean publish, boolean notifyInventoryChange, @Nullable GenericItemUsingDamageDescriptor matchDescriptor) {
        Intrinsics.checkNotNullParameter(inv, "inv");
        boolean ret = false;
        int n = inv.func_70302_i_();
        for (int idx = 0; idx < n; ++idx) {
            ItemStack stack;
            GenericItemUsingDamageDescriptor desc;
            if (inv.func_70301_a(idx) == null || matchDescriptor != null && !Intrinsics.areEqual(matchDescriptor, desc = GenericItemUsingDamageDescriptor.Companion.getDescriptor(stack))) continue;
            ret = ret || this.take(stack);
        }
        if (ret) {
            if (publish) {
                INodeElement iNodeElement = nodeElement;
                if (iNodeElement != null) {
                    iNodeElement.needPublish();
                }
            }
            if (notifyInventoryChange) {
                INodeElement iNodeElement = nodeElement;
                if (iNodeElement != null) {
                    iNodeElement.inventoryChange(this.inventory);
                }
            }
            ItemMovingHelper.syncEntireInventory(inv.field_70458_d);
        }
        return ret;
    }

    public static /* synthetic */ boolean takeFrom$default(AutoAcceptInventoryProxy autoAcceptInventoryProxy, InventoryPlayer inventoryPlayer, INodeElement iNodeElement, boolean bl, boolean bl2, GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            genericItemUsingDamageDescriptor = null;
        }
        return autoAcceptInventoryProxy.takeFrom(inventoryPlayer, iNodeElement, bl, bl2, genericItemUsingDamageDescriptor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&R#\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptor;", "", "index", "", "acceptedItems", "", "Ljava/lang/Class;", "(I[Ljava/lang/Class;)V", "getAcceptedItems", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "getIndex", "()I", "take", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "inventory", "Lnet/minecraft/inventory/IInventory;", "Eln"})
    private static abstract class ItemAcceptor {
        private final int index;
        @NotNull
        private final Class<? extends Object>[] acceptedItems;

        public ItemAcceptor(int index, @NotNull Class<? extends Object>[] acceptedItems) {
            Intrinsics.checkNotNullParameter(acceptedItems, "acceptedItems");
            this.index = index;
            this.acceptedItems = acceptedItems;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final Class<? extends Object>[] getAcceptedItems() {
            return this.acceptedItems;
        }

        public abstract boolean take(@Nullable ItemStack var1, @NotNull IInventory var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorIfEmpty;", "Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptor;", "index", "", "acceptedItems", "", "Ljava/lang/Class;", "", "(I[Ljava/lang/Class;)V", "take", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "inventory", "Lnet/minecraft/inventory/IInventory;", "Eln"})
    @SourceDebugExtension(value={"SMAP\nAutoAcceptInventoryProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoAcceptInventoryProxy.kt\nmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorIfEmpty\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n12744#2,2:176\n12744#2,2:179\n1#3:178\n*S KotlinDebug\n*F\n+ 1 AutoAcceptInventoryProxy.kt\nmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorIfEmpty\n*L\n32#1:176,2\n42#1:179,2\n*E\n"})
    private static class ItemAcceptorIfEmpty
    extends ItemAcceptor {
        public ItemAcceptorIfEmpty(int index, @NotNull Class<? extends Object>[] acceptedItems) {
            Intrinsics.checkNotNullParameter(acceptedItems, "acceptedItems");
            super(index, acceptedItems);
        }

        @Override
        public boolean take(@Nullable ItemStack itemStack, @NotNull IInventory inventory) {
            Intrinsics.checkNotNullParameter(inventory, "inventory");
            if (inventory.func_70301_a(this.getIndex()) == null && itemStack != null) {
                Class<? extends Object> it;
                Class<? extends Object> element$iv;
                int n;
                int n2;
                boolean $i$f$any;
                Class<? extends Object>[] $this$any$iv;
                Object desc;
                GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(itemStack);
                if (genericItemUsingDamageDescriptor != null) {
                    boolean bl;
                    block8: {
                        desc = genericItemUsingDamageDescriptor;
                        boolean bl2 = false;
                        $this$any$iv = this.getAcceptedItems();
                        $i$f$any = false;
                        n2 = $this$any$iv.length;
                        for (n = 0; n < n2; ++n) {
                            it = element$iv = $this$any$iv[n];
                            boolean bl3 = false;
                            if (!it.isAssignableFrom(desc.getClass())) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                    if (bl) {
                        ItemStack newItemStack = ((GenericItemUsingDamageDescriptor)desc).newItemStack();
                        IItemEnergyBattery iItemEnergyBattery = desc instanceof IItemEnergyBattery ? (IItemEnergyBattery)desc : null;
                        if (iItemEnergyBattery != null) {
                            IItemEnergyBattery it2 = iItemEnergyBattery;
                            boolean bl4 = false;
                            it2.setEnergy(newItemStack, it2.getEnergy(itemStack));
                        }
                        --itemStack.field_77994_a;
                        inventory.func_70299_a(this.getIndex(), newItemStack);
                        return true;
                    }
                }
                GenericItemBlockUsingDamageDescriptor genericItemBlockUsingDamageDescriptor = GenericItemBlockUsingDamageDescriptor.getDescriptor(itemStack);
                if (genericItemBlockUsingDamageDescriptor != null) {
                    boolean bl;
                    block9: {
                        desc = genericItemBlockUsingDamageDescriptor;
                        boolean bl5 = false;
                        $this$any$iv = this.getAcceptedItems();
                        $i$f$any = false;
                        n2 = $this$any$iv.length;
                        for (n = 0; n < n2; ++n) {
                            it = element$iv = $this$any$iv[n];
                            boolean bl6 = false;
                            if (!it.isAssignableFrom(desc.getClass())) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                    if (bl) {
                        --itemStack.field_77994_a;
                        inventory.func_70299_a(this.getIndex(), ((GenericItemBlockUsingDamageDescriptor)desc).newItemStack());
                        return true;
                    }
                }
            }
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorIfIncrement;", "Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorIfEmpty;", "index", "", "maxItems", "acceptedItems", "", "Ljava/lang/Class;", "", "(II[Ljava/lang/Class;)V", "getMaxItems", "()I", "take", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "inventory", "Lnet/minecraft/inventory/IInventory;", "Eln"})
    private static class ItemAcceptorIfIncrement
    extends ItemAcceptorIfEmpty {
        private final int maxItems;

        public ItemAcceptorIfIncrement(int index, int maxItems, @NotNull Class<? extends Object>[] acceptedItems) {
            Intrinsics.checkNotNullParameter(acceptedItems, "acceptedItems");
            super(index, acceptedItems);
            this.maxItems = maxItems;
        }

        public final int getMaxItems() {
            return this.maxItems;
        }

        @Override
        public boolean take(@Nullable ItemStack itemStack, @NotNull IInventory inventory) {
            ItemStack existingStack;
            Intrinsics.checkNotNullParameter(inventory, "inventory");
            if (super.take(itemStack, inventory)) {
                return true;
            }
            if (itemStack == null) {
                return false;
            }
            ItemStack itemStack2 = existingStack = inventory.func_70301_a(this.getIndex());
            if ((itemStack2 != null ? itemStack2.field_77994_a : 0) >= this.maxItems) {
                return false;
            }
            GenericItemUsingDamageDescriptor existingItemDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(existingStack);
            GenericItemUsingDamageDescriptor itemDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(itemStack);
            if (existingItemDescriptor != null && Intrinsics.areEqual(existingItemDescriptor, itemDescriptor)) {
                --itemStack.field_77994_a;
                ++existingStack.field_77994_a;
                return true;
            }
            GenericItemBlockUsingDamageDescriptor existingItemBloackDescriptor = GenericItemBlockUsingDamageDescriptor.getDescriptor(existingStack);
            GenericItemBlockUsingDamageDescriptor itemBlockDescriptor = GenericItemBlockUsingDamageDescriptor.getDescriptor(itemStack);
            if (existingItemBloackDescriptor != null && Intrinsics.areEqual(existingItemBloackDescriptor, itemBlockDescriptor)) {
                --itemStack.field_77994_a;
                ++existingStack.field_77994_a;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;", "", "handleExistingInventoryItem", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "Eln"})
    public static interface ExistingItemHandler {
        public void handleExistingInventoryItem(@NotNull ItemStack var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorAlways;", "Lmods/eln/node/AutoAcceptInventoryProxy$ItemAcceptorIfIncrement;", "index", "", "maxItems", "acceptedItems", "", "Ljava/lang/Class;", "", "existingItemHandler", "Lmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;", "(II[Ljava/lang/Class;Lmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;)V", "getExistingItemHandler", "()Lmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;", "take", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "inventory", "Lnet/minecraft/inventory/IInventory;", "Eln"})
    private static final class ItemAcceptorAlways
    extends ItemAcceptorIfIncrement {
        @Nullable
        private final ExistingItemHandler existingItemHandler;

        public ItemAcceptorAlways(int index, int maxItems, @NotNull Class<? extends Object>[] acceptedItems, @Nullable ExistingItemHandler existingItemHandler) {
            Intrinsics.checkNotNullParameter(acceptedItems, "acceptedItems");
            super(index, maxItems, acceptedItems);
            this.existingItemHandler = existingItemHandler;
        }

        @Nullable
        public final ExistingItemHandler getExistingItemHandler() {
            return this.existingItemHandler;
        }

        @Override
        public boolean take(@Nullable ItemStack itemStack, @NotNull IInventory inventory) {
            Object it;
            Intrinsics.checkNotNullParameter(inventory, "inventory");
            if (super.take(itemStack, inventory)) {
                return true;
            }
            if (itemStack == null) {
                return false;
            }
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(itemStack);
            if (genericItemUsingDamageDescriptor != null) {
                it = genericItemUsingDamageDescriptor;
                boolean bl = false;
                if (ArraysKt.contains(this.getAcceptedItems(), it.getClass())) {
                    --itemStack.field_77994_a;
                    ExistingItemHandler existingItemHandler = this.existingItemHandler;
                    if (existingItemHandler != null) {
                        ItemStack itemStack2 = inventory.func_70301_a(this.getIndex());
                        Intrinsics.checkNotNullExpressionValue(itemStack2, "inventory.getStackInSlot(index)");
                        existingItemHandler.handleExistingInventoryItem(itemStack2);
                    }
                    inventory.func_70299_a(this.getIndex(), ((GenericItemUsingDamageDescriptor)it).newItemStack());
                    return true;
                }
            }
            GenericItemBlockUsingDamageDescriptor genericItemBlockUsingDamageDescriptor = GenericItemBlockUsingDamageDescriptor.getDescriptor(itemStack);
            if (genericItemBlockUsingDamageDescriptor != null) {
                it = genericItemBlockUsingDamageDescriptor;
                boolean bl = false;
                if (ArraysKt.contains(this.getAcceptedItems(), it.getClass())) {
                    --itemStack.field_77994_a;
                    ExistingItemHandler existingItemHandler = this.existingItemHandler;
                    if (existingItemHandler != null) {
                        ItemStack itemStack3 = inventory.func_70301_a(this.getIndex());
                        Intrinsics.checkNotNullExpressionValue(itemStack3, "inventory.getStackInSlot(index)");
                        existingItemHandler.handleExistingInventoryItem(itemStack3);
                    }
                    inventory.func_70299_a(this.getIndex(), ((GenericItemBlockUsingDamageDescriptor)it).newItemStack());
                    return true;
                }
            }
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lmods/eln/node/AutoAcceptInventoryProxy$SimpleItemDropper;", "Lmods/eln/node/AutoAcceptInventoryProxy$ExistingItemHandler;", "node", "Lmods/eln/node/NodeBase;", "(Lmods/eln/node/NodeBase;)V", "getNode", "()Lmods/eln/node/NodeBase;", "handleExistingInventoryItem", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "Eln"})
    public static final class SimpleItemDropper
    implements ExistingItemHandler {
        @NotNull
        private final NodeBase node;

        public SimpleItemDropper(@NotNull NodeBase node) {
            Intrinsics.checkNotNullParameter(node, "node");
            this.node = node;
        }

        @NotNull
        public final NodeBase getNode() {
            return this.node;
        }

        @Override
        public void handleExistingInventoryItem(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter(itemStack, "itemStack");
            this.node.dropItem(itemStack);
        }
    }
}

