/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeBlockEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lmods/eln/node/Node;", "Lmods/eln/node/NodeBase;", "()V", "entity", "Lmods/eln/node/NodeBlockEntity;", "getEntity", "()Lmods/eln/node/NodeBlockEntity;", "lastLight", "", "light", "lightValue", "getLightValue", "()I", "setLightValue", "(I)V", "oldSendedRedstone", "", "getOldSendedRedstone", "()Z", "setOldSendedRedstone", "(Z)V", "canConnectRedstone", "isProvidingWeakPower", "side", "Lmods/eln/misc/Direction;", "publishSerialize", "", "stream", "Ljava/io/DataOutputStream;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "Eln"})
public abstract class Node
extends NodeBase {
    private int lastLight;
    private boolean oldSendedRedstone;

    public final int getLightValue() {
        return this.lastLight;
    }

    public final void setLightValue(int light) {
        int light2 = light;
        if (light2 > 15) {
            light2 = 15;
        }
        if (light2 < 0) {
            light2 = 0;
        }
        if (this.lastLight != light2) {
            this.lastLight = light2;
            this.coordinate.world().func_147463_c(EnumSkyBlock.Block, this.coordinate.x, this.coordinate.y, this.coordinate.z);
            this.setNeedPublish(true);
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.lastLight = nbt.func_74771_c("lastLight");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74774_a("lastLight", (byte)this.lastLight);
    }

    public final boolean getOldSendedRedstone() {
        return this.oldSendedRedstone;
    }

    public final void setOldSendedRedstone(boolean bl) {
        this.oldSendedRedstone = bl;
    }

    @Override
    public void publishSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishSerialize(stream);
        try {
            boolean redstone = this.canConnectRedstone();
            stream.writeByte(this.lastLight | (redstone ? 16 : 0));
            if (redstone != this.oldSendedRedstone) {
                this.needNotify = true;
            }
            this.oldSendedRedstone = redstone;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final NodeBlockEntity getEntity() {
        TileEntity tileEntity = this.coordinate.world().func_147438_o(this.coordinate.x, this.coordinate.y, this.coordinate.z);
        Intrinsics.checkNotNull(tileEntity, "null cannot be cast to non-null type mods.eln.node.NodeBlockEntity");
        return (NodeBlockEntity)tileEntity;
    }

    public int isProvidingWeakPower(@Nullable Direction side) {
        return 0;
    }

    public boolean canConnectRedstone() {
        return false;
    }
}

