/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.JvmStatic;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.TypeIntrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0012\u0010 \u001a\u0004\u0018\u00010\b2\b\u0010!\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u0007J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010)J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001d2\b\u0010,\u001a\u0004\u0018\u00010\u0007J\u0010\u0010-\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\bJ\u0016\u0010.\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u000200J\u0010\u00103\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00065"}, d2={"Lmods/eln/node/NodeManager;", "Lnet/minecraft/world/WorldSavedData;", "par1Str", "", "(Ljava/lang/String;)V", "nodeArray", "Ljava/util/HashMap;", "Lmods/eln/misc/Coordinate;", "Lmods/eln/node/NodeBase;", "getNodeArray", "()Ljava/util/HashMap;", "nodeList", "", "getNodeList", "()Ljava/util/Collection;", "nodes", "Ljava/util/ArrayList;", "getNodes", "()Ljava/util/ArrayList;", "rand", "Ljava/util/Random;", "getRand", "()Ljava/util/Random;", "setRand", "(Ljava/util/Random;)V", "randomNode", "getRandomNode", "()Lmods/eln/node/NodeBase;", "addNode", "", "node", "clear", "getNodeFromCoordonate", "nodeCoordinate", "getTransparentNodeFromCoordinate", "Lmods/eln/node/transparent/TransparentNodeElement;", "coord", "isDirty", "", "loadFromNbt", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromNBT", "removeCoordonate", "c", "removeNode", "saveToNbt", "dim", "", "unload", "dimensionId", "writeToNBT", "Companion", "Eln"})
public final class NodeManager
extends WorldSavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Coordinate, NodeBase> nodeArray;
    @NotNull
    private final ArrayList<NodeBase> nodes;
    @NotNull
    private Random rand = new Random();
    @JvmField
    @Nullable
    public static NodeManager instance;
    @NotNull
    private static final HashMap<String, Class<?>> UUIDToClass;

    public NodeManager(@Nullable String par1Str) {
        super(par1Str);
        this.nodeArray = new HashMap();
        this.nodes = new ArrayList();
        instance = this;
    }

    @NotNull
    public final HashMap<Coordinate, NodeBase> getNodeArray() {
        return this.nodeArray;
    }

    @NotNull
    public final ArrayList<NodeBase> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final Collection<NodeBase> getNodeList() {
        Collection<NodeBase> collection = this.nodeArray.values();
        Intrinsics.checkNotNullExpressionValue(collection, "nodeArray.values");
        return collection;
    }

    public final void addNode(@NotNull NodeBase node) {
        Intrinsics.checkNotNullParameter(node, "node");
        NodeBase old = this.nodeArray.put(node.coordinate, node);
        if (old != null) {
            this.nodes.remove(old);
        }
        this.nodes.add(node);
        Utils.println("NodeManager has " + this.nodeArray.size() + "node");
    }

    public final void removeNode(@Nullable NodeBase node) {
        if (node == null) {
            return;
        }
        this.nodeArray.remove(node.coordinate);
        this.nodes.remove(node);
        Utils.println("NodeManager has " + this.nodeArray.size() + "node");
    }

    public final void removeCoordonate(@Nullable Coordinate c) {
        NodeBase n = (NodeBase)TypeIntrinsics.asMutableMap(this.nodeArray).remove(c);
        if (n != null) {
            this.nodes.remove(n);
        }
        Utils.println("NodeManager has " + this.nodeArray.size() + "node");
    }

    public boolean func_76188_b() {
        return true;
    }

    public void func_76184_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
    }

    public void func_76187_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
    }

    @Nullable
    public final NodeBase getNodeFromCoordonate(@Nullable Coordinate nodeCoordinate) {
        return (NodeBase)((Map)this.nodeArray).get(nodeCoordinate);
    }

    @Nullable
    public final TransparentNodeElement getTransparentNodeFromCoordinate(@Nullable Coordinate coord) {
        NodeBase base = this.getNodeFromCoordonate(coord);
        if (base instanceof TransparentNode) {
            return ((TransparentNode)base).element;
        }
        return null;
    }

    @NotNull
    public final Random getRand() {
        return this.rand;
    }

    public final void setRand(@NotNull Random random) {
        Intrinsics.checkNotNullParameter(random, "<set-?>");
        this.rand = random;
    }

    @Nullable
    public final NodeBase getRandomNode() {
        return this.nodes.isEmpty() ? null : this.nodes.get(this.rand.nextInt(this.nodes.size()));
    }

    public final void loadFromNbt(@Nullable NBTTagCompound nbt) {
        List addedNode = new ArrayList();
        NBTTagCompound nBTTagCompound = nbt;
        Intrinsics.checkNotNull(nBTTagCompound);
        Iterator<Object> iterator2 = Utils.getTags(nBTTagCompound).iterator();
        while (iterator2.hasNext()) {
            NBTTagCompound o;
            NBTTagCompound tag = o = iterator2.next();
            Class<?> nodeClass = UUIDToClass.get(tag.func_74779_i("tag"));
            try {
                Class<?> clazz = nodeClass;
                Intrinsics.checkNotNull(clazz);
                Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.NodeBase");
                NodeBase node = (NodeBase)obj;
                node.readFromNBT(tag);
                this.addNode(node);
                addedNode.add(node);
                node.initializeFromNBT();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (NodeBase n : addedNode) {
            n.globalBoot();
        }
    }

    public final void saveToNbt(@NotNull NBTTagCompound nbt, int dim) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        int nodeCounter = 0;
        List nodesCopy = new ArrayList();
        nodesCopy.addAll((Collection)this.nodes);
        for (NodeBase node : nodesCopy) {
            try {
                if (!node.mustBeSaved() || dim != Integer.MIN_VALUE && node.coordinate.dimension != dim) continue;
                NBTTagCompound nbtNode = new NBTTagCompound();
                nbtNode.func_74778_a("tag", node.getNodeUuid());
                node.writeToNBT(nbtNode);
                nbt.func_74782_a("" + 'n' + nodeCounter++, (NBTBase)nbtNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void clear() {
        this.nodes.clear();
        this.nodeArray.clear();
    }

    public final void unload(int dimensionId) {
        Iterator<NodeBase> iterator2 = this.nodes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "nodes.iterator()");
        Iterator<NodeBase> i = iterator2;
        while (i.hasNext()) {
            NodeBase n;
            Intrinsics.checkNotNullExpressionValue(i.next(), "i.next()");
            if (n.coordinate.dimension != dimensionId) continue;
            n.unload();
            i.remove();
            this.nodeArray.remove(n.coordinate);
        }
    }

    @JvmStatic
    public static final void registerUuid(@NotNull String uuid, @NotNull Class<?> classType) {
        Companion.registerUuid(uuid, classType);
    }

    static {
        UUIDToClass = new HashMap();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmods/eln/node/NodeManager$Companion;", "", "()V", "UUIDToClass", "Ljava/util/HashMap;", "", "Ljava/lang/Class;", "getUUIDToClass", "()Ljava/util/HashMap;", "instance", "Lmods/eln/node/NodeManager;", "registerUuid", "", "uuid", "classType", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, Class<?>> getUUIDToClass() {
            return UUIDToClass;
        }

        @JvmStatic
        public final void registerUuid(@NotNull String uuid, @NotNull Class<?> classType) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(classType, "classType");
            ((Map)this.getUUIDToClass()).put(uuid, classType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

