/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.simple;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.node.NodeBase;
import mods.eln.node.simple.DescriptorManager;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtThermalLoad;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00100\u001a\u000201H\u0004J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\n\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u000203H&J\b\u00108\u001a\u000203H\u0016J$\u00109\u001a\u0002032\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0010\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u0002032\u0006\u0010B\u001a\u00020CH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R \u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R \u0010)\u001a\b\u0012\u0004\u0012\u00020*0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0011\"\u0004\b,\u0010\u0013R \u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0011\"\u0004\b/\u0010\u0013\u00a8\u0006E"}, d2={"Lmods/eln/node/simple/SimpleNode;", "Lmods/eln/node/NodeBase;", "()V", "descriptorKey", "", "getDescriptorKey", "()Ljava/lang/String;", "setDescriptorKey", "(Ljava/lang/String;)V", "electricalComponentList", "Ljava/util/ArrayList;", "Lmods/eln/sim/mna/component/Component;", "electricalLoadList", "Lmods/eln/sim/mna/state/State;", "electricalProcessList", "Lmods/eln/sim/IProcess;", "getElectricalProcessList", "()Ljava/util/ArrayList;", "setElectricalProcessList", "(Ljava/util/ArrayList;)V", "value", "Lmods/eln/misc/Direction;", "front", "getFront", "()Lmods/eln/misc/Direction;", "setFront", "(Lmods/eln/misc/Direction;)V", "removedByPlayer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "getRemovedByPlayer", "()Lnet/minecraft/entity/player/EntityPlayerMP;", "setRemovedByPlayer", "(Lnet/minecraft/entity/player/EntityPlayerMP;)V", "slowProcessList", "thermalConnectionList", "Lmods/eln/sim/ThermalConnection;", "getThermalConnectionList", "setThermalConnectionList", "thermalFastProcessList", "getThermalFastProcessList", "setThermalFastProcessList", "thermalLoadList", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoadList", "setThermalLoadList", "thermalSlowProcessList", "getThermalSlowProcessList", "setThermalSlowProcessList", "applayFrontToMetadata", "", "connectJob", "", "disconnectJob", "getDescriptor", "", "initialize", "initializeFromNBT", "initializeFromThat", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "itemStack", "Lnet/minecraft/item/ItemStack;", "publishSerialize", "stream", "Ljava/io/DataOutputStream;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "Eln"})
public abstract class SimpleNode
extends NodeBase {
    @Nullable
    private EntityPlayerMP removedByPlayer;
    @Nullable
    private String descriptorKey = "";
    @Nullable
    private Direction front;
    @JvmField
    @NotNull
    public ArrayList<IProcess> slowProcessList = new ArrayList(4);
    @NotNull
    private ArrayList<IProcess> electricalProcessList = new ArrayList(4);
    @JvmField
    @NotNull
    public ArrayList<Component> electricalComponentList = new ArrayList(4);
    @JvmField
    @NotNull
    public ArrayList<State> electricalLoadList = new ArrayList(4);
    @NotNull
    private ArrayList<IProcess> thermalFastProcessList = new ArrayList(4);
    @NotNull
    private ArrayList<IProcess> thermalSlowProcessList = new ArrayList(4);
    @NotNull
    private ArrayList<ThermalConnection> thermalConnectionList = new ArrayList(4);
    @NotNull
    private ArrayList<NbtThermalLoad> thermalLoadList = new ArrayList(4);

    @Nullable
    public final EntityPlayerMP getRemovedByPlayer() {
        return this.removedByPlayer;
    }

    public final void setRemovedByPlayer(@Nullable EntityPlayerMP entityPlayerMP) {
        this.removedByPlayer = entityPlayerMP;
    }

    @Nullable
    public String getDescriptorKey() {
        return this.descriptorKey;
    }

    public void setDescriptorKey(@Nullable String string) {
        this.descriptorKey = string;
    }

    @Nullable
    public Object getDescriptor() {
        return DescriptorManager.get(this.getDescriptorKey());
    }

    @Nullable
    public final Direction getFront() {
        return this.front;
    }

    public final void setFront(@Nullable Direction value) {
        this.front = value;
        if (this.applayFrontToMetadata() && this.front != null) {
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            this.coordinate.setMetadata(direction.getInt());
        }
    }

    protected final boolean applayFrontToMetadata() {
        return false;
    }

    @Override
    public void initializeFromThat(@NotNull Direction front, @Nullable EntityLivingBase entityLiving, @Nullable ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)front, "front");
        this.setFront(front);
        this.initialize();
    }

    @Override
    public void initializeFromNBT() {
        this.initialize();
    }

    public abstract void initialize();

    @Override
    public void publishSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishSerialize(stream);
        try {
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            stream.writeByte(direction.getInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final ArrayList<IProcess> getElectricalProcessList() {
        return this.electricalProcessList;
    }

    public final void setElectricalProcessList(@NotNull ArrayList<IProcess> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.electricalProcessList = arrayList;
    }

    @NotNull
    public final ArrayList<IProcess> getThermalFastProcessList() {
        return this.thermalFastProcessList;
    }

    public final void setThermalFastProcessList(@NotNull ArrayList<IProcess> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.thermalFastProcessList = arrayList;
    }

    @NotNull
    public final ArrayList<IProcess> getThermalSlowProcessList() {
        return this.thermalSlowProcessList;
    }

    public final void setThermalSlowProcessList(@NotNull ArrayList<IProcess> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.thermalSlowProcessList = arrayList;
    }

    @NotNull
    public final ArrayList<ThermalConnection> getThermalConnectionList() {
        return this.thermalConnectionList;
    }

    public final void setThermalConnectionList(@NotNull ArrayList<ThermalConnection> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.thermalConnectionList = arrayList;
    }

    @NotNull
    public final ArrayList<NbtThermalLoad> getThermalLoadList() {
        return this.thermalLoadList;
    }

    public final void setThermalLoadList(@NotNull ArrayList<NbtThermalLoad> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.thermalLoadList = arrayList;
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.addAllSlowProcess(this.slowProcessList);
        Eln.simulator.addAllElectricalComponent((Iterable<Component>)this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.addElectricalLoad(state);
        }
        Eln.simulator.addAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.addAllThermalConnection((Iterable<ThermalConnection>)this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.addThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.addAllThermalFastProcess(this.thermalFastProcessList);
        Eln.simulator.addAllThermalSlowProcess(this.thermalSlowProcessList);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.removeAllSlowProcess(this.slowProcessList);
        Eln.simulator.removeAllElectricalComponent((Iterable<Component>)this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.removeElectricalLoad(state);
        }
        Eln.simulator.removeAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.removeAllThermalConnection((Iterable<ThermalConnection>)this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.removeThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.removeAllThermalFastProcess(this.thermalFastProcessList);
        Eln.simulator.removeAllThermalSlowProcess(this.thermalSlowProcessList);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.setFront(Direction.Companion.readFromNBT(nbt, "SNfront"));
        this.setDescriptorKey(nbt.func_74779_i("SNdescriptorKey"));
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).readFromNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.readFromNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalSlowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        Direction direction = this.front;
        Intrinsics.checkNotNull((Object)direction);
        direction.writeToNBT(nbt, "SNfront");
        nbt.func_74778_a("SNdescriptorKey", this.getDescriptorKey() == null ? "" : this.getDescriptorKey());
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).writeToNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.writeToNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalSlowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
    }
}

