/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.simple;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.INodeEntity;
import mods.eln.node.NodeEntityClientSender;
import mods.eln.node.NodeManager;
import mods.eln.node.simple.DescriptorManager;
import mods.eln.node.simple.SimpleNode;
import mods.eln.node.simple.SimpleNodeBlock;
import mods.eln.server.DelayedBlockRemove;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001e\u001a\u00020\u001fJ\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0017J2\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010'2\b\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020.J\u0006\u00101\u001a\u00020\u001fJ\u0006\u00102\u001a\u00020\u001fJ\b\u00103\u001a\u00020\u001fH\u0016J\u0006\u00104\u001a\u00020\u001fJ\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lmods/eln/node/simple/SimpleNodeEntity;", "Lnet/minecraft/tileentity/TileEntity;", "Lmods/eln/node/INodeEntity;", "nodeUuid", "", "(Ljava/lang/String;)V", "descriptor", "", "getDescriptor", "()Ljava/lang/Object;", "front", "Lmods/eln/misc/Direction;", "getFront", "()Lmods/eln/misc/Direction;", "setFront", "(Lmods/eln/misc/Direction;)V", "node", "Lmods/eln/node/simple/SimpleNode;", "getNode", "()Lmods/eln/node/simple/SimpleNode;", "setNode", "(Lmods/eln/node/simple/SimpleNode;)V", "getNodeUuid", "()Ljava/lang/String;", "sender", "Lmods/eln/node/NodeEntityClientSender;", "getSender", "()Lmods/eln/node/NodeEntityClientSender;", "setSender", "(Lmods/eln/node/NodeEntityClientSender;)V", "destructor", "", "getDescriptionPacket", "Lnet/minecraft/network/Packet;", "invalidate", "newContainer", "Lnet/minecraft/inventory/Container;", "side", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "onBlockActivated", "", "entityPlayer", "vx", "", "vy", "vz", "onBlockAdded", "onBreakBlock", "onChunkUnload", "onNeighborBlockChange", "serverPacketUnserialize", "stream", "Ljava/io/DataInputStream;", "serverPublishUnserialize", "Eln"})
@SourceDebugExtension(value={"SMAP\nSimpleNodeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleNodeEntity.kt\nmods/eln/node/simple/SimpleNodeEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public abstract class SimpleNodeEntity
extends TileEntity
implements INodeEntity {
    @NotNull
    private final String nodeUuid;
    @Nullable
    private SimpleNode node;
    @Nullable
    private Direction front;
    public NodeEntityClientSender sender;

    public SimpleNodeEntity(@NotNull String nodeUuid) {
        Intrinsics.checkNotNullParameter(nodeUuid, "nodeUuid");
        this.nodeUuid = nodeUuid;
        Utils.println("NodeUUID: " + this.getNodeUuid());
        this.setSender(new NodeEntityClientSender(this, this.getNodeUuid()));
    }

    @Override
    @NotNull
    public String getNodeUuid() {
        return this.nodeUuid;
    }

    @Nullable
    public SimpleNode getNode() {
        if (this.field_145850_b.field_72995_K) {
            Utils.fatal();
            return null;
        }
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.node == null) {
            NodeManager nodeManager = NodeManager.instance;
            Intrinsics.checkNotNull((Object)nodeManager);
            World world = this.field_145850_b;
            Intrinsics.checkNotNullExpressionValue(world, "worldObj");
            this.node = (SimpleNode)nodeManager.getNodeFromCoordonate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e, world));
            if (this.node == null) {
                World world2 = this.field_145850_b;
                Intrinsics.checkNotNullExpressionValue(world2, "worldObj");
                DelayedBlockRemove.Companion.add(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e, world2));
                return null;
            }
        }
        return this.node;
    }

    public void setNode(@Nullable SimpleNode simpleNode) {
        this.node = simpleNode;
    }

    public final void onBlockAdded() {
    }

    public final void onBreakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getNode() == null) {
                return;
            }
            SimpleNode simpleNode = this.getNode();
            Intrinsics.checkNotNull(simpleNode);
            simpleNode.onBreakBlock();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.destructor();
        }
    }

    public final void destructor() {
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K) {
            this.destructor();
        }
        super.func_145843_s();
    }

    public final boolean onBlockActivated(@Nullable EntityPlayer entityPlayer, @Nullable Direction side, float vx, float vy, float vz) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getNode() == null) {
                return false;
            }
            SimpleNode simpleNode = this.getNode();
            Intrinsics.checkNotNull(simpleNode);
            EntityPlayer entityPlayer2 = entityPlayer;
            Intrinsics.checkNotNull(entityPlayer2);
            Direction direction = side;
            Intrinsics.checkNotNull((Object)direction);
            simpleNode.onBlockActivated(entityPlayer2, direction, vx, vy, vz);
            return true;
        }
        return true;
    }

    public final void onNeighborBlockChange() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getNode() == null) {
                return;
            }
            SimpleNode simpleNode = this.getNode();
            Intrinsics.checkNotNull(simpleNode);
            simpleNode.onNeighborBlockChange();
        }
    }

    @Nullable
    public final Object getDescriptor() {
        Block block = this.func_145838_q();
        Intrinsics.checkNotNull(block, "null cannot be cast to non-null type mods.eln.node.simple.SimpleNodeBlock");
        SimpleNodeBlock b = (SimpleNodeBlock)block;
        return DescriptorManager.get(b.getDescriptorKey());
    }

    @Nullable
    public final Direction getFront() {
        return this.front;
    }

    public final void setFront(@Nullable Direction direction) {
        this.front = direction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serverPublishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            void it;
            Direction direction;
            Direction direction2 = direction = Direction.Companion.fromInt(stream.readByte());
            Direction direction3 = this.front;
            boolean bl = false;
            this.front = it;
            if (direction3 != direction) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serverPacketUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
    }

    @Nullable
    public Packet func_145844_m() {
        SimpleNode node = this.getNode();
        if (node == null) {
            Utils.println("ASSERT NULL NODE public Packet getDescriptionPacket() nodeblock entity");
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = node.getPublishPacket();
        Intrinsics.checkNotNull(byteArrayOutputStream);
        return (Packet)new S3FPacketCustomPayload("miaouMod", byteArrayOutputStream.toByteArray());
    }

    @NotNull
    public NodeEntityClientSender getSender() {
        NodeEntityClientSender nodeEntityClientSender = this.sender;
        if (nodeEntityClientSender != null) {
            return nodeEntityClientSender;
        }
        Intrinsics.throwUninitializedPropertyAccessException("sender");
        return null;
    }

    public void setSender(@NotNull NodeEntityClientSender nodeEntityClientSender) {
        Intrinsics.checkNotNullParameter(nodeEntityClientSender, "<set-?>");
        this.sender = nodeEntityClientSender;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return null;
    }
}

