/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUCubeMask;
import mods.eln.misc.Utils;
import mods.eln.node.ISixNodeCache;
import mods.eln.node.Node;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeConnection;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.server.PlayerManager;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Component;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 p2\u00020\u0001:\u0001pB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J \u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-J\u0018\u0010.\u001a\u00020\u00042\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010*\u001a\u00020+J\b\u00101\u001a\u00020%H\u0016J\u001c\u00102\u001a\u00020%2\b\u00103\u001a\u0004\u0018\u00010+2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u00103\u001a\u00020+2\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0004\u0018\u00010\u001c2\u0006\u00103\u001a\u00020+J\u0010\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00103\u001a\u00020+J\u0018\u0010=\u001a\u0002092\u0006\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0016J\u000e\u0010>\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+J\"\u0010?\u001a\u0004\u0018\u00010@2\u0006\u00103\u001a\u00020+2\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u000209H\u0016J\b\u0010A\u001a\u00020%H\u0016J\u0010\u0010B\u001a\u00020\u00042\u0006\u00103\u001a\u00020+H\u0016J\u0006\u0010C\u001a\u00020\u0004J\b\u0010D\u001a\u00020%H\u0016J$\u0010E\u001a\u00020%2\u0006\u0010F\u001a\u00020+2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010I\u001a\u0002092\b\u00103\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010J\u001a\u00020\u00152\u0006\u00103\u001a\u00020+H\u0016J\u001a\u0010K\u001a\u00020%2\u0006\u0010L\u001a\u00020M2\b\u0010,\u001a\u0004\u0018\u000100H\u0016J\u001a\u0010N\u001a\u00020%2\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\u0004H\u0016J\u0018\u0010R\u001a\u0004\u0018\u00010S2\u0006\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\b\u0010T\u001a\u00020\u0004H\u0016J0\u0010U\u001a\u00020\u00042\u0006\u0010/\u001a\u00020-2\u0006\u00103\u001a\u00020+2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020W2\u0006\u0010Y\u001a\u00020WH\u0016J\u0006\u0010Z\u001a\u00020WJ\u0018\u0010[\u001a\u00020\u00042\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010*\u001a\u00020+J\u0016\u0010\\\u001a\u00020%2\u0006\u0010L\u001a\u00020]2\u0006\u0010^\u001a\u00020\u001cJ\u0010\u0010_\u001a\u00020%2\u0006\u0010L\u001a\u00020]H\u0016J&\u0010`\u001a\u00020\u00042\b\u00103\u001a\u0004\u0018\u00010+2\b\u0010a\u001a\u0004\u0018\u00010b2\b\u0010c\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010d\u001a\u00020%2\u0006\u0010e\u001a\u00020bH\u0016J\u0006\u0010f\u001a\u00020%J\u0010\u0010g\u001a\u00020\u00152\u0006\u00103\u001a\u00020+H\u0016J6\u0010h\u001a\u00020%2\u0006\u00103\u001a\u00020+2\u0006\u0010i\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010j\u001a\u00020+2\u0006\u0010k\u001a\u00020\u001c2\u0006\u0010l\u001a\u000205J\b\u0010m\u001a\u00020%H\u0016J&\u0010n\u001a\u00020\u00042\b\u00103\u001a\u0004\u0018\u00010+2\b\u0010a\u001a\u0004\u0018\u00010b2\b\u0010c\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010o\u001a\u00020%2\u0006\u0010e\u001a\u00020bH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u0012\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001a\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lmods/eln/node/six/SixNode;", "Lmods/eln/node/Node;", "()V", "ifSideRemain", "", "getIfSideRemain", "()Z", "internalElectricalConnectionList", "Ljava/util/ArrayList;", "Lmods/eln/sim/ElectricalConnection;", "getInternalElectricalConnectionList", "()Ljava/util/ArrayList;", "setInternalElectricalConnectionList", "(Ljava/util/ArrayList;)V", "internalThermalConnectionList", "Lmods/eln/sim/ThermalConnection;", "getInternalThermalConnectionList", "setInternalThermalConnectionList", "lrduElementMask", "Lmods/eln/misc/LRDUCubeMask;", "nodeUuid", "", "getNodeUuid", "()Ljava/lang/String;", "sideElementIdList", "", "sideElementList", "", "Lmods/eln/node/six/SixNodeElement;", "[Lmods/eln/node/six/SixNodeElement;", "sixNodeCacheBlock", "Lnet/minecraft/block/Block;", "mods.eln.shadow.kotlin.jvm.PlatformType", "sixNodeCacheBlockMeta", "", "canConnectRedstone", "connectInit", "", "connectJob", "createSubBlock", "itemStack", "Lnet/minecraft/item/ItemStack;", "direction", "Lmods/eln/misc/Direction;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "deleteSubBlock", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "disconnectJob", "externalDisconnect", "side", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "", "getElement", "getInventory", "Lnet/minecraft/inventory/IInventory;", "getSideConnectionMask", "getSideEnable", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "globalBoot", "hasGui", "hasVolume", "initializeFromNBT", "initializeFromThat", "front", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "isProvidingWeakPower", "multiMeterString", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newConnectionAt", "connection", "Lmods/eln/node/NodeConnection;", "isA", "newContainer", "Lnet/minecraft/inventory/Container;", "nodeAutoSave", "onBlockActivated", "vx", "", "vy", "vz", "physicalSelfDestructionExplosionStrength", "playerAskToBreakSubBlock", "preparePacketForClient", "Ljava/io/DataOutputStream;", "e", "publishSerialize", "readConfigTool", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "readFromNBT", "nbt", "recalculateLightValue", "thermoMeterString", "tryConnectTwoInternalElement", "element", "otherSide", "otherElement", "otherLRDU", "unload", "writeConfigTool", "writeToNBT", "Companion", "Eln"})
@SourceDebugExtension(value={"SMAP\nSixNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SixNode.kt\nmods/eln/node/six/SixNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,527:1\n1#2:528\n*E\n"})
public final class SixNode
extends Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public SixNodeElement[] sideElementList = new SixNodeElement[6];
    @JvmField
    @NotNull
    public int[] sideElementIdList = new int[6];
    @NotNull
    private ArrayList<ElectricalConnection> internalElectricalConnectionList = new ArrayList(1);
    @NotNull
    private ArrayList<ThermalConnection> internalThermalConnectionList = new ArrayList(1);
    @JvmField
    public Block sixNodeCacheBlock = Blocks.field_150350_a;
    @JvmField
    public byte sixNodeCacheBlockMeta;
    @JvmField
    @NotNull
    public LRDUCubeMask lrduElementMask = new LRDUCubeMask();
    @JvmField
    @NotNull
    public static final ArrayList<ISixNodeCache> sixNodeCacheList = new ArrayList();

    public SixNode() {
        for (int idx = 0; idx < 6; ++idx) {
            this.sideElementList[idx] = null;
            this.sideElementIdList[idx] = 0;
        }
        this.lrduElementMask.clear();
    }

    @NotNull
    public final ArrayList<ElectricalConnection> getInternalElectricalConnectionList() {
        return this.internalElectricalConnectionList;
    }

    public final void setInternalElectricalConnectionList(@NotNull ArrayList<ElectricalConnection> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.internalElectricalConnectionList = arrayList;
    }

    @NotNull
    public final ArrayList<ThermalConnection> getInternalThermalConnectionList() {
        return this.internalThermalConnectionList;
    }

    public final void setInternalThermalConnectionList(@NotNull ArrayList<ThermalConnection> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.internalThermalConnectionList = arrayList;
    }

    @Nullable
    public final SixNodeElement getElement(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return this.sideElementList[side.getInt()];
    }

    @Override
    public boolean canConnectRedstone() {
        for (SixNodeElement element : this.sideElementList) {
            if (element == null || !element.canConnectRedstone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int isProvidingWeakPower(@Nullable Direction side) {
        int value = 0;
        for (SixNodeElement element : this.sideElementList) {
            int eValue;
            if (element == null || (eValue = element.isProvidingWeakPower()) <= value) continue;
            value = eValue;
        }
        return value;
    }

    public final boolean createSubBlock(@NotNull ItemStack itemStack, @NotNull Direction direction, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(itemStack);
        if (this.sideElementList[direction.getInt()] != null) {
            return false;
        }
        try {
            this.sideElementIdList[direction.getInt()] = itemStack.func_77960_j();
            int n = direction.getInt();
            SixNodeDescriptor sixNodeDescriptor = descriptor;
            Intrinsics.checkNotNull(sixNodeDescriptor);
            Object[] objectArray = new Class[]{SixNode.class, Direction.class, SixNodeDescriptor.class};
            Constructor<?> constructor = sixNodeDescriptor.ElementClass.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{this, direction, descriptor};
            Object obj = constructor.newInstance(objectArray);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.six.SixNodeElement");
            this.sideElementList[n] = (SixNodeElement)obj;
            this.sideElementIdList[direction.getInt()] = 0;
            this.disconnect();
            Intrinsics.checkNotNull(this.sideElementList[direction.getInt()]);
            EntityPlayer entityPlayer = player;
            Intrinsics.checkNotNull(entityPlayer);
            LRDU lRDU = descriptor.getFrontFromPlace(direction, entityPlayer);
            Intrinsics.checkNotNull((Object)lRDU);
            this.sideElementList[direction.getInt()].front = lRDU;
            SixNodeElement sixNodeElement = this.sideElementList[direction.getInt()];
            Intrinsics.checkNotNull(sixNodeElement);
            sixNodeElement.initialize();
            this.sideElementIdList[direction.getInt()] = itemStack.func_77960_j();
            this.connect();
            Utils.println("createSubBlock " + this.sideElementIdList[direction.getInt()] + ' ' + (Object)((Object)direction));
            this.setNeedPublish(true);
            return true;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return false;
    }

    public final boolean playerAskToBreakSubBlock(@Nullable EntityPlayerMP entityPlayer, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        if (this.sideElementList[direction.getInt()] == null) {
            return this.deleteSubBlock(entityPlayer, direction);
        }
        SixNodeElement sixNodeElement = this.sideElementList[direction.getInt()];
        Intrinsics.checkNotNull(sixNodeElement);
        return sixNodeElement.playerAskToBreak() ? this.deleteSubBlock(entityPlayer, direction) : false;
    }

    public final boolean deleteSubBlock(@Nullable EntityPlayerMP entityPlayer, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        if (this.sideElementList[direction.getInt()] == null) {
            return false;
        }
        Utils.println("deleteSubBlock  " + (Object)((Object)direction));
        this.disconnect();
        SixNodeElement e = this.sideElementList[direction.getInt()];
        this.sideElementList[direction.getInt()] = null;
        this.sideElementIdList[direction.getInt()] = 0;
        SixNodeElement sixNodeElement = e;
        Intrinsics.checkNotNull(sixNodeElement);
        sixNodeElement.destroy(entityPlayer);
        this.connect();
        this.recalculateLightValue();
        this.setNeedPublish(true);
        return true;
    }

    public final boolean getIfSideRemain() {
        for (SixNodeElement sideElement : this.sideElementList) {
            if (sideElement == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        NBTTagCompound nBTTagCompound = nbt.func_74775_l("node");
        Intrinsics.checkNotNullExpressionValue(nBTTagCompound, "nbt.getCompoundTag(\"node\")");
        super.readFromNBT(nBTTagCompound);
        this.sixNodeCacheBlock = Block.func_149729_e((int)nbt.func_74762_e("cacheBlockId"));
        this.sixNodeCacheBlockMeta = nbt.func_74771_c("cacheBlockMeta");
        int idx = 0;
        for (idx = 0; idx < 6; ++idx) {
            short sideElementId = nbt.func_74765_d("EID" + idx);
            if (sideElementId == 0) {
                this.sideElementList[idx] = null;
                this.sideElementIdList[idx] = 0;
                continue;
            }
            try {
                SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(sideElementId);
                this.sideElementIdList[idx] = sideElementId;
                SixNodeDescriptor sixNodeDescriptor = descriptor;
                Intrinsics.checkNotNull(sixNodeDescriptor);
                Object[] objectArray = new Class[]{SixNode.class, Direction.class, SixNodeDescriptor.class};
                Constructor<?> constructor = sixNodeDescriptor.ElementClass.getConstructor((Class<?>[])objectArray);
                objectArray = new Object[]{this, Direction.Companion.fromInt(idx), descriptor};
                Object obj = constructor.newInstance(objectArray);
                Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.six.SixNodeElement");
                this.sideElementList[idx] = (SixNodeElement)obj;
                SixNodeElement sixNodeElement = this.sideElementList[idx];
                Intrinsics.checkNotNull(sixNodeElement);
                NBTTagCompound nBTTagCompound2 = nbt.func_74775_l("ED" + idx);
                Intrinsics.checkNotNullExpressionValue(nBTTagCompound2, "nbt.getCompoundTag(\"ED$idx\")");
                sixNodeElement.readFromNBT(nBTTagCompound2);
                SixNodeElement sixNodeElement2 = this.sideElementList[idx];
                Intrinsics.checkNotNull(sixNodeElement2);
                sixNodeElement2.initialize();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        this.initializeFromNBT();
    }

    @Override
    public boolean nodeAutoSave() {
        return false;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        int idx = 0;
        nbt.func_74768_a("cacheBlockId", Block.func_149682_b((Block)this.sixNodeCacheBlock));
        nbt.func_74774_a("cacheBlockMeta", this.sixNodeCacheBlockMeta);
        for (SixNodeElement sideElement : this.sideElementList) {
            if (sideElement == null) {
                nbt.func_74777_a("EID" + idx, (short)0);
            } else {
                nbt.func_74777_a("EID" + idx, (short)this.sideElementIdList[idx]);
                sideElement.writeToNBT(Utils.newNbtTagCompund(nbt, "ED" + idx));
            }
            ++idx;
        }
        NBTTagCompound nodeNbt = new NBTTagCompound();
        super.writeToNBT(nodeNbt);
        nbt.func_74782_a("node", (NBTBase)nodeNbt);
    }

    public final boolean getSideEnable(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        return this.sideElementList[direction.getInt()] != null;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement sixNodeElement = this.sideElementList[elementSide.getInt()];
        if (sixNodeElement == null) {
            return null;
        }
        SixNodeElement element = sixNodeElement;
        LRDU lRDU = elementSide.getLRDUGoingTo(side);
        Intrinsics.checkNotNull((Object)lRDU);
        return element.getElectricalLoad(lRDU, mask);
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement sixNodeElement = this.sideElementList[elementSide.getInt()];
        if (sixNodeElement == null) {
            return null;
        }
        SixNodeElement element = sixNodeElement;
        LRDU lRDU = elementSide.getLRDUGoingTo(side);
        Intrinsics.checkNotNull((Object)lRDU);
        return element.getThermalLoad(lRDU, mask);
    }

    @Override
    public int getSideConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement sixNodeElement = this.sideElementList[elementSide.getInt()];
        if (sixNodeElement == null) {
            return 0;
        }
        SixNodeElement element = sixNodeElement;
        LRDU lRDU = elementSide.getLRDUGoingTo(side);
        Intrinsics.checkNotNull((Object)lRDU);
        return element.getConnectionMask(lRDU);
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
        if (sixNodeElement == null) {
            return "";
        }
        SixNodeElement element = sixNodeElement;
        return element.multiMeterString();
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
        if (sixNodeElement == null) {
            return "";
        }
        SixNodeElement element = sixNodeElement;
        return element.thermoMeterString();
    }

    @Override
    public boolean readConfigTool(@Nullable Direction side, @Nullable NBTTagCompound tag, @Nullable EntityPlayer invoker) {
        Direction direction = side;
        Intrinsics.checkNotNull((Object)direction);
        SixNodeElement element = this.sideElementList[direction.getInt()];
        if (element instanceof IConfigurable) {
            ((IConfigurable)((Object)element)).readConfigTool(tag, invoker);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeConfigTool(@Nullable Direction side, @Nullable NBTTagCompound tag, @Nullable EntityPlayer invoker) {
        Direction direction = side;
        Intrinsics.checkNotNull((Object)direction);
        SixNodeElement element = this.sideElementList[direction.getInt()];
        if (element instanceof IConfigurable) {
            ((IConfigurable)((Object)element)).writeConfigTool(tag, invoker);
            return true;
        }
        return false;
    }

    @Override
    public void publishSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishSerialize(stream);
        try {
            int idx = 0;
            stream.writeInt(Block.func_149682_b((Block)this.sixNodeCacheBlock));
            stream.writeByte(this.sixNodeCacheBlockMeta);
            for (SixNodeElement sideElement : this.sideElementList) {
                if (sideElement == null) {
                    stream.writeShort(0);
                } else {
                    stream.writeShort(this.sideElementIdList[idx]);
                    sideElement.networkSerialize(stream);
                }
                ++idx;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void preparePacketForClient(@NotNull DataOutputStream stream, @NotNull SixNodeElement e) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(e, "e");
        try {
            super.preparePacketForClient(stream);
            int side = e.side.getInt();
            stream.writeByte(side);
            stream.writeShort(e.sixNodeElementDescriptor.parentItemDamage);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void initializeFromThat(@NotNull Direction front, @Nullable EntityLivingBase entityLiving, @Nullable ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)front, "front");
        this.neighborBlockRead();
    }

    @Override
    public void initializeFromNBT() {
        this.connect();
    }

    @Override
    public void connectInit() {
        super.connectInit();
        this.internalElectricalConnectionList.clear();
        this.internalThermalConnectionList.clear();
        this.lrduElementMask.clear();
    }

    @Override
    public void connectJob() {
        LRDU otherLRDU;
        SixNodeElement otherElement;
        Direction otherSide;
        super.connectJob();
        SixNodeElement[] sixNodeElementArray = this.sideElementList;
        int n = sixNodeElementArray.length;
        for (int i = 0; i < n; ++i) {
            SixNodeElement element;
            SixNodeElement sixNodeElement = element = sixNodeElementArray[i];
            if (sixNodeElement == null) continue;
            sixNodeElement.connectJob();
        }
        SixNode $this$connectJob_u24lambda_u240 = this;
        boolean bl = false;
        Direction side = Direction.YN;
        SixNodeElement element = $this$connectJob_u24lambda_u240.sideElementList[side.getInt()];
        if (element != null) {
            for (LRDU lrdu : LRDU.values()) {
                otherSide = side.applyLRDU(lrdu);
                otherElement = $this$connectJob_u24lambda_u240.sideElementList[otherSide.getInt()];
                if (otherElement == null) continue;
                Intrinsics.checkNotNull((Object)otherSide.getLRDUGoingTo(side));
                $this$connectJob_u24lambda_u240.tryConnectTwoInternalElement(side, element, lrdu, otherSide, otherElement, otherLRDU);
            }
        }
        SixNode $this$connectJob_u24lambda_u241 = this;
        boolean bl2 = false;
        side = Direction.YP;
        element = $this$connectJob_u24lambda_u241.sideElementList[side.getInt()];
        if (element != null) {
            for (LRDU lrdu : LRDU.values()) {
                otherSide = side.applyLRDU(lrdu);
                otherElement = $this$connectJob_u24lambda_u241.sideElementList[otherSide.getInt()];
                if (otherElement == null) continue;
                Intrinsics.checkNotNull((Object)otherSide.getLRDUGoingTo(side));
                $this$connectJob_u24lambda_u241.tryConnectTwoInternalElement(side, element, lrdu, otherSide, otherElement, otherLRDU);
            }
        }
        SixNode $this$connectJob_u24lambda_u242 = this;
        boolean bl3 = false;
        side = Direction.XN;
        for (int idx = 0; idx < 4; ++idx) {
            Direction otherSide2 = side.right();
            SixNodeElement element2 = $this$connectJob_u24lambda_u242.sideElementList[side.getInt()];
            SixNodeElement otherElement2 = $this$connectJob_u24lambda_u242.sideElementList[otherSide2.getInt()];
            if (element2 != null && otherElement2 != null) {
                $this$connectJob_u24lambda_u242.tryConnectTwoInternalElement(side, element2, LRDU.Right, otherSide2, otherElement2, LRDU.Left);
            }
            side = otherSide2;
        }
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        SixNodeElement[] sixNodeElementArray = this.sideElementList;
        int n = sixNodeElementArray.length;
        for (int i = 0; i < n; ++i) {
            SixNodeElement element;
            SixNodeElement sixNodeElement = element = sixNodeElementArray[i];
            if (sixNodeElement == null) continue;
            sixNodeElement.disconnectJob();
        }
        Eln.simulator.removeAllElectricalConnection((Iterable<ElectricalConnection>)this.internalElectricalConnectionList);
        Eln.simulator.removeAllThermalConnection((Iterable<ThermalConnection>)this.internalThermalConnectionList);
    }

    public final void tryConnectTwoInternalElement(@NotNull Direction side, @NotNull SixNodeElement element, @NotNull LRDU lrdu, @NotNull Direction otherSide, @NotNull SixNodeElement otherElement, @NotNull LRDU otherLRDU) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        Intrinsics.checkNotNullParameter((Object)otherSide, "otherSide");
        Intrinsics.checkNotNullParameter(otherElement, "otherElement");
        Intrinsics.checkNotNullParameter((Object)otherLRDU, "otherLRDU");
        Utils.println("SixNode.tCTIE:");
        int mskThis = element.getConnectionMask(lrdu);
        int mskOther = otherElement.getConnectionMask(otherLRDU);
        if (NodeBase.Companion.compareConnectionMask(mskThis, mskOther)) {
            ThermalLoad otherTLoad;
            Object eCon;
            ElectricalLoad otherELoad;
            ElectricalLoad electricalLoad;
            Utils.println("\tConnection OK.");
            this.lrduElementMask.set(side, lrdu, true);
            this.lrduElementMask.set(otherSide, otherLRDU, true);
            NodeConnection nodeConnection = new NodeConnection(this, side, lrdu, this, otherSide, otherLRDU);
            this.nodeConnectionList.add(nodeConnection);
            element.newConnectionAt(nodeConnection, false);
            otherElement.newConnectionAt(nodeConnection, true);
            ElectricalLoad eLoad = null;
            ElectricalLoad it = electricalLoad = element.getElectricalLoad(lrdu, mskOther);
            boolean bl = false;
            eLoad = it;
            if (electricalLoad != null && (otherELoad = otherElement.getElectricalLoad(otherLRDU, mskThis)) != null) {
                eCon = new ElectricalConnection(eLoad, otherELoad);
                Eln.simulator.addElectricalComponent((Component)eCon);
                this.internalElectricalConnectionList.add((ElectricalConnection)eCon);
                nodeConnection.addConnection((ElectricalConnection)eCon);
            }
            ThermalLoad tLoad = null;
            eCon = this.getThermalLoad(side, lrdu, mskOther);
            ThermalLoad it2 = eCon;
            boolean bl2 = false;
            tLoad = it2;
            if (eCon != null && (otherTLoad = element.getThermalLoad(otherLRDU, mskThis)) != null) {
                ThermalConnection tCon = new ThermalConnection(tLoad, otherTLoad);
                Eln.simulator.addThermalConnection(tCon);
                this.internalThermalConnectionList.add(tCon);
                nodeConnection.addConnection(tCon);
            }
        }
    }

    @Override
    public void newConnectionAt(@Nullable NodeConnection connection, boolean isA) {
        Direction direction;
        if (isA) {
            NodeConnection nodeConnection = connection;
            Intrinsics.checkNotNull(nodeConnection);
            direction = nodeConnection.getDir1();
        } else {
            NodeConnection nodeConnection = connection;
            Intrinsics.checkNotNull(nodeConnection);
            direction = nodeConnection.getDir2();
        }
        Direction side = direction;
        LRDU lrdu = isA ? connection.getLrdu1() : connection.getLrdu2();
        Direction elementSide = side.applyLRDU(lrdu);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            Utils.println("sixnode newConnectionAt error");
            while (true) {
                // Infinite loop
            }
        }
        LRDU lRDU = elementSide.getLRDUGoingTo(side);
        Intrinsics.checkNotNull((Object)lRDU);
        this.lrduElementMask.set(elementSide, lRDU, true);
        element.newConnectionAt(connection, isA);
    }

    @Override
    public void externalDisconnect(@Nullable Direction side, @Nullable LRDU lrdu) {
        Direction direction = side;
        Intrinsics.checkNotNull((Object)direction);
        LRDU lRDU = lrdu;
        Intrinsics.checkNotNull((Object)lRDU);
        Direction elementSide = direction.applyLRDU(lRDU);
        SixNodeElement element = this.sideElementList[elementSide.getInt()];
        if (element == null) {
            Utils.println("sixnode newConnectionAt error");
            while (true) {
                // Infinite loop
            }
        }
        LRDU lRDU2 = elementSide.getLRDUGoingTo(side);
        Intrinsics.checkNotNull((Object)lRDU2);
        this.lrduElementMask.set(elementSide, lRDU2, false);
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        boolean bl;
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (this.sixNodeCacheBlock != Blocks.field_150350_a) {
            bl = false;
        } else {
            ItemStack stack = entityPlayer.func_71045_bC();
            Block b = Blocks.field_150350_a;
            if (stack != null) {
                b = Block.func_149634_a((Item)stack.func_77973_b());
            }
            boolean accepted = false;
            PlayerManager.PlayerMetadata playerMetadata = Eln.playerManager.get(entityPlayer);
            Intrinsics.checkNotNull(playerMetadata);
            if (playerMetadata.getInteractEnable() && stack != null) {
                for (ISixNodeCache a : sixNodeCacheList) {
                    if (!a.accept(stack)) continue;
                    accepted = true;
                    this.sixNodeCacheBlock = b;
                    this.sixNodeCacheBlockMeta = (byte)a.getMeta(stack);
                    break;
                }
            }
            if (accepted) {
                Utils.println("ACACAC");
                this.setNeedPublish(true);
                if (!Utils.isCreative((EntityPlayerMP)entityPlayer)) {
                    entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                }
                SixNode $this$onBlockActivated_u24lambda_u245 = this;
                boolean bl2 = false;
                Chunk chunk = $this$onBlockActivated_u24lambda_u245.coordinate.world().func_72938_d($this$onBlockActivated_u24lambda_u245.coordinate.x, $this$onBlockActivated_u24lambda_u245.coordinate.z);
                Utils.generateHeightMap(chunk);
                Intrinsics.checkNotNullExpressionValue(chunk, "chunk");
                Utils.updateSkylight(chunk);
                chunk.func_76603_b();
                Utils.updateAllLightTypes($this$onBlockActivated_u24lambda_u245.coordinate.world(), $this$onBlockActivated_u24lambda_u245.coordinate.x, $this$onBlockActivated_u24lambda_u245.coordinate.y, $this$onBlockActivated_u24lambda_u245.coordinate.z);
                bl = true;
            } else {
                SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
                if (sixNodeElement == null) {
                    return false;
                }
                SixNodeElement element = sixNodeElement;
                bl = element.onBlockActivated(entityPlayer, side, vx, vy, vz) ? true : super.onBlockActivated(entityPlayer, side, vx, vy, vz);
            }
        }
        return bl;
    }

    @Override
    public boolean hasGui(@NotNull Direction side) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (this.sideElementList[side.getInt()] == null) {
            bl = false;
        } else {
            SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
            Intrinsics.checkNotNull(sixNodeElement);
            bl = sixNodeElement.hasGui();
        }
        return bl;
    }

    @Nullable
    public final IInventory getInventory(@NotNull Direction side) {
        IInventory iInventory;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (this.sideElementList[side.getInt()] == null) {
            iInventory = null;
        } else {
            SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
            Intrinsics.checkNotNull(sixNodeElement);
            iInventory = sixNodeElement.getInventory();
        }
        return iInventory;
    }

    @Nullable
    public final Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Container container;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.sideElementList[side.getInt()] == null) {
            container = null;
        } else {
            SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
            Intrinsics.checkNotNull(sixNodeElement);
            container = sixNodeElement.newContainer(side, player);
        }
        return container;
    }

    public final float physicalSelfDestructionExplosionStrength() {
        return 1.0f;
    }

    public final void recalculateLightValue() {
        int light = 0;
        for (SixNodeElement element : this.sideElementList) {
            int eLight;
            if (element == null || (eLight = element.getLightValue()) <= light) continue;
            light = eLight;
        }
        this.setLightValue(light);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream, @Nullable EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream, player);
        Direction side = null;
        try {
            side = Direction.Companion.fromInt(stream.readByte());
            if (side != null && this.sideElementIdList[side.getInt()] == stream.readShort()) {
                SixNodeElement sixNodeElement = this.sideElementList[side.getInt()];
                Intrinsics.checkNotNull(sixNodeElement);
                sixNodeElement.networkUnserialize(stream, player);
            } else {
                Utils.println("sixnode unserialize miss");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final boolean hasVolume() {
        for (SixNodeElement element : this.sideElementList) {
            if (element == null || !element.sixNodeElementDescriptor.hasVolume()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getNodeUuid() {
        return Eln.sixNodeBlock.getNodeUuid();
    }

    @Override
    public void globalBoot() {
        super.globalBoot();
        for (SixNodeElement e : this.sideElementList) {
            if (e == null) continue;
            e.globalBoot();
        }
    }

    @Override
    public void unload() {
        super.unload();
        for (SixNodeElement e : this.sideElementList) {
            if (e == null) continue;
            e.unload();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmods/eln/node/six/SixNode$Companion;", "", "()V", "sixNodeCacheList", "Ljava/util/ArrayList;", "Lmods/eln/node/ISixNodeCache;", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

