/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.client.ClientProxy;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import mods.eln.sound.LoopedSoundManager;
import mods.eln.sound.SoundCommand;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0005J\b\u0010=\u001a\u00020&H\u0016J\u000e\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u00020 J\u0016\u0010@\u001a\u00020:2\u0006\u0010?\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ\u0016\u0010C\u001a\u00020:2\u0006\u0010?\u001a\u00020A2\u0006\u0010B\u001a\u00020DJ\u0016\u0010E\u001a\u00020:2\u0006\u0010?\u001a\u00020 2\u0006\u0010B\u001a\u00020FJ\u001e\u0010E\u001a\u00020:2\u0006\u0010?\u001a\u00020 2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020FJ\u0016\u0010I\u001a\u00020:2\u0006\u0010?\u001a\u00020A2\u0006\u0010B\u001a\u00020 J\u0016\u0010J\u001a\u00020:2\u0006\u0010?\u001a\u00020A2\u0006\u0010K\u001a\u00020LJ\u0006\u0010M\u001a\u00020:J\b\u0010N\u001a\u00020:H\u0016J\b\u0010O\u001a\u00020&H\u0016J\b\u0010P\u001a\u00020:H\u0016J\u0010\u0010Q\u001a\u00020:2\b\u0010R\u001a\u0004\u0018\u00010SJ\u001a\u0010Q\u001a\u00020:2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010R\u001a\u0004\u0018\u00010SJ\u001a\u0010T\u001a\u00020:2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010R\u001a\u0004\u0018\u00010SJ\u0010\u0010U\u001a\u00020:2\b\u0010R\u001a\u0004\u0018\u00010SJ\u001a\u0010U\u001a\u00020:2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010R\u001a\u0004\u0018\u00010SJ\u0012\u0010V\u001a\u00020 2\b\u0010W\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010X\u001a\u0004\u0018\u00010Y2\u0006\u0010W\u001a\u00020\u001eH\u0016J\u0006\u0010Z\u001a\u00020 J\u0006\u0010[\u001a\u00020:J\b\u0010\\\u001a\u00020:H\u0016J\b\u0010]\u001a\u00020&H\u0016J\u0012\u0010^\u001a\u00020 2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0006\u0010_\u001a\u00020:J\u0012\u0010`\u001a\u00020:2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010c\u001a\u00020dH\u0016J\u0006\u0010e\u001a\u00020:J\u000e\u0010f\u001a\u00020:2\u0006\u0010g\u001a\u00020hJ\u000e\u0010i\u001a\u00020:2\u0006\u0010j\u001a\u00020kJ\u0010\u0010l\u001a\u00020:2\u0006\u0010j\u001a\u00020mH\u0016J\u0010\u0010n\u001a\u00020:2\u0006\u0010o\u001a\u00020FH\u0016J\u0010\u0010p\u001a\u00020:2\b\u0010q\u001a\u0004\u0018\u00010rJ\u0012\u0010s\u001a\u00020:2\b\u0010j\u001a\u0004\u0018\u00010mH\u0016J\u0010\u0010t\u001a\u00020:2\b\u0010j\u001a\u0004\u0018\u00010mJ\u0006\u0010u\u001a\u00020&R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010(\"\u0004\b3\u0010*R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lmods/eln/node/six/SixNodeElementRender;", "", "tileEntity", "Lmods/eln/node/six/SixNodeEntity;", "side", "Lmods/eln/misc/Direction;", "sixNodeDescriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNodeEntity;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "cableList", "", "getCableList", "()[I", "setCableList", "([I)V", "cableListReady", "", "getCableListReady", "()[Z", "setCableListReady", "([Z)V", "connectedSide", "Lmods/eln/misc/LRDUMask;", "connectionType", "Lmods/eln/cable/CableRenderType;", "getConnectionType", "()Lmods/eln/cable/CableRenderType;", "setConnectionType", "(Lmods/eln/cable/CableRenderType;)V", "front", "Lmods/eln/misc/LRDU;", "glList", "", "getGlList", "()I", "setGlList", "(I)V", "glListReady", "", "getGlListReady", "()Z", "setGlListReady", "(Z)V", "inventory", "Lnet/minecraft/inventory/IInventory;", "getInventory", "()Lnet/minecraft/inventory/IInventory;", "loopedSoundManager", "Lmods/eln/sound/LoopedSoundManager;", "needRedraw", "getNeedRedraw", "setNeedRedraw", "getTileEntity", "()Lmods/eln/node/six/SixNodeEntity;", "setTileEntity", "(Lmods/eln/node/six/SixNodeEntity;)V", "uuid", "addLoopedSound", "", "loopedSound", "Lmods/eln/sound/LoopedSound;", "cameraDrawOptimisation", "clientSend", "id", "clientSetByte", "", "value", "clientSetDouble", "", "clientSetFloat", "", "value1", "value2", "clientSetInt", "clientSetString", "text", "", "destructor", "draw", "drawCableAuto", "drawCables", "drawPowerPin", "d", "", "drawPowerPinWhite", "drawSignalPin", "getCableDry", "lrdu", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "getUuid", "glListCall", "glListDraw", "glListEnable", "isProvidingWeakPower", "needRedrawCable", "newConnectionType", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "notifyNeighborSpawn", "play", "s", "Lmods/eln/sound/SoundCommand;", "preparePacketForServer", "stream", "Ljava/io/DataOutputStream;", "publishUnserialize", "Ljava/io/DataInputStream;", "refresh", "deltaT", "sendPacketToServer", "bos", "Ljava/io/ByteArrayOutputStream;", "serverPacketUnserialize", "singleUnserialize", "usedUuid", "Eln"})
public abstract class SixNodeElementRender {
    @NotNull
    private SixNodeEntity tileEntity;
    @JvmField
    @NotNull
    public Direction side;
    @JvmField
    @NotNull
    public SixNodeDescriptor sixNodeDescriptor;
    @JvmField
    @NotNull
    public LRDUMask connectedSide;
    private int glList;
    @NotNull
    private int[] cableList;
    @NotNull
    private boolean[] cableListReady;
    private boolean glListReady;
    private boolean needRedraw;
    @JvmField
    @Nullable
    public LRDU front;
    @Nullable
    private CableRenderType connectionType;
    private int uuid;
    @NotNull
    private final LoopedSoundManager loopedSoundManager;

    public SixNodeElementRender(@NotNull SixNodeEntity tileEntity, @NotNull Direction side, @NotNull SixNodeDescriptor sixNodeDescriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(sixNodeDescriptor, "sixNodeDescriptor");
        this.tileEntity = tileEntity;
        this.side = side;
        this.sixNodeDescriptor = sixNodeDescriptor;
        this.connectedSide = new LRDUMask();
        this.cableList = new int[4];
        boolean[] blArray = new boolean[]{false, false, false, false};
        this.cableListReady = blArray;
        this.loopedSoundManager = new LoopedSoundManager(0.0f, 1, null);
        if (this.glListEnable()) {
            this.glList = UtilsClient.glGenListsSafe();
        }
        this.cableList[0] = UtilsClient.glGenListsSafe();
        this.cableList[1] = UtilsClient.glGenListsSafe();
        this.cableList[2] = UtilsClient.glGenListsSafe();
        this.cableList[3] = UtilsClient.glGenListsSafe();
    }

    @NotNull
    public SixNodeEntity getTileEntity() {
        return this.tileEntity;
    }

    public void setTileEntity(@NotNull SixNodeEntity sixNodeEntity) {
        Intrinsics.checkNotNullParameter(sixNodeEntity, "<set-?>");
        this.tileEntity = sixNodeEntity;
    }

    public final int getGlList() {
        return this.glList;
    }

    public final void setGlList(int n) {
        this.glList = n;
    }

    @NotNull
    public final int[] getCableList() {
        return this.cableList;
    }

    public final void setCableList(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.cableList = nArray;
    }

    @NotNull
    public final boolean[] getCableListReady() {
        return this.cableListReady;
    }

    public final void setCableListReady(@NotNull boolean[] blArray) {
        Intrinsics.checkNotNullParameter(blArray, "<set-?>");
        this.cableListReady = blArray;
    }

    public final boolean getGlListReady() {
        return this.glListReady;
    }

    public final void setGlListReady(boolean bl) {
        this.glListReady = bl;
    }

    public final void needRedrawCable() {
        this.needRedraw = true;
    }

    public final void drawPowerPin(@Nullable float[] d) {
        this.drawPowerPin(this.front, d);
    }

    public final void drawPowerPin(@Nullable LRDU front, @Nullable float[] d) {
        if (UtilsClient.distanceFromClientPlayer(this.getTileEntity()) > 20.0f) {
            return;
        }
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        LRDU lRDU = front;
        Intrinsics.checkNotNull((Object)lRDU);
        Intrinsics.checkNotNull(d);
        UtilsClient.drawConnectionPinSixNode(lRDU, d, 1.8f, 0.9f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public final void drawPowerPinWhite(@Nullable LRDU front, @Nullable float[] d) {
        if (UtilsClient.distanceFromClientPlayer(this.getTileEntity()) > 20.0f) {
            return;
        }
        LRDU lRDU = front;
        Intrinsics.checkNotNull((Object)lRDU);
        Intrinsics.checkNotNull(d);
        UtilsClient.drawConnectionPinSixNode(lRDU, d, 1.8f, 0.9f);
    }

    public final void drawSignalPin(@Nullable float[] d) {
        this.drawSignalPin(this.front, d);
    }

    public final void drawSignalPin(@Nullable LRDU front, @Nullable float[] d) {
        if (UtilsClient.distanceFromClientPlayer(this.getTileEntity()) > 20.0f) {
            return;
        }
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        LRDU lRDU = front;
        Intrinsics.checkNotNull((Object)lRDU);
        Intrinsics.checkNotNull(d);
        UtilsClient.drawConnectionPinSixNode(lRDU, d, 0.9f, 0.9f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public final boolean getNeedRedraw() {
        return this.needRedraw;
    }

    public final void setNeedRedraw(boolean bl) {
        this.needRedraw = bl;
    }

    public void newConnectionType(@Nullable CableRenderType connectionType) {
    }

    public void drawCables() {
        for (int idx = 0; idx < 4; ++idx) {
            CableRenderDescriptor render = this.getCableRender(LRDU.Companion.fromInt(idx));
            this.cableListReady[idx] = false;
            if (render == null || (this.connectedSide.getMask() & 1 << idx) == 0) continue;
            GL11.glNewList((int)this.cableList[idx], (int)4864);
            LRDUMask lRDUMask = new LRDUMask(1 << idx);
            CableRenderType cableRenderType = this.connectionType;
            Intrinsics.checkNotNull(cableRenderType);
            CableRender.drawCable$default(render, lRDUMask, cableRenderType, 0.0f, false, 24, null);
            GL11.glEndList();
            this.cableListReady[idx] = true;
        }
    }

    public void draw() {
        if (this.needRedraw) {
            this.needRedraw = false;
            this.connectionType = CableRender.connectionType(this, this.side);
            this.newConnectionType(this.connectionType);
            if (this.drawCableAuto()) {
                this.drawCables();
            }
        }
        for (int idx = 0; idx < 4; ++idx) {
            CableRenderType cableRenderType = this.connectionType;
            Intrinsics.checkNotNull(cableRenderType);
            Utils.setGlColorFromDye(cableRenderType.otherdry[idx]);
            if (!this.cableListReady[idx]) continue;
            CableRenderDescriptor cableRenderDescriptor = this.getCableRender(LRDU.Companion.fromInt(idx));
            Intrinsics.checkNotNull(cableRenderDescriptor);
            UtilsClient.bindTexture(cableRenderDescriptor.cableTexture);
            GL11.glCallList((int)this.cableList[idx]);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean drawCableAuto() {
        return true;
    }

    public boolean glListEnable() {
        return true;
    }

    public final void glListCall() {
        if (!this.glListEnable()) {
            return;
        }
        if (!this.glListReady) {
            GL11.glNewList((int)this.glList, (int)4864);
            this.glListDraw();
            GL11.glEndList();
            this.glListReady = true;
        }
        GL11.glCallList((int)this.glList);
    }

    public void glListDraw() {
    }

    @Nullable
    public final CableRenderType getConnectionType() {
        return this.connectionType;
    }

    public final void setConnectionType(@Nullable CableRenderType cableRenderType) {
        this.connectionType = cableRenderType;
    }

    public int isProvidingWeakPower(@Nullable Direction side) {
        return 0;
    }

    public void publishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            byte b = stream.readByte();
            this.connectedSide.set(b & 0xF);
            this.front = LRDU.Companion.fromInt(b >> 4 & 3);
            this.needRedraw = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.glListReady = false;
    }

    public final void singleUnserialize(@Nullable DataInputStream stream) {
    }

    public final int getUuid() {
        if (this.uuid == 0) {
            this.uuid = UtilsClient.getUuid();
        }
        return this.uuid;
    }

    public final boolean usedUuid() {
        return this.uuid != 0;
    }

    public final void play(@NotNull SoundCommand s) {
        Intrinsics.checkNotNullParameter(s, "s");
        s.addUuid(this.getUuid());
        s.set(this.getTileEntity());
        s.play();
    }

    public final void destructor() {
        if (this.usedUuid()) {
            ClientProxy.uuidManager.kill(this.uuid);
        }
        if (this.glListEnable()) {
            UtilsClient.glDeleteListsSafe(this.glList);
        }
        UtilsClient.glDeleteListsSafe(this.cableList[0]);
        UtilsClient.glDeleteListsSafe(this.cableList[1]);
        UtilsClient.glDeleteListsSafe(this.cableList[2]);
        UtilsClient.glDeleteListsSafe(this.cableList[3]);
        this.loopedSoundManager.dispose();
    }

    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return null;
    }

    @Nullable
    public IInventory getInventory() {
        return null;
    }

    public final void preparePacketForServer(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            this.getTileEntity().preparePacketForServer(stream);
            stream.writeByte(this.side.getInt());
            stream.writeShort(this.getTileEntity().elementRenderIdList[this.side.getInt()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void sendPacketToServer(@Nullable ByteArrayOutputStream bos) {
        this.getTileEntity().sendPacketToServer(bos);
    }

    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    public int getCableDry(@Nullable LRDU lrdu) {
        return 0;
    }

    public final void clientSetFloat(int id, float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSetFloat(int id, float value1, float value2) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeFloat(value1);
            stream.writeFloat(value2);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSetDouble(byte id, double value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeDouble(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSetString(byte id, @NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeUTF(text);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSetInt(byte id, int value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeInt(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSetByte(byte id, byte value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeByte(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSend(int id) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean cameraDrawOptimisation() {
        return true;
    }

    public void serverPacketUnserialize(@Nullable DataInputStream stream) throws IOException {
    }

    public final void notifyNeighborSpawn() {
        this.needRedraw = true;
    }

    @SideOnly(value=Side.CLIENT)
    protected final void addLoopedSound(@Nullable LoopedSound loopedSound) {
        this.loopedSoundManager.add(loopedSound);
    }

    public void refresh(float deltaT) {
        this.loopedSoundManager.process(deltaT);
    }
}

