/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.six;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.Node;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u001c\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J&\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\"J\u000e\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020$J(\u00101\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\"J\u0012\u00102\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u000206H\u0016J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010=\u001a\u00020\u001dH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006?"}, d2={"Lmods/eln/node/six/SixNodeEntity;", "Lmods/eln/node/NodeBlockEntity;", "()V", "elementRenderIdList", "", "elementRenderList", "", "Lmods/eln/node/six/SixNodeElementRender;", "[Lmods/eln/node/six/SixNodeElementRender;", "nodeUuid", "", "getNodeUuid", "()Ljava/lang/String;", "sixNodeCacheBlock", "Lnet/minecraft/block/Block;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getSixNodeCacheBlock", "()Lnet/minecraft/block/Block;", "setSixNodeCacheBlock", "(Lnet/minecraft/block/Block;)V", "sixNodeCacheBlockMeta", "", "getSixNodeCacheBlockMeta", "()B", "setSixNodeCacheBlockMeta", "(B)V", "cameraDrawOptimisation", "", "clientRefresh", "", "deltaT", "", "destructor", "getCableDry", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "getDamageValue", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "getSyncronizedSideEnable", "direction", "hasVolume", "isProvidingWeakPower", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "serverPacketUnserialize", "stream", "Ljava/io/DataInputStream;", "serverPublishUnserialize", "tileEntityNeighborSpawn", "Companion", "Eln"})
public final class SixNodeEntity
extends NodeBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public SixNodeElementRender[] elementRenderList = new SixNodeElementRender[6];
    @JvmField
    @NotNull
    public short[] elementRenderIdList = new short[6];
    private Block sixNodeCacheBlock = Blocks.field_150350_a;
    private byte sixNodeCacheBlockMeta;
    public static final int singleTargetId = 2;

    public SixNodeEntity() {
        for (int idx = 0; idx < 6; ++idx) {
            this.elementRenderList[idx] = null;
            this.elementRenderIdList[idx] = 0;
        }
    }

    public final Block getSixNodeCacheBlock() {
        return this.sixNodeCacheBlock;
    }

    public final void setSixNodeCacheBlock(Block block) {
        this.sixNodeCacheBlock = block;
    }

    public final byte getSixNodeCacheBlockMeta() {
        return this.sixNodeCacheBlockMeta;
    }

    public final void setSixNodeCacheBlockMeta(byte by) {
        this.sixNodeCacheBlockMeta = by;
    }

    @Override
    public void serverPublishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Block sixNodeCacheBlockOld = this.sixNodeCacheBlock;
        super.serverPublishUnserialize(stream);
        try {
            this.sixNodeCacheBlock = Block.func_149729_e((int)stream.readInt());
            this.sixNodeCacheBlockMeta = stream.readByte();
            int idx = 0;
            for (idx = 0; idx < 6; ++idx) {
                short id = stream.readShort();
                if (id == 0) {
                    this.elementRenderIdList[idx] = 0;
                    this.elementRenderList[idx] = null;
                    continue;
                }
                if (id != this.elementRenderIdList[idx]) {
                    boolean failed = false;
                    this.elementRenderIdList[idx] = id;
                    SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(id);
                    if (descriptor == null) {
                        Utils.println("ERROR: Server sent bad SixNodeDescriptor id " + id);
                        failed = true;
                    }
                    if (!failed) {
                        try {
                            SixNodeDescriptor sixNodeDescriptor = descriptor;
                            Intrinsics.checkNotNull(sixNodeDescriptor);
                            Object[] objectArray = new Class[]{SixNodeEntity.class, Direction.class, SixNodeDescriptor.class};
                            Constructor<?> constructor = sixNodeDescriptor.RenderClass.getConstructor((Class<?>[])objectArray);
                            objectArray = new Object[]{this, Direction.Companion.fromInt(idx), descriptor};
                            Object obj = constructor.newInstance(objectArray);
                            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.six.SixNodeElementRender");
                            this.elementRenderList[idx] = (SixNodeElementRender)obj;
                        }
                        catch (Exception e) {
                            StringBuilder stringBuilder = new StringBuilder().append("ERROR: Initialize SixNodeElementRender for id ").append(id).append(" descriptor ").append(descriptor).append(" RenderClass ");
                            SixNodeDescriptor sixNodeDescriptor = descriptor;
                            Intrinsics.checkNotNull(sixNodeDescriptor);
                            Utils.println(stringBuilder.append(sixNodeDescriptor.RenderClass).append(" failed with exception ").append(e).toString());
                            e.printStackTrace();
                            failed = true;
                        }
                    }
                    if (failed) {
                        Utils.println("ERROR: A previous failure has desynchronized the DataInputStream for this packet. No further information can be processed. If something isn't rendering right now, please post a bug report for this version of Electrical Age.");
                        Utils.println("... " + stream.available() + " bytes remained on the stream, consuming all of them");
                        stream.skip(stream.available());
                        break;
                    }
                }
                if (this.elementRenderList[idx] == null) continue;
                SixNodeElementRender sixNodeElementRender = this.elementRenderList[idx];
                Intrinsics.checkNotNull(sixNodeElementRender);
                sixNodeElementRender.publishUnserialize(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (this.sixNodeCacheBlock != sixNodeCacheBlockOld) {
            Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
            chunk.func_76590_a();
            Intrinsics.checkNotNullExpressionValue(chunk, "chunk");
            Utils.updateSkylight(chunk);
            chunk.func_76603_b();
            World world = this.field_145850_b;
            Intrinsics.checkNotNullExpressionValue(world, "worldObj");
            Utils.updateAllLightTypes(world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void serverPacketUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.serverPacketUnserialize(stream);
        try {
            byte side = stream.readByte();
            short id = stream.readShort();
            if (this.elementRenderIdList[side] == id) {
                SixNodeElementRender sixNodeElementRender = this.elementRenderList[side];
                Intrinsics.checkNotNull(sixNodeElementRender);
                sixNodeElementRender.serverPacketUnserialize(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final boolean getSyncronizedSideEnable(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        return this.elementRenderList[direction.getInt()] != null;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        SixNode sixNode = (SixNode)this.getNode();
        if (sixNode == null) {
            return null;
        }
        SixNode n = sixNode;
        return n.newContainer(side, player);
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        SixNodeElementRender sixNodeElementRender = this.elementRenderList[side.getInt()];
        Intrinsics.checkNotNull(sixNodeElementRender);
        return sixNodeElementRender.newGuiDraw(side, player);
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull Direction side, @NotNull LRDU lrdu) {
        CableRenderDescriptor cableRenderDescriptor;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        Direction side2 = side;
        side2 = side2.applyLRDU(lrdu);
        if (this.elementRenderList[side2.getInt()] == null) {
            cableRenderDescriptor = null;
        } else {
            SixNodeElementRender sixNodeElementRender = this.elementRenderList[side2.getInt()];
            Intrinsics.checkNotNull(sixNodeElementRender);
            cableRenderDescriptor = sixNodeElementRender.getCableRender(lrdu);
        }
        return cableRenderDescriptor;
    }

    @Override
    public int getCableDry(@Nullable Direction side, @Nullable LRDU lrdu) {
        int n;
        Direction side2;
        Direction direction = side2 = side;
        Intrinsics.checkNotNull((Object)direction);
        LRDU lRDU = lrdu;
        Intrinsics.checkNotNull((Object)lRDU);
        side2 = direction.applyLRDU(lRDU);
        if (this.elementRenderList[side2.getInt()] == null) {
            n = 0;
        } else {
            SixNodeElementRender sixNodeElementRender = this.elementRenderList[side2.getInt()];
            Intrinsics.checkNotNull(sixNodeElementRender);
            n = sixNodeElementRender.getCableDry(lrdu);
        }
        return n;
    }

    @Override
    public boolean cameraDrawOptimisation() {
        for (SixNodeElementRender e : this.elementRenderList) {
            if (e == null || e.cameraDrawOptimisation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void destructor() {
        SixNodeElementRender[] sixNodeElementRenderArray = this.elementRenderList;
        int n = sixNodeElementRenderArray.length;
        for (int i = 0; i < n; ++i) {
            SixNodeElementRender render;
            SixNodeElementRender sixNodeElementRender = render = sixNodeElementRenderArray[i];
            if (sixNodeElementRender == null) continue;
            sixNodeElementRender.destructor();
        }
        super.destructor();
    }

    public final int getDamageValue(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(world, "world");
        if (world.field_72995_K) {
            for (int idx = 0; idx < 6; ++idx) {
                if (this.elementRenderList[idx] == null) continue;
                return this.elementRenderIdList[idx];
            }
        }
        return 0;
    }

    public final boolean hasVolume(@Nullable World world, int x, int y, int z) {
        boolean bl;
        if (this.field_145850_b.field_72995_K) {
            for (SixNodeElementRender e : this.elementRenderList) {
                if (e == null || !e.sixNodeDescriptor.hasVolume()) continue;
                return true;
            }
            bl = false;
        } else {
            SixNode sixNode = (SixNode)this.getNode();
            if (sixNode == null) {
                return false;
            }
            SixNode node = sixNode;
            bl = node.hasVolume();
        }
        return bl;
    }

    @Override
    public void tileEntityNeighborSpawn() {
        SixNodeElementRender[] sixNodeElementRenderArray = this.elementRenderList;
        int n = sixNodeElementRenderArray.length;
        for (int i = 0; i < n; ++i) {
            SixNodeElementRender e;
            SixNodeElementRender sixNodeElementRender = e = sixNodeElementRenderArray[i];
            if (sixNodeElementRender == null) continue;
            sixNodeElementRender.notifyNeighborSpawn();
        }
    }

    @Override
    @NotNull
    public String getNodeUuid() {
        return Eln.sixNodeBlock.getNodeUuid();
    }

    @Override
    public void clientRefresh(float deltaT) {
        SixNodeElementRender[] sixNodeElementRenderArray = this.elementRenderList;
        int n = sixNodeElementRenderArray.length;
        for (int i = 0; i < n; ++i) {
            SixNodeElementRender e;
            SixNodeElementRender sixNodeElementRender = e = sixNodeElementRenderArray[i];
            if (sixNodeElementRender == null) continue;
            sixNodeElementRender.refresh(deltaT);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int isProvidingWeakPower(@Nullable Direction side) {
        int n;
        if (this.field_145850_b.field_72995_K) {
            void var2_2;
            int max = 0;
            for (SixNodeElementRender r : this.elementRenderList) {
                if (r == null || max >= r.isProvidingWeakPower(side)) continue;
                max = r.isProvidingWeakPower(side);
            }
            n = var2_2;
        } else if (this.getNode() == null) {
            n = 0;
        } else {
            Node node = this.getNode();
            Intrinsics.checkNotNull(node);
            n = node.isProvidingWeakPower(side);
        }
        return n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmods/eln/node/six/SixNodeEntity$Companion;", "", "()V", "singleTargetId", "", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

