/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import mods.eln.Eln;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.Node;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.IFluidHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001LB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J$\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u000207J\b\u00108\u001a\u00020\u0017H\u0016J0\u00109\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u0002072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020;H\u0016J\b\u0010>\u001a\u00020\u0015H\u0016J\b\u0010?\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u00020\u00152\u0006\u00102\u001a\u00020AH\u0016J&\u0010B\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u000107H\u0016J\u0010\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020DH\u0016J\u0010\u0010H\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010I\u001a\u00020\u0015H\u0016J&\u0010J\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u000107H\u0016J\u0010\u0010K\u001a\u00020\u00152\u0006\u0010G\u001a\u00020DH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lmods/eln/node/transparent/TransparentNode;", "Lmods/eln/node/Node;", "()V", "blockMetadata", "", "getBlockMetadata", "()I", "element", "Lmods/eln/node/transparent/TransparentNodeElement;", "elementId", "fluidHandler", "Lnet/minecraftforge/fluids/IFluidHandler;", "getFluidHandler", "()Lnet/minecraftforge/fluids/IFluidHandler;", "nodeUuid", "", "getNodeUuid", "()Ljava/lang/String;", "removedByPlayer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "checkCanStay", "", "onCreate", "", "connectJob", "disconnectJob", "dropElement", "entityPlayer", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "mask", "getInventory", "Lnet/minecraft/inventory/IInventory;", "getSideConnectionMask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "hasGui", "initializeFromNBT", "initializeFromThat", "front", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "itemStack", "Lnet/minecraft/item/ItemStack;", "multiMeterString", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "player", "newContainer", "Lnet/minecraft/inventory/Container;", "Lnet/minecraft/entity/player/EntityPlayer;", "nodeAutoSave", "onBlockActivated", "vx", "", "vy", "vz", "onBreakBlock", "onNeighborBlockChange", "publishSerialize", "Ljava/io/DataOutputStream;", "readConfigTool", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "readFromNBT", "nbt", "thermoMeterString", "unload", "writeConfigTool", "writeToNBT", "FrontType", "Eln"})
public final class TransparentNode
extends Node {
    @JvmField
    @Nullable
    public TransparentNodeElement element;
    @JvmField
    public int elementId;
    @JvmField
    @Nullable
    public EntityPlayerMP removedByPlayer;

    @Override
    public boolean nodeAutoSave() {
        return false;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.onNeighborBlockChange();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        NBTTagCompound nBTTagCompound = nbt.func_74775_l("node");
        Intrinsics.checkNotNullExpressionValue(nBTTagCompound, "nbt.getCompoundTag(\"node\")");
        super.readFromNBT(nBTTagCompound);
        this.elementId = nbt.func_74765_d("eid");
        try {
            TransparentNodeDescriptor descriptor;
            TransparentNodeDescriptor transparentNodeDescriptor = descriptor = (TransparentNodeDescriptor)Eln.transparentNodeItem.getDescriptor(this.elementId);
            Intrinsics.checkNotNull(transparentNodeDescriptor);
            Object[] objectArray = new Class[]{TransparentNode.class, TransparentNodeDescriptor.class};
            Constructor<?> constructor = transparentNodeDescriptor.getElementClass().getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{this, descriptor};
            Object obj = constructor.newInstance(objectArray);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.transparent.TransparentNodeElement");
            this.element = (TransparentNodeElement)obj;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        NBTTagCompound nBTTagCompound2 = nbt.func_74775_l("element");
        Intrinsics.checkNotNullExpressionValue(nBTTagCompound2, "nbt.getCompoundTag(\"element\")");
        transparentNodeElement.readFromNBT(nBTTagCompound2);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(Utils.newNbtTagCompund(nbt, "node"));
        nbt.func_74777_a("eid", (short)this.elementId);
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.writeToNBT(Utils.newNbtTagCompund(nbt, "element"));
    }

    @Override
    public void onBreakBlock() {
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.onBreakElement();
        super.onBreakBlock();
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.getElectricalLoad(side, lrdu);
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.getThermalLoad(side, lrdu);
    }

    @Override
    public int getSideConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.getConnectionMask(side, lrdu);
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.multiMeterString(side);
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.thermoMeterString(side);
    }

    @Override
    public boolean readConfigTool(@Nullable Direction side, @Nullable NBTTagCompound tag, @Nullable EntityPlayer invoker) {
        if (this.element instanceof IConfigurable) {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement, "null cannot be cast to non-null type mods.eln.item.IConfigurable");
            ((IConfigurable)((Object)transparentNodeElement)).readConfigTool(tag, invoker);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeConfigTool(@Nullable Direction side, @Nullable NBTTagCompound tag, @Nullable EntityPlayer invoker) {
        if (this.element instanceof IConfigurable) {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement, "null cannot be cast to non-null type mods.eln.item.IConfigurable");
            ((IConfigurable)((Object)transparentNodeElement)).writeConfigTool(tag, invoker);
            return true;
        }
        return false;
    }

    @Nullable
    public final IFluidHandler getFluidHandler() {
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.getFluidHandler();
    }

    @Override
    public void publishSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishSerialize(stream);
        try {
            stream.writeShort(this.elementId);
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement);
            transparentNodeElement.networkSerialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initializeFromThat(@NotNull Direction front, @Nullable EntityLivingBase entityLiving, @Nullable ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)front, "front");
        try {
            int metadata;
            TransparentNodeDescriptor descriptor = (TransparentNodeDescriptor)Eln.transparentNodeItem.getDescriptor(itemStack);
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNull(itemStack2);
            this.elementId = metadata = itemStack2.func_77960_j();
            TransparentNodeDescriptor transparentNodeDescriptor = descriptor;
            Intrinsics.checkNotNull(transparentNodeDescriptor);
            Object[] objectArray = new Class[]{TransparentNode.class, TransparentNodeDescriptor.class};
            Constructor<?> constructor = transparentNodeDescriptor.getElementClass().getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{this, descriptor};
            Object obj = constructor.newInstance(objectArray);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.transparent.TransparentNodeElement");
            TransparentNodeElement transparentNodeElement = this.element = (TransparentNodeElement)obj;
            Intrinsics.checkNotNull(transparentNodeElement);
            transparentNodeElement.initializeFromThat(front, entityLiving, itemStack.func_77978_p());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        Utils.println("TN.iFT element = " + this.element + " elId = " + this.elementId);
    }

    @Override
    public void initializeFromNBT() {
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.initialize();
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.onBlockActivated(entityPlayer, side, vx, vy, vz) ? true : super.onBlockActivated(entityPlayer, side, vx, vy, vz);
    }

    @Override
    public boolean hasGui(@NotNull Direction side) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (this.element == null) {
            bl = false;
        } else {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement);
            bl = transparentNodeElement.hasGui();
        }
        return bl;
    }

    @Nullable
    public final IInventory getInventory(@Nullable Direction side) {
        IInventory iInventory;
        if (this.element == null) {
            iInventory = null;
        } else {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement);
            iInventory = transparentNodeElement.getInventory();
        }
        return iInventory;
    }

    @Nullable
    public final Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Container container;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.element == null) {
            container = null;
        } else {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement);
            container = transparentNodeElement.newContainer(side, player);
        }
        return container;
    }

    @Override
    public int getBlockMetadata() {
        Utils.println("TN.gBM");
        Utils.println(this.element);
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        Utils.println(transparentNodeElement.transparentNodeDescriptor);
        TransparentNodeElement transparentNodeElement2 = this.element;
        Intrinsics.checkNotNull(transparentNodeElement2);
        return transparentNodeElement2.transparentNodeDescriptor.getTileEntityMetaTag().getMeta();
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream, @Nullable EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream, player);
        try {
            if (this.elementId == stream.readShort()) {
                TransparentNodeElement transparentNodeElement = this.element;
                Intrinsics.checkNotNull(transparentNodeElement);
                transparentNodeElement.networkUnserialize(stream, player);
            } else {
                Utils.println("Transparent node unserialize miss");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectJob() {
        super.connectJob();
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.connectJob();
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.disconnectJob();
    }

    @Override
    public void checkCanStay(boolean onCreate) {
        super.checkCanStay(onCreate);
        TransparentNodeElement transparentNodeElement = this.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        transparentNodeElement.checkCanStay(onCreate);
    }

    public final void dropElement(@Nullable EntityPlayerMP entityPlayer) {
        if (this.element != null && Utils.mustDropItem(entityPlayer)) {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement);
            this.dropItem(transparentNodeElement.getDropItemStack());
        }
    }

    @Override
    @NotNull
    public String getNodeUuid() {
        return Eln.transparentNodeBlock.getNodeUuid();
    }

    @Override
    public void unload() {
        super.unload();
        if (this.element != null) {
            TransparentNodeElement transparentNodeElement = this.element;
            Intrinsics.checkNotNull(transparentNodeElement);
            transparentNodeElement.unload();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lmods/eln/node/transparent/TransparentNode$FrontType;", "", "(Ljava/lang/String;I)V", "BlockSide", "PlayerView", "PlayerViewHorizontal", "BlockSideInv", "Eln"})
    public static final class FrontType
    extends Enum<FrontType> {
        public static final /* enum */ FrontType BlockSide = new FrontType();
        public static final /* enum */ FrontType PlayerView = new FrontType();
        public static final /* enum */ FrontType PlayerViewHorizontal = new FrontType();
        public static final /* enum */ FrontType BlockSideInv = new FrontType();
        private static final /* synthetic */ FrontType[] $VALUES;

        public static FrontType[] values() {
            return (FrontType[])$VALUES.clone();
        }

        public static FrontType valueOf(String value) {
            return Enum.valueOf(FrontType.class, value);
        }

        static {
            $VALUES = frontTypeArray = new FrontType[]{FrontType.BlockSide, FrontType.PlayerView, FrontType.PlayerViewHorizontal, FrontType.BlockSideInv};
        }
    }
}

