/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.util.List;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.ghost.GhostGroup;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.EntityMetaTag;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.NotImplementedError;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.JvmOverloads;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.ranges.RangesKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B3\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJB\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0018H\u0016J\u001c\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\u001c\u00105\u001a\u0004\u0018\u0001042\u0006\u00106\u001a\u0002042\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\u00162\b\u00103\u001a\u0004\u0018\u000104J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020;H\u0016J\b\u0010A\u001a\u00020;H\u0016J\b\u0010B\u001a\u00020;H\u0016J\b\u0010C\u001a\u00020;H\u0016J\u0010\u0010D\u001a\u00020&2\b\u0010E\u001a\u0004\u0018\u00010FJ1\u0010G\u001a\u00020&2\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020=2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020J0I\"\u00020JH\u0016\u00a2\u0006\u0002\u0010KJ \u0010L\u001a\u00020;2\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020=2\u0006\u0010M\u001a\u00020NH\u0016J&\u0010O\u001a\u00020;2\b\u0010>\u001a\u0004\u0018\u00010?2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016R\u001e\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020$8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lmods/eln/node/transparent/TransparentNodeDescriptor;", "Lmods/eln/generic/GenericItemBlockUsingDamageDescriptor;", "Lnet/minecraftforge/client/IItemRenderer;", "name", "", "ElementClass", "Ljava/lang/Class;", "RenderClass", "tileEntityMetaTag", "Lmods/eln/node/transparent/EntityMetaTag;", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;Lmods/eln/node/transparent/EntityMetaTag;)V", "getElementClass", "()Ljava/lang/Class;", "setElementClass", "(Ljava/lang/Class;)V", "getRenderClass", "setRenderClass", "frontType", "Lmods/eln/node/transparent/TransparentNode$FrontType;", "getFrontType", "()Lmods/eln/node/transparent/TransparentNode$FrontType;", "ghostGroup", "Lmods/eln/ghost/GhostGroup;", "ghostGroupUuid", "", "getGhostGroupUuid", "()I", "spawnDeltaX", "getSpawnDeltaX", "spawnDeltaY", "getSpawnDeltaY", "spawnDeltaZ", "getSpawnDeltaZ", "getTileEntityMetaTag", "()Lmods/eln/node/transparent/EntityMetaTag;", "voltageLevelColor", "Lmods/eln/misc/VoltageLevelColor;", "addCollisionBoxesToList", "", "par5AxisAlignedBB", "Lnet/minecraft/util/AxisAlignedBB;", "list", "", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "checkCanPlace", "coord", "Lmods/eln/misc/Coordinate;", "front", "Lmods/eln/misc/Direction;", "getFrontFromPlace", "side", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "getGhostGroupFront", "handleRenderType", "", "item", "Lnet/minecraft/item/ItemStack;", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "mustHaveCeiling", "mustHaveFloor", "mustHaveWall", "mustHaveWallFrontInverse", "objItemScale", "obj", "Lmods/eln/misc/Obj3D;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "shouldUseRenderHelperEln", "Eln"})
public class TransparentNodeDescriptor
extends GenericItemBlockUsingDamageDescriptor
implements IItemRenderer {
    @NotNull
    private Class<?> ElementClass;
    @NotNull
    private Class<?> RenderClass;
    @NotNull
    private final EntityMetaTag tileEntityMetaTag;
    @JvmField
    @NotNull
    protected VoltageLevelColor voltageLevelColor;
    @JvmField
    @Nullable
    public GhostGroup ghostGroup;

    @JvmOverloads
    public TransparentNodeDescriptor(@Nullable String name, @NotNull Class<?> ElementClass, @NotNull Class<?> RenderClass, @NotNull EntityMetaTag tileEntityMetaTag) {
        Intrinsics.checkNotNullParameter(ElementClass, "ElementClass");
        Intrinsics.checkNotNullParameter(RenderClass, "RenderClass");
        Intrinsics.checkNotNullParameter((Object)tileEntityMetaTag, "tileEntityMetaTag");
        super(name);
        this.ElementClass = ElementClass;
        this.RenderClass = RenderClass;
        this.tileEntityMetaTag = tileEntityMetaTag;
        this.voltageLevelColor = VoltageLevelColor.None;
    }

    public /* synthetic */ TransparentNodeDescriptor(String string, Class clazz, Class clazz2, EntityMetaTag entityMetaTag, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            entityMetaTag = EntityMetaTag.Basic;
        }
        this(string, clazz, clazz2, entityMetaTag);
    }

    @NotNull
    public final Class<?> getElementClass() {
        return this.ElementClass;
    }

    public final void setElementClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "<set-?>");
        this.ElementClass = clazz;
    }

    @NotNull
    public final Class<?> getRenderClass() {
        return this.RenderClass;
    }

    public final void setRenderClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "<set-?>");
        this.RenderClass = clazz;
    }

    @NotNull
    public final EntityMetaTag getTileEntityMetaTag() {
        return this.tileEntityMetaTag;
    }

    public boolean handleRenderType(@NotNull ItemStack item, @NotNull IItemRenderer.ItemRenderType type) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(type, "type");
        return this.voltageLevelColor != VoltageLevelColor.None;
    }

    public boolean shouldUseRenderHelper(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, @NotNull IItemRenderer.ItemRendererHelper helper) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(helper, "helper");
        return false;
    }

    public boolean shouldUseRenderHelperEln(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(data, "data");
        if (this.getIcon() == null) {
            return;
        }
        this.voltageLevelColor.drawIconBackground(type);
        String string = this.getIcon().func_94215_i();
        Intrinsics.checkNotNullExpressionValue(string, "icon.iconName");
        String string2 = string;
        int n = 4;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
        String icon = string3;
        UtilsClient.drawIcon(type, new ResourceLocation("eln", "textures/blocks/" + icon + ".png"));
    }

    public final void objItemScale(@Nullable Obj3D obj) {
        if (obj == null) {
            return;
        }
        float factor = obj.yDim * 0.6f;
        factor = RangesKt.coerceAtLeast(factor, (RangesKt.coerceAtLeast(obj.zMax, -obj.xMin) + Math.max(obj.xMax, -obj.zMin)) * 0.7f);
        factor = 1.0f / factor;
        GL11.glScalef((float)factor, (float)factor, (float)factor);
        GL11.glTranslatef((float)((RangesKt.coerceAtMost(obj.zMin, obj.xMin) + RangesKt.coerceAtLeast(obj.xMax, obj.zMax)) / (float)2 - (obj.xMax + obj.xMin) / (float)2), (float)(1.0f - (obj.xMax + obj.xMin) / (float)2 - (obj.zMax + obj.zMin) / (float)2 - (obj.yMax + obj.yMin) / (float)2), (float)0.0f);
    }

    @Nullable
    public TransparentNode.FrontType getFrontType() {
        return TransparentNode.FrontType.PlayerViewHorizontal;
    }

    public boolean mustHaveFloor() {
        return true;
    }

    public boolean mustHaveCeiling() {
        return false;
    }

    public boolean mustHaveWall() {
        return false;
    }

    public boolean mustHaveWallFrontInverse() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String checkCanPlace(@Nullable Coordinate coord, @NotNull Direction front) {
        GhostGroup ghostGroup;
        Coordinate temp;
        Intrinsics.checkNotNullParameter((Object)front, "front");
        Block block = null;
        if (this.mustHaveFloor()) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull(coordinate);
            temp = new Coordinate(coordinate);
            temp.move(Direction.YN);
            block = temp.getBlock();
            if (!block.func_149662_c() && !(block instanceof BlockHopper)) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if (this.mustHaveCeiling()) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull(coordinate);
            temp = new Coordinate(coordinate);
            temp.move(Direction.YP);
            block = temp.getBlock();
            if (!block.func_149662_c()) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if (this.mustHaveWallFrontInverse()) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull(coordinate);
            temp = new Coordinate(coordinate);
            temp.move(front.getInverse());
            block = temp.getBlock();
            if (!block.func_149662_c()) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if (this.mustHaveWall()) {
            boolean wall = false;
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull(coordinate);
            Coordinate temp2 = new Coordinate(coordinate);
            temp2.move(Direction.XN);
            block = temp2.getBlock();
            if (block.func_149662_c()) {
                wall = true;
            }
            temp2 = new Coordinate(coord);
            temp2.move(Direction.XP);
            block = temp2.getBlock();
            if (block.func_149662_c()) {
                wall = true;
            }
            temp2 = new Coordinate(coord);
            temp2.move(Direction.ZN);
            block = temp2.getBlock();
            if (block.func_149662_c()) {
                wall = true;
            }
            temp2 = new Coordinate(coord);
            temp2.move(Direction.ZP);
            block = temp2.getBlock();
            if (block.func_149662_c()) {
                wall = true;
            }
            if (!wall) {
                return I18N.tr("You can't place this block at this side", new Object[0]);
            }
        }
        if ((ghostGroup = this.getGhostGroupFront(front)) == null) return null;
        Coordinate coordinate = coord;
        Intrinsics.checkNotNull(coordinate);
        if (ghostGroup.canBePloted(coordinate)) return null;
        String string = I18N.tr("Not enough space for this block", new Object[0]);
        return string;
    }

    @Nullable
    public Direction getFrontFromPlace(@NotNull Direction side, @Nullable EntityLivingBase entityLiving) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Direction front = Direction.XN;
        TransparentNode.FrontType frontType = this.getFrontType();
        switch (frontType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[frontType.ordinal()]) {
            case 1: {
                front = side;
                break;
            }
            case 2: {
                front = side.getInverse();
                break;
            }
            case 3: {
                EntityLivingBase entityLivingBase = entityLiving;
                Intrinsics.checkNotNull(entityLivingBase);
                front = Utils.entityLivingViewDirection(entityLivingBase).getInverse();
                break;
            }
            case 4: {
                EntityLivingBase entityLivingBase = entityLiving;
                Intrinsics.checkNotNull(entityLivingBase);
                front = Utils.entityLivingHorizontalViewDirection(entityLivingBase).getInverse();
                break;
            }
            case -1: {
                throw new NotImplementedError(null, 1, null);
            }
        }
        return front;
    }

    @Nullable
    public final GhostGroup getGhostGroupFront(@Nullable Direction front) {
        GhostGroup ghostGroup;
        if (this.ghostGroup == null) {
            ghostGroup = null;
        } else {
            GhostGroup ghostGroup2 = this.ghostGroup;
            Intrinsics.checkNotNull(ghostGroup2);
            ghostGroup = ghostGroup2.newRotate(front);
        }
        return ghostGroup;
    }

    public final int getGhostGroupUuid() {
        return -1;
    }

    public int getSpawnDeltaX() {
        return 0;
    }

    public int getSpawnDeltaY() {
        return 0;
    }

    public int getSpawnDeltaZ() {
        return 0;
    }

    public void addCollisionBoxesToList(@NotNull AxisAlignedBB par5AxisAlignedBB, @NotNull List<AxisAlignedBB> list, @Nullable World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(par5AxisAlignedBB, "par5AxisAlignedBB");
        Intrinsics.checkNotNullParameter(list, "list");
        AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(world, x, y, z);
        if (par5AxisAlignedBB.func_72326_a(bb)) {
            list.add(bb);
        }
    }

    @JvmOverloads
    public TransparentNodeDescriptor(@Nullable String name, @NotNull Class<?> ElementClass, @NotNull Class<?> RenderClass) {
        Intrinsics.checkNotNullParameter(ElementClass, "ElementClass");
        Intrinsics.checkNotNullParameter(RenderClass, "RenderClass");
        this(name, ElementClass, RenderClass, null, 8, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransparentNode.FrontType.values().length];
            try {
                nArray[TransparentNode.FrontType.BlockSide.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransparentNode.FrontType.BlockSideInv.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransparentNode.FrontType.PlayerView.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransparentNode.FrontType.PlayerViewHorizontal.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

