/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.ghost.GhostObserver;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.INodeElement;
import mods.eln.node.NodeBase;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sound.IPlayer;
import mods.eln.sound.SoundCommand;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u008a\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u008a\u0001B\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001eJ\u0006\u0010;\u001a\u000209J\b\u0010<\u001a\u000209H\u0016J\u0006\u0010=\u001a\u00020\u001aJ\u0006\u0010>\u001a\u000209J\b\u0010?\u001a\u000209H\u0016J\u0018\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010B\u001a\u00020CH\u0016J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010B\u001a\u00020CH\u0016J\n\u0010F\u001a\u0004\u0018\u00010GH\u0016J\n\u0010H\u001a\u0004\u0018\u00010IH\u0016J\b\u0010J\u001a\u00020KH\u0016J\u001a\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010B\u001a\u00020CH\u0016J\u0006\u0010N\u001a\u00020$J\u0014\u0010O\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020Q0PH\u0016J8\u0010R\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020$2\u0006\u0010T\u001a\u00020U2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010V\u001a\u00020K2\u0006\u0010W\u001a\u00020K2\u0006\u0010X\u001a\u00020KH\u0016J\u0010\u0010Y\u001a\u0002092\u0006\u0010S\u001a\u00020$H\u0016J\b\u0010Z\u001a\u00020\u001eH\u0016J\b\u0010[\u001a\u000209H&J\"\u0010\\\u001a\u0002092\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010]\u001a\u0004\u0018\u00010^2\b\u0010_\u001a\u0004\u0018\u00010IJ\u0012\u0010`\u001a\u0002092\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010a\u001a\u00020Q2\u0006\u0010A\u001a\u00020\u0018H\u0016J\b\u0010b\u001a\u000209H\u0016J\u0010\u0010c\u001a\u0002092\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020g2\u0006\u0010d\u001a\u00020hH\u0016J\u0018\u0010f\u001a\u00020g2\u0006\u0010d\u001a\u00020h2\b\u0010i\u001a\u0004\u0018\u00010jJ\u001a\u0010k\u001a\u0004\u0018\u00010l2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010i\u001a\u00020UH\u0016J0\u0010m\u001a\u00020\u001e2\u0006\u0010i\u001a\u00020U2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010V\u001a\u00020K2\u0006\u0010W\u001a\u00020K2\u0006\u0010X\u001a\u00020KH\u0016J\b\u0010n\u001a\u000209H\u0016J\b\u0010o\u001a\u000209H\u0016J\b\u0010p\u001a\u000209H\u0016J\u0010\u0010q\u001a\u0002092\u0006\u0010r\u001a\u00020sH\u0016J\u0010\u0010t\u001a\u0002092\b\u0010d\u001a\u0004\u0018\u00010eJ\u0010\u0010u\u001a\u0002092\u0006\u0010v\u001a\u00020IH\u0016J\u0012\u0010w\u001a\u0002092\b\u0010v\u001a\u0004\u0018\u00010IH\u0016J\b\u0010x\u001a\u000209H\u0016J\b\u0010y\u001a\u000209H\u0016J\u000e\u0010z\u001a\u0002092\u0006\u0010{\u001a\u00020gJ\u0010\u0010|\u001a\u0002092\u0006\u0010}\u001a\u00020~H\u0002J\u0017\u0010\u007f\u001a\u0002092\u0006\u0010{\u001a\u00020g2\u0007\u0010\u0080\u0001\u001a\u00020QJ\u001e\u0010\u0081\u0001\u001a\u0002092\b\u0010d\u001a\u0004\u0018\u00010e2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\rH\u0004J\u0011\u0010\u0083\u0001\u001a\u0002092\u0006\u00107\u001a\u00020$H\u0016J\u0011\u0010\u0084\u0001\u001a\u00020Q2\u0006\u0010A\u001a\u00020\u0018H\u0016J\t\u0010\u0085\u0001\u001a\u000209H\u0016J\u0007\u0010\u0086\u0001\u001a\u00020\u001eJ\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J\u0011\u0010\u0089\u0001\u001a\u0002092\u0006\u0010v\u001a\u00020IH\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u0018\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u00100\u001a\b\u0012\u0004\u0012\u0002010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010)\"\u0004\b3\u0010+R\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lmods/eln/node/transparent/TransparentNodeElement;", "Lmods/eln/ghost/GhostObserver;", "Lmods/eln/sound/IPlayer;", "Lmods/eln/node/INodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "transparentNodeDescriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "descriptor", "getDescriptor", "()Lmods/eln/node/transparent/TransparentNodeDescriptor;", "dropItemStack", "Lnet/minecraft/item/ItemStack;", "getDropItemStack", "()Lnet/minecraft/item/ItemStack;", "electricalComponentList", "Ljava/util/ArrayList;", "Lmods/eln/sim/mna/component/Component;", "electricalLoadList", "Lmods/eln/sim/mna/state/State;", "electricalProcessList", "Lmods/eln/sim/IProcess;", "front", "Lmods/eln/misc/Direction;", "ghostObserverCoordonate", "Lmods/eln/misc/Coordinate;", "getGhostObserverCoordonate", "()Lmods/eln/misc/Coordinate;", "grounded", "", "inventory", "Lnet/minecraft/inventory/IInventory;", "getInventory", "()Lnet/minecraft/inventory/IInventory;", "lightValue", "", "getLightValue", "()I", "slowPostProcessList", "getSlowPostProcessList", "()Ljava/util/ArrayList;", "setSlowPostProcessList", "(Ljava/util/ArrayList;)V", "slowPreProcessList", "getSlowPreProcessList", "setSlowPreProcessList", "slowProcessList", "thermalConnectionList", "Lmods/eln/sim/ThermalConnection;", "getThermalConnectionList", "setThermalConnectionList", "thermalFastProcessList", "thermalLoadList", "Lmods/eln/sim/nbt/NbtThermalLoad;", "uuid", "checkCanStay", "", "onCreate", "connect", "connectJob", "coordinate", "disconnect", "disconnectJob", "getConnectionMask", "side", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getFluidHandler", "Lnet/minecraftforge/fluids/IFluidHandler;", "getItemStackNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getLightOpacity", "", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getUuid", "getWaila", "", "", "ghostBlockActivated", "UUID", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "vy", "vz", "ghostDestroyed", "hasGui", "initialize", "initializeFromThat", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "itemStackNbt", "inventoryChange", "multiMeterString", "needPublish", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "", "Ljava/io/DataInputStream;", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "newContainer", "Lnet/minecraft/inventory/Container;", "onBlockActivated", "onBreakElement", "onGroundedChangedByClient", "onNeighborBlockChange", "play", "s", "Lmods/eln/sound/SoundCommand;", "preparePacketForClient", "readFromNBT", "nbt", "readItemStackNBT", "reconnect", "selfDestroy", "sendIdToAllClient", "id", "sendPacketToAllClient", "bos", "Ljava/io/ByteArrayOutputStream;", "sendStringToAllClient", "str", "serialiseItemStack", "stack", "stop", "thermoMeterString", "unload", "useUuid", "world", "Lnet/minecraft/world/World;", "writeToNBT", "Companion", "Eln"})
@SourceDebugExtension(value={"SMAP\nTransparentNodeElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransparentNodeElement.kt\nmods/eln/node/transparent/TransparentNodeElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n1#2:380\n*E\n"})
public abstract class TransparentNodeElement
implements GhostObserver,
IPlayer,
INodeElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @Nullable
    public TransparentNode node;
    @JvmField
    @NotNull
    public TransparentNodeDescriptor transparentNodeDescriptor;
    @JvmField
    @NotNull
    public ArrayList<IProcess> slowProcessList;
    @NotNull
    private ArrayList<IProcess> slowPreProcessList;
    @NotNull
    private ArrayList<IProcess> slowPostProcessList;
    @JvmField
    @NotNull
    public ArrayList<IProcess> electricalProcessList;
    @JvmField
    @NotNull
    public ArrayList<Component> electricalComponentList;
    @JvmField
    @NotNull
    public ArrayList<State> electricalLoadList;
    @JvmField
    @NotNull
    public ArrayList<IProcess> thermalFastProcessList;
    @NotNull
    private ArrayList<ThermalConnection> thermalConnectionList;
    @JvmField
    @NotNull
    public ArrayList<NbtThermalLoad> thermalLoadList;
    @JvmField
    @NotNull
    public Direction front;
    @JvmField
    public boolean grounded;
    @NotNull
    private final Coordinate ghostObserverCoordonate;
    private int uuid;
    public static final byte unserializeGroundedId = -127;
    public static final byte unserializeNulldId = -128;

    public TransparentNodeElement(@Nullable TransparentNode node, @NotNull TransparentNodeDescriptor transparentNodeDescriptor) {
        Intrinsics.checkNotNullParameter(transparentNodeDescriptor, "transparentNodeDescriptor");
        this.node = node;
        this.transparentNodeDescriptor = transparentNodeDescriptor;
        this.slowProcessList = new ArrayList(4);
        this.slowPreProcessList = new ArrayList(4);
        this.slowPostProcessList = new ArrayList(4);
        this.electricalProcessList = new ArrayList(4);
        this.electricalComponentList = new ArrayList(4);
        this.electricalLoadList = new ArrayList(4);
        this.thermalFastProcessList = new ArrayList(4);
        this.thermalConnectionList = new ArrayList(4);
        this.thermalLoadList = new ArrayList(4);
        this.front = Direction.XN;
        this.grounded = true;
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        this.ghostObserverCoordonate = transparentNode.coordinate;
        if (this.transparentNodeDescriptor.ghostGroup != null) {
            Eln.ghostManager.addObserver(this);
        }
    }

    @NotNull
    public final ArrayList<IProcess> getSlowPreProcessList() {
        return this.slowPreProcessList;
    }

    public final void setSlowPreProcessList(@NotNull ArrayList<IProcess> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.slowPreProcessList = arrayList;
    }

    @NotNull
    public final ArrayList<IProcess> getSlowPostProcessList() {
        return this.slowPostProcessList;
    }

    public final void setSlowPostProcessList(@NotNull ArrayList<IProcess> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.slowPostProcessList = arrayList;
    }

    @NotNull
    public final ArrayList<ThermalConnection> getThermalConnectionList() {
        return this.thermalConnectionList;
    }

    public final void setThermalConnectionList(@NotNull ArrayList<ThermalConnection> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.thermalConnectionList = arrayList;
    }

    @Nullable
    public TransparentNodeDescriptor getDescriptor() {
        return this.transparentNodeDescriptor;
    }

    protected final void serialiseItemStack(@Nullable DataOutputStream stream, @Nullable ItemStack stack) throws IOException {
        DataOutputStream dataOutputStream = stream;
        Intrinsics.checkNotNull(dataOutputStream);
        Utils.serialiseItemStack(dataOutputStream, stack);
    }

    public void connectJob() {
        if (this.node != null) {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            if (transparentNode.isDestructing()) {
                return;
            }
        }
        Eln.simulator.addAllSlowProcess(this.slowProcessList);
        for (IProcess iProcess : this.slowPreProcessList) {
            Eln.simulator.addSlowPreProcess(iProcess);
        }
        for (IProcess iProcess : this.slowPostProcessList) {
            Eln.simulator.addSlowPostProcess(iProcess);
        }
        Eln.simulator.addAllElectricalComponent((Iterable<Component>)this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.addElectricalLoad(state);
        }
        Eln.simulator.addAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.addAllThermalConnection((Iterable<ThermalConnection>)this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.addThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.addAllThermalFastProcess(this.thermalFastProcessList);
    }

    public void disconnectJob() {
        Eln.simulator.removeAllSlowProcess(this.slowProcessList);
        for (IProcess iProcess : this.slowPreProcessList) {
            Eln.simulator.removeSlowPreProcess(iProcess);
        }
        for (IProcess iProcess : this.slowPostProcessList) {
            Eln.simulator.removeSlowPostProcess(iProcess);
        }
        Eln.simulator.removeAllElectricalComponent((Iterable<Component>)this.electricalComponentList);
        for (State state : this.electricalLoadList) {
            Eln.simulator.removeElectricalLoad(state);
        }
        Eln.simulator.removeAllElectricalProcess(this.electricalProcessList);
        Eln.simulator.removeAllThermalConnection((Iterable<ThermalConnection>)this.thermalConnectionList);
        for (NbtThermalLoad nbtThermalLoad : this.thermalLoadList) {
            Eln.simulator.removeThermalLoad(nbtThermalLoad);
        }
        Eln.simulator.removeAllThermalFastProcess(this.thermalFastProcessList);
    }

    public void onGroundedChangedByClient() {
        this.needPublish();
    }

    public final byte networkUnserialize(@NotNull DataInputStream stream, @Nullable EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        return this.networkUnserialize(stream);
    }

    public byte networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        int readed = 0;
        try {
            int n;
            int n2;
            int it = n2 = stream.readByte();
            boolean bl = false;
            readed = it;
            if (n2 == -127) {
                this.grounded = stream.readByte() != 0;
                this.onGroundedChangedByClient();
                n = -128;
            } else {
                n = readed;
            }
            return (byte)n;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -128;
        }
    }

    public final int getLightValue() {
        return 0;
    }

    public boolean hasGui() {
        return false;
    }

    @Nullable
    public IInventory getInventory() {
        return null;
    }

    public final void preparePacketForClient(@Nullable DataOutputStream stream) {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        DataOutputStream dataOutputStream = stream;
        Intrinsics.checkNotNull(dataOutputStream);
        transparentNode.preparePacketForClient(dataOutputStream);
    }

    public final void sendIdToAllClient(byte id) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    public final void sendStringToAllClient(byte id, @NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(id);
            packet.writeUTF(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    private final void sendPacketToAllClient(ByteArrayOutputStream bos) {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        NodeBase.sendPacketToAllClient$default(transparentNode, bos, 0.0, 2, null);
    }

    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return null;
    }

    @Nullable
    public IFluidHandler getFluidHandler() {
        return null;
    }

    public void onNeighborBlockChange() {
        this.checkCanStay(false);
    }

    public final void checkCanStay(boolean onCreate) {
        boolean needDestroy = false;
        if (this.transparentNodeDescriptor.mustHaveFloor()) {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            if (!transparentNode.isBlockOpaque(Direction.YN)) {
                needDestroy = true;
            }
        }
        if (this.transparentNodeDescriptor.mustHaveCeiling()) {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            if (!transparentNode.isBlockOpaque(Direction.YP)) {
                needDestroy = true;
            }
        }
        if (this.transparentNodeDescriptor.mustHaveWallFrontInverse()) {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            if (!transparentNode.isBlockOpaque(this.front.getInverse())) {
                needDestroy = true;
            }
        }
        if (this.transparentNodeDescriptor.mustHaveWall()) {
            boolean wall = false;
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            if (transparentNode.isBlockOpaque(Direction.XN)) {
                wall = true;
            }
            TransparentNode transparentNode2 = this.node;
            Intrinsics.checkNotNull(transparentNode2);
            if (transparentNode2.isBlockOpaque(Direction.XP)) {
                wall = true;
            }
            TransparentNode transparentNode3 = this.node;
            Intrinsics.checkNotNull(transparentNode3);
            if (transparentNode3.isBlockOpaque(Direction.ZN)) {
                wall = true;
            }
            TransparentNode transparentNode4 = this.node;
            Intrinsics.checkNotNull(transparentNode4);
            if (transparentNode4.isBlockOpaque(Direction.ZP)) {
                wall = true;
            }
            if (!wall) {
                needDestroy = true;
            }
        }
        if (needDestroy) {
            this.selfDestroy();
        }
    }

    public void selfDestroy() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.physicalSelfDestruction(0.0f);
    }

    @Override
    public void stop(int uuid) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            stream.writeByte(20);
            stream.writeInt(uuid);
            this.sendPacketToAllClient(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onBreakElement() {
        if (this.useUuid()) {
            this.stop(this.uuid);
        }
        if (this.transparentNodeDescriptor.ghostGroup != null) {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            Eln.ghostManager.removeObserver(transparentNode.coordinate);
            TransparentNode transparentNode2 = this.node;
            Intrinsics.checkNotNull(transparentNode2);
            Eln.ghostManager.removeGhostAndBlockWithObserver(transparentNode2.coordinate);
        }
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.dropInventory(this.getInventory());
        TransparentNode transparentNode3 = this.node;
        Intrinsics.checkNotNull(transparentNode3);
        TransparentNode transparentNode4 = this.node;
        Intrinsics.checkNotNull(transparentNode4);
        transparentNode3.dropElement(transparentNode4.removedByPlayer);
    }

    @NotNull
    public final ItemStack getDropItemStack() {
        Block block = Eln.transparentNodeBlock;
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        ItemStack itemStack = new ItemStack(block, 1, transparentNode.elementId);
        itemStack.func_77982_d(this.getItemStackNBT());
        return itemStack;
    }

    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 0;
    }

    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            stream.writeByte(this.front.getInt() + (this.grounded ? 8 : 0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void initializeFromThat(@NotNull Direction front, @Nullable EntityLivingBase entityLiving, @Nullable NBTTagCompound itemStackNbt) {
        Intrinsics.checkNotNullParameter((Object)front, "front");
        this.front = front;
        this.readItemStackNBT(itemStackNbt);
        this.initialize();
    }

    public abstract void initialize();

    public void readItemStackNBT(@Nullable NBTTagCompound nbt) {
    }

    @Nullable
    public NBTTagCompound getItemStackNBT() {
        return null;
    }

    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        IInventory inv = this.getInventory();
        if (inv != null) {
            Utils.readFromNBT(nbt, "inv", inv);
        }
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).readFromNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.readFromNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).readFromNBT(nbt, "");
        }
        byte b = nbt.func_74771_c("others");
        Direction direction = Direction.Companion.fromInt(b & 7);
        Intrinsics.checkNotNull((Object)direction);
        this.front = direction;
        this.grounded = (b & 8) != 0;
    }

    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        IInventory inv = this.getInventory();
        if (inv != null) {
            Utils.writeToNBT(nbt, "inv", inv);
        }
        for (State electricalLoad : this.electricalLoadList) {
            if (!(electricalLoad instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)electricalLoad)).writeToNBT(nbt, "");
        }
        for (NbtThermalLoad thermalLoad : this.thermalLoadList) {
            thermalLoad.writeToNBT(nbt, "");
        }
        for (Component c : this.electricalComponentList) {
            if (!(c instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)c)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.slowProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.electricalProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        for (IProcess process : this.thermalFastProcessList) {
            if (!(process instanceof INBTTReady)) continue;
            ((INBTTReady)((Object)process)).writeToNBT(nbt, "");
        }
        nbt.func_74774_a("others", (byte)(this.front.getInt() + (this.grounded ? 8 : 0)));
    }

    @Override
    public void reconnect() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.reconnect();
    }

    @Override
    public void needPublish() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.setNeedPublish(true);
    }

    public final void connect() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.connect();
    }

    public final void disconnect() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.disconnect();
    }

    @Override
    public void inventoryChange(@Nullable IInventory inventory) {
    }

    public float getLightOpacity() {
        return 0.0f;
    }

    @Override
    @NotNull
    public Coordinate getGhostObserverCoordonate() {
        return this.ghostObserverCoordonate;
    }

    @Override
    public void ghostDestroyed(int UUID2) {
        if (UUID2 == this.transparentNodeDescriptor.getGhostGroupUuid()) {
            this.selfDestroy();
        }
    }

    @Override
    public boolean ghostBlockActivated(int UUID2, @NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        boolean bl;
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (UUID2 == this.transparentNodeDescriptor.getGhostGroupUuid()) {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            bl = transparentNode.onBlockActivated(entityPlayer, side, vx, vy, vz);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final World world() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate.world();
    }

    @NotNull
    public final Coordinate coordinate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    public final int getUuid() {
        if (this.uuid == 0) {
            this.uuid = Utils.getUuid();
        }
        return this.uuid;
    }

    public final boolean useUuid() {
        return this.uuid != 0;
    }

    @Override
    public void play(@NotNull SoundCommand s) {
        Intrinsics.checkNotNullParameter(s, "s");
        s.addUuid(this.getUuid());
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        s.set(transparentNode.coordinate);
        s.play();
    }

    public void unload() {
    }

    @NotNull
    public Map<String, String> getWaila() {
        Map wailaList = new HashMap();
        wailaList.put("Info", this.multiMeterString(this.front));
        return wailaList;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmods/eln/node/transparent/TransparentNodeElement$Companion;", "", "()V", "unserializeGroundedId", "", "unserializeNulldId", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

