/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.client.ClientProxy;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import mods.eln.sound.LoopedSoundManager;
import mods.eln.sound.SoundCommand;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 b2\u00020\u0001:\u0001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0005J\b\u0010#\u001a\u00020\nH\u0016J\u0016\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\nJ\u0016\u0010(\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020 2\u0006\u0010%\u001a\u00020&J\u0016\u0010,\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u001eJ\u0016\u0010-\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020.J\u000e\u0010/\u001a\u00020 2\u0006\u0010'\u001a\u00020\nJ\b\u00100\u001a\u000201H\u0004J\u0006\u00102\u001a\u00020 J\b\u00103\u001a\u00020 H&J,\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\b2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u000105J4\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\b2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u0001052\u0006\u0010<\u001a\u00020\nJ8\u0010=\u001a\u00020 2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020*J\u001a\u0010F\u001a\u0004\u0018\u0001082\u0006\u00106\u001a\u00020\b2\u0006\u0010G\u001a\u00020HH\u0016J\u0006\u0010I\u001a\u00020\u001eJ\u000e\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020\bJ\u0010\u0010L\u001a\u00020 2\u0006\u0010M\u001a\u00020NH\u0016J\u001a\u0010O\u001a\u0004\u0018\u00010P2\u0006\u00106\u001a\u00020\b2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020 H\u0016J\u000e\u0010T\u001a\u00020 2\u0006\u0010U\u001a\u00020VJ\u0010\u0010W\u001a\u00020 2\b\u0010M\u001a\u0004\u0018\u00010XJ\u0010\u0010Y\u001a\u00020 2\u0006\u0010Z\u001a\u00020*H\u0016J\u0010\u0010[\u001a\u00020 2\b\u0010\\\u001a\u0004\u0018\u00010]J\u0012\u0010^\u001a\u00020 2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u001e\u0010_\u001a\u0004\u0018\u00010?2\b\u0010M\u001a\u0004\u0018\u00010N2\b\u0010`\u001a\u0004\u0018\u00010?H\u0004J\u0006\u0010a\u001a\u00020\nR\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lmods/eln/node/transparent/TransparentNodeElementRender;", "", "tileEntity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "transparentNodedescriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "front", "Lmods/eln/misc/Direction;", "grounded", "", "getGrounded", "()Z", "setGrounded", "(Z)V", "inventory", "Lnet/minecraft/inventory/IInventory;", "getInventory", "()Lnet/minecraft/inventory/IInventory;", "loopedSoundManager", "Lmods/eln/sound/LoopedSoundManager;", "getTileEntity", "()Lmods/eln/node/transparent/TransparentNodeEntity;", "setTileEntity", "(Lmods/eln/node/transparent/TransparentNodeEntity;)V", "getTransparentNodedescriptor", "()Lmods/eln/node/transparent/TransparentNodeDescriptor;", "setTransparentNodedescriptor", "(Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "uuid", "", "addLoopedSound", "", "loopedSound", "Lmods/eln/sound/LoopedSound;", "cameraDrawOptimisation", "clientSendBoolean", "id", "", "value", "clientSendFloat", "str", "", "clientSendId", "clientSendInt", "clientSendString", "", "clientSetGrounded", "coordinate", "Lmods/eln/misc/Coordinate;", "destructor", "draw", "drawCable", "Lmods/eln/cable/CableRenderType;", "side", "render", "Lmods/eln/cable/CableRenderDescriptor;", "connection", "Lmods/eln/misc/LRDUMask;", "renderPreProcess", "drawBottom", "drawEntityItem", "entityItem", "Lnet/minecraft/entity/item/EntityItem;", "x", "", "y", "z", "roty", "scale", "getCableRenderSide", "lrdu", "Lmods/eln/misc/LRDU;", "getUuid", "glCableTransform", "inverse", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "notifyNeighborSpawn", "play", "s", "Lmods/eln/sound/SoundCommand;", "preparePacketForServer", "Ljava/io/DataOutputStream;", "refresh", "deltaT", "sendPacketToServer", "bos", "Ljava/io/ByteArrayOutputStream;", "serverPacketUnserialize", "unserializeItemStackToEntityItem", "old", "usedUuid", "Companion", "Eln"})
public abstract class TransparentNodeElementRender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TransparentNodeEntity tileEntity;
    @NotNull
    private TransparentNodeDescriptor transparentNodedescriptor;
    @JvmField
    @Nullable
    public Direction front;
    private boolean grounded;
    private int uuid;
    @NotNull
    private final LoopedSoundManager loopedSoundManager;
    @NotNull
    private static final LRDUMask maskTempDraw = new LRDUMask();

    public TransparentNodeElementRender(@NotNull TransparentNodeEntity tileEntity, @NotNull TransparentNodeDescriptor transparentNodedescriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter(transparentNodedescriptor, "transparentNodedescriptor");
        this.tileEntity = tileEntity;
        this.transparentNodedescriptor = transparentNodedescriptor;
        this.loopedSoundManager = new LoopedSoundManager(0.0f, 1, null);
    }

    @NotNull
    public final TransparentNodeEntity getTileEntity() {
        return this.tileEntity;
    }

    public final void setTileEntity(@NotNull TransparentNodeEntity transparentNodeEntity) {
        Intrinsics.checkNotNullParameter(transparentNodeEntity, "<set-?>");
        this.tileEntity = transparentNodeEntity;
    }

    @NotNull
    public final TransparentNodeDescriptor getTransparentNodedescriptor() {
        return this.transparentNodedescriptor;
    }

    public final void setTransparentNodedescriptor(@NotNull TransparentNodeDescriptor transparentNodeDescriptor) {
        Intrinsics.checkNotNullParameter(transparentNodeDescriptor, "<set-?>");
        this.transparentNodedescriptor = transparentNodeDescriptor;
    }

    public final boolean getGrounded() {
        return this.grounded;
    }

    public final void setGrounded(boolean bl) {
        this.grounded = bl;
    }

    @Nullable
    protected final EntityItem unserializeItemStackToEntityItem(@Nullable DataInputStream stream, @Nullable EntityItem old) throws IOException {
        DataInputStream dataInputStream = stream;
        Intrinsics.checkNotNull(dataInputStream);
        return Utils.unserializeItemStackToEntityItem(dataInputStream, old, this.tileEntity);
    }

    public final void drawEntityItem(@Nullable EntityItem entityItem, double x, double y, double z, float roty, float scale) {
        UtilsClient.drawEntityItem(entityItem, x, y, z, roty, scale);
    }

    public final void glCableTransform(@NotNull Direction inverse) {
        Intrinsics.checkNotNullParameter((Object)inverse, "inverse");
        inverse.glTranslate(0.5f);
        inverse.glRotateXnRef();
    }

    public abstract void draw();

    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            byte b = stream.readByte();
            this.front = Direction.Companion.fromInt(b & 7);
            this.grounded = (b & 8) != 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return null;
    }

    @Nullable
    public IInventory getInventory() {
        return null;
    }

    public final void preparePacketForServer(@Nullable DataOutputStream stream) {
        DataOutputStream dataOutputStream = stream;
        Intrinsics.checkNotNull(dataOutputStream);
        this.tileEntity.preparePacketForServer(dataOutputStream);
    }

    public final void sendPacketToServer(@Nullable ByteArrayOutputStream bos) {
        this.tileEntity.sendPacketToServer(bos);
    }

    public final void clientSetGrounded(boolean value) {
        this.clientSendBoolean((byte)-127, value);
    }

    public final void clientSendBoolean(byte id, boolean value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeByte(value ? 1 : 0);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSendId(byte id) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSendString(byte id, @NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeUTF(str);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSendFloat(byte id, float str) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeFloat(str);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void clientSendInt(byte id, int str) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(id);
            stream.writeInt(str);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean cameraDrawOptimisation() {
        return true;
    }

    @Nullable
    public CableRenderDescriptor getCableRenderSide(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Nullable
    public final CableRenderType drawCable(@NotNull Direction side, @Nullable CableRenderDescriptor render, @NotNull LRDUMask connection, @Nullable CableRenderType renderPreProcess) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(connection, "connection");
        return this.drawCable(side, render, connection, renderPreProcess, false);
    }

    @Nullable
    public final CableRenderType drawCable(@NotNull Direction side, @Nullable CableRenderDescriptor render, @NotNull LRDUMask connection, @Nullable CableRenderType renderPreProcess, boolean drawBottom) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(connection, "connection");
        CableRenderType renderPreProcess2 = renderPreProcess;
        if (render == null) {
            return renderPreProcess2;
        }
        if (renderPreProcess2 == null) {
            renderPreProcess2 = CableRender.connectionType(this.tileEntity, connection, side);
        }
        GL11.glPushMatrix();
        this.glCableTransform(side);
        render.bindCableTexture();
        for (LRDU lrdu : LRDU.values()) {
            Utils.setGlColorFromDye(renderPreProcess2.otherdry[lrdu.toInt()]);
            if (!connection.get(lrdu)) continue;
            maskTempDraw.set(1 << lrdu.toInt());
            CableRender.drawCable(render, maskTempDraw, renderPreProcess2, render.getWidthDiv2() / 2.0f, drawBottom);
        }
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        return renderPreProcess2;
    }

    public void notifyNeighborSpawn() {
    }

    public void serverPacketUnserialize(@Nullable DataInputStream stream) {
    }

    @NotNull
    protected final Coordinate coordinate() {
        int n = this.tileEntity.field_145851_c;
        int n2 = this.tileEntity.field_145848_d;
        int n3 = this.tileEntity.field_145849_e;
        World world = this.tileEntity.func_145831_w();
        Intrinsics.checkNotNullExpressionValue(world, "tileEntity.worldObj");
        return new Coordinate(n, n2, n3, world);
    }

    public final int getUuid() {
        if (this.uuid == 0) {
            this.uuid = UtilsClient.getUuid();
        }
        return this.uuid;
    }

    public final boolean usedUuid() {
        return this.uuid != 0;
    }

    public final void play(@NotNull SoundCommand s) {
        Intrinsics.checkNotNullParameter(s, "s");
        s.addUuid(this.getUuid());
        s.set(this.tileEntity);
        s.play();
    }

    @SideOnly(value=Side.CLIENT)
    protected final void addLoopedSound(@Nullable LoopedSound loopedSound) {
        this.loopedSoundManager.add(loopedSound);
    }

    public final void destructor() {
        if (this.usedUuid()) {
            ClientProxy.uuidManager.kill(this.uuid);
        }
        this.loopedSoundManager.dispose();
    }

    public void refresh(float deltaT) {
        this.loopedSoundManager.process(deltaT);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmods/eln/node/transparent/TransparentNodeElementRender$Companion;", "", "()V", "maskTempDraw", "Lmods/eln/misc/LRDUMask;", "getMaskTempDraw", "()Lmods/eln/misc/LRDUMask;", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LRDUMask getMaskTempDraw() {
            return maskTempDraw;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

