/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.node.transparent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.FakeSideInventory;
import mods.eln.misc.LRDU;
import mods.eln.node.Node;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#H\u0016J \u0010'\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0018H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\b\u0010-\u001a\u00020\u0018H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020#H\u0016J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J&\u00106\u001a\u00020#2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020#J\b\u0010<\u001a\u00020\u0011H\u0016J\b\u0010=\u001a\u00020#H\u0016J\b\u0010>\u001a\u00020#H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010%2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010%2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010A\u001a\u00020 H\u0016J\u0018\u0010B\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010C\u001a\u00020#2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0010\u0010D\u001a\u00020 2\u0006\u0010\"\u001a\u00020EH\u0016J\u001a\u0010F\u001a\u0004\u0018\u00010G2\u0006\u00102\u001a\u0002032\u0006\u0010H\u001a\u00020EH\u0016J\u001a\u0010I\u001a\u0004\u0018\u00010J2\u0006\u00102\u001a\u0002032\u0006\u0010H\u001a\u00020EH\u0016J\b\u0010K\u001a\u00020\u0018H\u0016J\u0010\u0010L\u001a\u00020\u00182\u0006\u0010M\u001a\u00020NH\u0016J\u0012\u0010O\u001a\u00020\u00182\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J\u0010\u0010R\u001a\u00020\u00182\u0006\u0010M\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u00182\u0006\u0010M\u001a\u00020SH\u0016J\u001a\u0010U\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010V\u001a\u00020\u0018H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006W"}, d2={"Lmods/eln/node/transparent/TransparentNodeEntity;", "Lmods/eln/node/NodeBlockEntity;", "Lnet/minecraft/inventory/ISidedInventory;", "()V", "elementRender", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "getElementRender", "()Lmods/eln/node/transparent/TransparentNodeElementRender;", "setElementRender", "(Lmods/eln/node/transparent/TransparentNodeElementRender;)V", "elementRenderId", "", "getElementRenderId", "()S", "setElementRenderId", "(S)V", "nodeUuid", "", "getNodeUuid", "()Ljava/lang/String;", "sidedInventory", "getSidedInventory", "()Lnet/minecraft/inventory/ISidedInventory;", "addCollisionBoxesToList", "", "par5AxisAlignedBB", "Lnet/minecraft/util/AxisAlignedBB;", "list", "", "blockCoord", "Lmods/eln/misc/Coordinate;", "cameraDrawOptimisation", "", "canExtractItem", "var1", "", "var2", "Lnet/minecraft/item/ItemStack;", "var3", "canInsertItem", "clientRefresh", "deltaT", "", "closeInventory", "decrStackSize", "destructor", "getAccessibleSlotsFromSide", "", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getDamageValue", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "getInventoryName", "getInventoryStackLimit", "getSizeInventory", "getStackInSlot", "getStackInSlotOnClosing", "hasCustomInventoryName", "isItemValidForSlot", "isProvidingWeakPower", "isUseableByPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "openInventory", "preparePacketForServer", "stream", "Ljava/io/DataOutputStream;", "sendPacketToServer", "bos", "Ljava/io/ByteArrayOutputStream;", "serverPacketUnserialize", "Ljava/io/DataInputStream;", "serverPublishUnserialize", "setInventorySlotContents", "tileEntityNeighborSpawn", "Eln"})
public class TransparentNodeEntity
extends NodeBlockEntity
implements ISidedInventory {
    @Nullable
    private TransparentNodeElementRender elementRender;
    private short elementRenderId;

    @Nullable
    public final TransparentNodeElementRender getElementRender() {
        return this.elementRender;
    }

    public final void setElementRender(@Nullable TransparentNodeElementRender transparentNodeElementRender) {
        this.elementRender = transparentNodeElementRender;
    }

    public final short getElementRenderId() {
        return this.elementRenderId;
    }

    public final void setElementRenderId(short s) {
        this.elementRenderId = s;
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull Direction side, @NotNull LRDU lrdu) {
        CableRenderDescriptor cableRenderDescriptor;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (this.elementRender == null) {
            cableRenderDescriptor = null;
        } else {
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            cableRenderDescriptor = transparentNodeElementRender.getCableRenderSide(side, lrdu);
        }
        return cableRenderDescriptor;
    }

    @Override
    public void serverPublishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.serverPublishUnserialize(stream);
        try {
            short id = stream.readShort();
            if (id == 0) {
                this.elementRenderId = 0;
                this.elementRender = null;
            } else {
                if (id != this.elementRenderId) {
                    TransparentNodeDescriptor descriptor;
                    this.elementRenderId = id;
                    TransparentNodeDescriptor transparentNodeDescriptor = descriptor = (TransparentNodeDescriptor)Eln.transparentNodeItem.getDescriptor(id);
                    Intrinsics.checkNotNull(transparentNodeDescriptor);
                    Object[] objectArray = new Class[]{TransparentNodeEntity.class, TransparentNodeDescriptor.class};
                    Constructor<?> constructor = transparentNodeDescriptor.getRenderClass().getConstructor((Class<?>[])objectArray);
                    objectArray = new Object[]{this, descriptor};
                    Object obj = constructor.newInstance(objectArray);
                    Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type mods.eln.node.transparent.TransparentNodeElementRender");
                    this.elementRender = (TransparentNodeElementRender)obj;
                }
                TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
                Intrinsics.checkNotNull(transparentNodeElementRender);
                transparentNodeElementRender.networkUnserialize(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        TransparentNode transparentNode = (TransparentNode)this.getNode();
        if (transparentNode == null) {
            return null;
        }
        TransparentNode n = transparentNode;
        return n.newContainer(side, player);
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
        Intrinsics.checkNotNull(transparentNodeElementRender);
        return transparentNodeElementRender.newGuiDraw(side, player);
    }

    @Override
    public void preparePacketForServer(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            super.preparePacketForServer(stream);
            stream.writeShort(this.elementRenderId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendPacketToServer(@Nullable ByteArrayOutputStream bos) {
        super.sendPacketToServer(bos);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        boolean bl;
        if (this.elementRender == null) {
            bl = super.cameraDrawOptimisation();
        } else {
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            bl = transparentNodeElementRender.cameraDrawOptimisation();
        }
        return bl;
    }

    public final int getDamageValue(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(world, "world");
        return world.field_72995_K ? this.elementRenderId : (short)0;
    }

    @Override
    public void tileEntityNeighborSpawn() {
        if (this.elementRender != null) {
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            transparentNodeElementRender.notifyNeighborSpawn();
        }
    }

    public final void addCollisionBoxesToList(@NotNull AxisAlignedBB par5AxisAlignedBB, @NotNull List<AxisAlignedBB> list, @Nullable Coordinate blockCoord) {
        TransparentNodeDescriptor transparentNodeDescriptor;
        Intrinsics.checkNotNullParameter(par5AxisAlignedBB, "par5AxisAlignedBB");
        Intrinsics.checkNotNullParameter(list, "list");
        if (this.field_145850_b.field_72995_K) {
            if (this.elementRender == null) {
                transparentNodeDescriptor = null;
            } else {
                TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
                Intrinsics.checkNotNull(transparentNodeElementRender);
                transparentNodeDescriptor = transparentNodeElementRender.getTransparentNodedescriptor();
            }
        } else {
            TransparentNode node = (TransparentNode)this.getNode();
            if (node != null) {
                TransparentNodeElement transparentNodeElement = node.element;
                Intrinsics.checkNotNull(transparentNodeElement);
                transparentNodeDescriptor = transparentNodeElement.transparentNodeDescriptor;
            } else {
                transparentNodeDescriptor = null;
            }
        }
        TransparentNodeDescriptor desc = transparentNodeDescriptor;
        int x = 0;
        int y = 0;
        int z = 0;
        if (blockCoord != null) {
            x = blockCoord.x;
            y = blockCoord.y;
            z = blockCoord.z;
        } else {
            x = this.field_145851_c;
            y = this.field_145848_d;
            z = this.field_145849_e;
        }
        if (desc == null) {
            AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(this.field_145850_b, x, y, z);
            if (par5AxisAlignedBB.func_72326_a(bb)) {
                list.add(bb);
            }
        } else {
            desc.addCollisionBoxesToList(par5AxisAlignedBB, list, this.field_145850_b, x, y, z);
        }
    }

    @Override
    public void serverPacketUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.serverPacketUnserialize(stream);
        if (this.elementRender != null) {
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            transparentNodeElementRender.serverPacketUnserialize(stream);
        }
    }

    @Override
    @NotNull
    public String getNodeUuid() {
        return Eln.transparentNodeBlock.getNodeUuid();
    }

    @Override
    public void destructor() {
        if (this.elementRender != null) {
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            transparentNodeElementRender.destructor();
        }
        super.destructor();
    }

    @Override
    public void clientRefresh(float deltaT) {
        if (this.elementRender != null) {
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            transparentNodeElementRender.refresh(deltaT);
        }
    }

    @Override
    public int isProvidingWeakPower(@Nullable Direction side) {
        return 0;
    }

    @NotNull
    public ISidedInventory getSidedInventory() {
        if (this.field_145850_b.field_72995_K) {
            if (this.elementRender == null) {
                return FakeSideInventory.Companion.getInstance();
            }
            TransparentNodeElementRender transparentNodeElementRender = this.elementRender;
            Intrinsics.checkNotNull(transparentNodeElementRender);
            IInventory i = transparentNodeElementRender.getInventory();
            if (i != null && i instanceof ISidedInventory) {
                return (ISidedInventory)i;
            }
        } else {
            IInventory i;
            Node node = this.getNode();
            if (node != null && node instanceof TransparentNode && (i = ((TransparentNode)node).getInventory(null)) != null && i instanceof ISidedInventory) {
                return (ISidedInventory)i;
            }
        }
        return FakeSideInventory.Companion.getInstance();
    }

    public int func_70302_i_() {
        return this.getSidedInventory().func_70302_i_();
    }

    @Nullable
    public ItemStack func_70301_a(int var1) {
        return this.getSidedInventory().func_70301_a(var1);
    }

    @Nullable
    public ItemStack func_70298_a(int var1, int var2) {
        return this.getSidedInventory().func_70298_a(var1, var2);
    }

    @Nullable
    public ItemStack func_70304_b(int var1) {
        return this.getSidedInventory().func_70304_b(var1);
    }

    public void func_70299_a(int var1, @Nullable ItemStack var2) {
        this.getSidedInventory().func_70299_a(var1, var2);
    }

    @NotNull
    public String func_145825_b() {
        String string = this.getSidedInventory().func_145825_b();
        Intrinsics.checkNotNullExpressionValue(string, "sidedInventory.inventoryName");
        return string;
    }

    public boolean func_145818_k_() {
        return this.getSidedInventory().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getSidedInventory().func_70297_j_();
    }

    public boolean func_70300_a(@NotNull EntityPlayer var1) {
        Intrinsics.checkNotNullParameter(var1, "var1");
        return this.getSidedInventory().func_70300_a(var1);
    }

    public void func_70295_k_() {
        this.getSidedInventory().func_70295_k_();
    }

    public void func_70305_f() {
        this.getSidedInventory().func_70305_f();
    }

    public boolean func_94041_b(int var1, @NotNull ItemStack var2) {
        Intrinsics.checkNotNullParameter(var2, "var2");
        return this.getSidedInventory().func_94041_b(var1, var2);
    }

    @NotNull
    public int[] func_94128_d(int var1) {
        int[] nArray = this.getSidedInventory().func_94128_d(var1);
        Intrinsics.checkNotNullExpressionValue(nArray, "sidedInventory.getAccessibleSlotsFromSide(var1)");
        return nArray;
    }

    public boolean func_102007_a(int var1, @NotNull ItemStack var2, int var3) {
        Intrinsics.checkNotNullParameter(var2, "var2");
        return this.getSidedInventory().func_102007_a(var1, var2, var3);
    }

    public boolean func_102008_b(int var1, @NotNull ItemStack var2, int var3) {
        Intrinsics.checkNotNullParameter(var2, "var2");
        return this.getSidedInventory().func_102008_b(var1, var2, var3);
    }
}

