/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashSet;
import java.util.LinkedList;
import mods.eln.Eln;
import mods.eln.misc.Utils;
import mods.eln.ore.OreDescriptor;
import mods.eln.server.ChunkRef;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lmods/eln/server/OreRegenerate;", "", "()V", "alreadyLoadedChunks", "Ljava/util/HashSet;", "Lmods/eln/server/ChunkRef;", "getAlreadyLoadedChunks", "()Ljava/util/HashSet;", "setAlreadyLoadedChunks", "(Ljava/util/HashSet;)V", "jobs", "Ljava/util/LinkedList;", "getJobs", "()Ljava/util/LinkedList;", "setJobs", "(Ljava/util/LinkedList;)V", "chunkLoad", "", "e", "Lnet/minecraftforge/event/world/ChunkEvent$Load;", "clear", "tick", "event", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "Eln"})
public final class OreRegenerate {
    @NotNull
    private LinkedList<ChunkRef> jobs = new LinkedList();
    @NotNull
    private HashSet<ChunkRef> alreadyLoadedChunks = new HashSet();

    public OreRegenerate() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @NotNull
    public final LinkedList<ChunkRef> getJobs() {
        return this.jobs;
    }

    public final void setJobs(@NotNull LinkedList<ChunkRef> linkedList) {
        Intrinsics.checkNotNullParameter(linkedList, "<set-?>");
        this.jobs = linkedList;
    }

    @NotNull
    public final HashSet<ChunkRef> getAlreadyLoadedChunks() {
        return this.alreadyLoadedChunks;
    }

    public final void setAlreadyLoadedChunks(@NotNull HashSet<ChunkRef> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.alreadyLoadedChunks = hashSet;
    }

    public final void clear() {
        this.jobs.clear();
        this.alreadyLoadedChunks.clear();
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (int idx = 0; idx < 1; ++idx) {
            if (this.jobs.isEmpty()) continue;
            ChunkRef j = this.jobs.pollLast();
            if (!Eln.saveConfig.getReGenOre() && !Eln.instance.forceOreRegen) {
                return;
            }
            WorldServer server = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(j.getWorldId());
            Chunk chunk = server.func_72964_e(j.getX(), j.getZ());
            for (int y = 0; y < 60; y += 2) {
                for (int z = y & 1; z < 16; z += 2) {
                    for (int x = y & 1; x < 16; x += 2) {
                        if (chunk.func_150810_a(x, y, z) != Eln.oreBlock) continue;
                        return;
                    }
                }
            }
            Utils.println("Regenerated! " + this.jobs.size());
            for (OreDescriptor d : Eln.oreItem.descriptors) {
                d.generate(server.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (World)server, null, null);
            }
        }
    }

    @SubscribeEvent
    public final void chunkLoad(@NotNull ChunkEvent.Load e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.world.field_72995_K || Eln.saveConfig != null && !Eln.saveConfig.getReGenOre()) {
            return;
        }
        Chunk c = e.getChunk();
        ChunkRef ref = new ChunkRef(c.field_76635_g, c.field_76647_h, c.field_76637_e.field_73011_w.field_76574_g);
        if (this.alreadyLoadedChunks.contains(ref)) {
            Utils.println("Already regenerated!");
            return;
        }
        this.alreadyLoadedChunks.add(ref);
        this.jobs.addFirst(ref);
    }
}

