/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Hashtable;
import java.util.Map;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0017\u0010\t\u001a\b\u0018\u00010\u0006R\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0017\u0010\t\u001a\b\u0018\u00010\u0006R\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmods/eln/server/PlayerManager;", "", "()V", "metadataHash", "", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Lmods/eln/server/PlayerManager$PlayerMetadata;", "clear", "", "get", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "tick", "event", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "PlayerMetadata", "Eln"})
public final class PlayerManager {
    @NotNull
    private final Map<EntityPlayerMP, PlayerMetadata> metadataHash = new Hashtable();

    public PlayerManager() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public final void clear() {
        this.metadataHash.clear();
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (Map.Entry<EntityPlayerMP, PlayerMetadata> entry : this.metadataHash.entrySet()) {
            EntityPlayerMP key = entry.getKey();
            PlayerMetadata p = entry.getValue();
            p.setInteractRise(p.getInteractRiseBuffer());
            p.setInteractRiseBuffer(false);
            if (!p.needDelete()) continue;
            this.metadataHash.remove(key);
        }
    }

    @Nullable
    public final PlayerMetadata get(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerMetadata metadata = this.metadataHash.get(player);
        if (metadata != null) {
            return metadata;
        }
        this.metadataHash.put(player, new PlayerMetadata((EntityPlayer)player));
        return this.metadataHash.get(player);
    }

    @Nullable
    public final PlayerMetadata get(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.get((EntityPlayerMP)player);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aR&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lmods/eln/server/PlayerManager$PlayerMetadata;", "", "p", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lmods/eln/server/PlayerManager;Lnet/minecraft/entity/player/EntityPlayer;)V", "interactEnable", "", "getInteractEnable", "()Z", "setInteractEnable", "(Z)V", "interactRise", "getInteractRise", "setInteractRise", "interactRiseBuffer", "getInteractRiseBuffer", "setInteractRiseBuffer", "player", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayer;", "setPlayer", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "timeout", "", "needDelete", "timeoutDec", "", "timeoutReset", "Eln"})
    public final class PlayerMetadata {
        private int timeout;
        private boolean interactEnable;
        private boolean interactRise;
        private boolean interactRiseBuffer;
        @NotNull
        private EntityPlayer player;

        public PlayerMetadata(EntityPlayer p) {
            Intrinsics.checkNotNullParameter(p, "p");
            this.timeoutReset();
            this.player = p;
        }

        public final boolean getInteractEnable() {
            this.timeoutReset();
            return this.interactEnable;
        }

        public final void setInteractEnable(boolean interactEnable) {
            if (!this.getInteractEnable() && interactEnable) {
                this.interactRiseBuffer = true;
                Utils.println("interactRiseBuffer");
            }
            this.interactEnable = interactEnable;
            this.timeoutReset();
            Utils.println("interactEnable : " + interactEnable);
        }

        public final boolean getInteractRise() {
            return this.interactRise;
        }

        public final void setInteractRise(boolean bl) {
            this.interactRise = bl;
        }

        public final boolean getInteractRiseBuffer() {
            return this.interactRiseBuffer;
        }

        public final void setInteractRiseBuffer(boolean bl) {
            this.interactRiseBuffer = bl;
        }

        @NotNull
        public final EntityPlayer getPlayer() {
            return this.player;
        }

        public final void setPlayer(@NotNull EntityPlayer entityPlayer) {
            Intrinsics.checkNotNullParameter(entityPlayer, "<set-?>");
            this.player = entityPlayer;
        }

        public final boolean needDelete() {
            return this.timeout == 0;
        }

        public final void timeoutReset() {
            this.timeout = 2400;
        }

        public final void timeoutDec() {
            int n = this.timeout;
            this.timeout = n + -1;
            if (this.timeout < 0) {
                this.timeout = 0;
            }
        }
    }
}

