/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.LinkedList;
import mods.eln.Eln;
import mods.eln.item.electricalitem.TreeCapitation;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Utils;
import mods.eln.node.NodeManager;
import mods.eln.server.ElnWorldStorage;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.WorldEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020!H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lmods/eln/server/ServerEventListener;", "", "()V", "lightningList", "Ljava/util/LinkedList;", "Lnet/minecraft/entity/effect/EntityLightningBolt;", "lightningListNext", "loadedWorlds", "Ljava/util/HashSet;", "", "clear", "", "getLightningClosestTo", "", "c", "Lmods/eln/misc/Coordinate;", "onNewEntity", "event", "Lnet/minecraftforge/event/entity/EntityEvent$EntityConstructing;", "onWorldLoad", "e", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "onWorldSave", "Lnet/minecraftforge/event/world/WorldEvent$Save;", "onWorldUnload", "Lnet/minecraftforge/event/world/WorldEvent$Unload;", "readSave", "worldSave", "Ljava/nio/file/Path;", "replaceFile", "from", "to", "tick", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "Companion", "FileNames", "Eln"})
public final class ServerEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LinkedList<EntityLightningBolt> lightningListNext = new LinkedList();
    @NotNull
    private LinkedList<EntityLightningBolt> lightningList = new LinkedList();
    @NotNull
    private final HashSet<Integer> loadedWorlds = new HashSet();

    public ServerEventListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.lightningList = this.lightningListNext;
        this.lightningListNext = new LinkedList();
        TreeCapitation.INSTANCE.process(0.05);
    }

    @SubscribeEvent
    public final void onNewEntity(@NotNull EntityEvent.EntityConstructing event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.entity instanceof EntityLightningBolt) {
            Entity entity = event.entity;
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type net.minecraft.entity.effect.EntityLightningBolt");
            this.lightningListNext.add((EntityLightningBolt)entity);
        }
    }

    public final void clear() {
        this.lightningList.clear();
    }

    public final double getLightningClosestTo(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter(c, "c");
        double best = 1.0E7;
        for (EntityLightningBolt l : this.lightningList) {
            double d;
            if (c.world() != l.field_70170_p || !((d = l.func_70011_f((double)c.x, (double)c.y, (double)c.z)) < best)) continue;
            best = d;
        }
        return best;
    }

    @SubscribeEvent
    public final void onWorldLoad(@NotNull WorldEvent.Load e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.world.field_72995_K) {
            return;
        }
        this.loadedWorlds.add(e.world.field_73011_w.field_76574_g);
        FileNames fileNames = new FileNames((WorldEvent)e);
        try {
            this.readSave(fileNames.getWorldSave());
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                System.out.println((Object)("Using BACKUP Electrical Age save: " + fileNames.getBackupSave()));
                this.readSave(fileNames.getBackupSave());
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                System.out.println((Object)"Failed to read backup save!");
                World world = e.world;
                Intrinsics.checkNotNullExpressionValue(world, "e.world");
                ElnWorldStorage.Companion.forWorld(world);
            }
        }
    }

    private final void readSave(Path worldSave) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Files.readAllBytes(worldSave));
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        Intrinsics.checkNotNullExpressionValue(nbt, "nbt");
        Companion.readFromEaWorldNBT(nbt);
    }

    @SubscribeEvent
    public final void onWorldUnload(@NotNull WorldEvent.Unload e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.world.field_72995_K) {
            return;
        }
        this.loadedWorlds.remove(e.world.field_73011_w.field_76574_g);
        try {
            NodeManager nodeManager = NodeManager.instance;
            Intrinsics.checkNotNull((Object)nodeManager);
            nodeManager.unload(e.world.field_73011_w.field_76574_g);
            Eln.ghostManager.unload(e.world.field_73011_w.field_76574_g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public final void onWorldSave(@NotNull WorldEvent.Save e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.world.field_72995_K) {
            return;
        }
        if (!this.loadedWorlds.contains(e.world.field_73011_w.field_76574_g)) {
            return;
        }
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            Companion.writeToEaWorldNBT(nbt, e.world.field_73011_w.field_76574_g);
            FileNames fileNames = new FileNames((WorldEvent)e);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(524288);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)bytes);
            Files.write(fileNames.getTempSave(), bytes.toByteArray(), new OpenOption[0]);
            if (Files.exists(fileNames.getWorldSave(), new LinkOption[0])) {
                this.replaceFile(fileNames.getWorldSave(), fileNames.getBackupSave());
            }
            this.replaceFile(fileNames.getTempSave(), fileNames.getWorldSave());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final void replaceFile(Path from, Path to) throws IOException {
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(from, to, copyOptionArray);
        }
        catch (AtomicMoveNotSupportedException e) {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(from, to, copyOptionArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0011"}, d2={"Lmods/eln/server/ServerEventListener$FileNames;", "", "e", "Lnet/minecraftforge/event/world/WorldEvent;", "(Lmods/eln/server/ServerEventListener;Lnet/minecraftforge/event/world/WorldEvent;)V", "backupSave", "Ljava/nio/file/Path;", "getBackupSave", "()Ljava/nio/file/Path;", "tempSave", "getTempSave", "worldSave", "getWorldSave", "getEaWorldSaveName", "", "w", "Lnet/minecraft/world/World;", "Eln"})
    private final class FileNames {
        @NotNull
        private final Path worldSave;
        @NotNull
        private final Path tempSave;
        @NotNull
        private final Path backupSave;

        public FileNames(WorldEvent e) {
            Intrinsics.checkNotNullParameter(e, "e");
            World world = e.world;
            Intrinsics.checkNotNullExpressionValue(world, "e.world");
            String saveName = this.getEaWorldSaveName(world);
            Path path = FileSystems.getDefault().getPath(saveName, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "getDefault().getPath(saveName)");
            this.worldSave = path;
            Path path2 = FileSystems.getDefault().getPath(saveName + ".tmp", new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "getDefault().getPath(\"$saveName.tmp\")");
            this.tempSave = path2;
            Path path3 = FileSystems.getDefault().getPath(saveName + ".bak", new String[0]);
            Intrinsics.checkNotNullExpressionValue(path3, "getDefault().getPath(\"$saveName.bak\")");
            this.backupSave = path3;
        }

        @NotNull
        public final Path getWorldSave() {
            return this.worldSave;
        }

        @NotNull
        public final Path getTempSave() {
            return this.tempSave;
        }

        @NotNull
        public final Path getBackupSave() {
            return this.backupSave;
        }

        private final String getEaWorldSaveName(World w) {
            return Utils.INSTANCE.getMapFolder() + "data/electricalAgeWorld" + w.field_73011_w.field_76574_g + ".dat";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lmods/eln/server/ServerEventListener$Companion;", "", "()V", "readFromEaWorldNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToEaWorldNBT", "dim", "", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public final void readFromEaWorldNBT(@NotNull NBTTagCompound nbt) {
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            try {
                NodeManager nodeManager = NodeManager.instance;
                Intrinsics.checkNotNull((Object)nodeManager);
                nodeManager.loadFromNbt(nbt.func_74775_l("nodes"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Eln.ghostManager.loadFromNBT(nbt.func_74775_l("ghost"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final void writeToEaWorldNBT(@Nullable NBTTagCompound nbt, int dim) {
            try {
                NodeManager nodeManager = NodeManager.instance;
                Intrinsics.checkNotNull((Object)nodeManager);
                nodeManager.saveToNbt(Utils.newNbtTagCompund(nbt, "nodes"), dim);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Eln.ghostManager.saveToNBT(Utils.newNbtTagCompund(nbt, "ghost"), dim);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

