/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.shadow.org.semver4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mods.eln.shadow.org.semver4j.Range;
import mods.eln.shadow.org.semver4j.Semver;

public class RangesList {
    private static final String OR_JOINER = " or ";
    private static final String AND_JOINER = " and ";
    private final List<List<Range>> rangesList = new ArrayList<List<Range>>();

    public RangesList add(List<Range> ranges) {
        if (!ranges.isEmpty()) {
            this.rangesList.add(ranges);
        }
        return this;
    }

    public List<List<Range>> get() {
        return this.rangesList;
    }

    public boolean isSatisfiedByAny() {
        return this.rangesList.stream().flatMap(Collection::stream).allMatch(Range::isSatisfiedByAny);
    }

    public boolean isSatisfiedBy(Semver version) {
        return this.rangesList.stream().anyMatch(ranges -> RangesList.isSingleSetOfRangesIsSatisfied(ranges, version));
    }

    public String toString() {
        return this.rangesList.stream().map(RangesList::formatRanges).collect(Collectors.joining(OR_JOINER)).replaceAll("^\\(([^()]+)\\)$", "$1");
    }

    private static String formatRanges(List<Range> ranges) {
        String representation = ranges.stream().map(Range::toString).collect(Collectors.joining(AND_JOINER));
        if (ranges.size() < 2) {
            return representation;
        }
        return String.format(Locale.ROOT, "(%s)", representation);
    }

    private static boolean isSingleSetOfRangesIsSatisfied(List<Range> ranges, Semver version) {
        for (Range range : ranges) {
            if (range.isSatisfiedBy(version)) continue;
            return false;
        }
        if (!version.getPreRelease().isEmpty()) {
            for (Range range : ranges) {
                Semver rangeSemver = range.getRangeVersion();
                List<String> preRelease = rangeSemver.getPreRelease();
                if (preRelease.size() <= 0 || version.getMajor() != rangeSemver.getMajor() || version.getMinor() != rangeSemver.getMinor() || version.getPatch() != rangeSemver.getPatch()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

