/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.shadow.org.semver4j.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mods.eln.shadow.org.semver4j.Semver;

public class Modifier {
    private final Semver version;

    public Modifier(Semver version) {
        this.version = version;
    }

    public Semver nextMajor() {
        int nextMajor = this.version.getMajor();
        if (this.version.getMinor() != 0 || this.version.getPatch() != 0 || this.version.getPreRelease().isEmpty()) {
            ++nextMajor;
        }
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.0.0", nextMajor), Collections.emptyList());
        return new Semver(version);
    }

    public Semver withIncMajor(int number) {
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor() + number, this.version.getMinor(), this.version.getPatch()), this.version.getPreRelease());
        return new Semver(version);
    }

    public Semver nextMinor() {
        int nextMinor = this.version.getMinor();
        if (this.version.getPatch() != 0 || this.version.getPreRelease().isEmpty()) {
            ++nextMinor;
        }
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.0", this.version.getMajor(), nextMinor), Collections.emptyList());
        return new Semver(version);
    }

    public Semver withIncMinor(int number) {
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor() + number, this.version.getPatch()), this.version.getPreRelease());
        return new Semver(version);
    }

    public Semver nextPatch() {
        int newPatch = this.version.getPatch();
        if (this.version.getPreRelease().isEmpty()) {
            ++newPatch;
        }
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), newPatch), Collections.emptyList());
        return new Semver(version);
    }

    public Semver withIncPatch(int number) {
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), this.version.getPatch() + number), this.version.getPreRelease());
        return new Semver(version);
    }

    public Semver withPreRelease(String preRelease) {
        List<String> newPreRelease = Arrays.asList(preRelease.split("\\."));
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), this.version.getPatch()), newPreRelease);
        return new Semver(version);
    }

    public Semver withBuild(String build) {
        List<String> newBuild = Arrays.asList(build.split("\\."));
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), this.version.getPatch()), this.version.getPreRelease(), newBuild);
        return new Semver(version);
    }

    public Semver withClearedPreRelease() {
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), this.version.getPatch()), Collections.emptyList());
        return new Semver(version);
    }

    public Semver withClearedBuild() {
        String version = this.createFullVersion(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), this.version.getPatch()), this.version.getPreRelease(), Collections.emptyList());
        return new Semver(version);
    }

    public Semver withClearedPreReleaseAndBuild() {
        String version = String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajor(), this.version.getMinor(), this.version.getPatch());
        return new Semver(version);
    }

    private String createFullVersion(String main, List<String> preRelease) {
        return this.createFullVersion(main, preRelease, this.version.getBuild());
    }

    private String createFullVersion(String main, List<String> preRelease, List<String> build) {
        StringBuilder stringBuilder = new StringBuilder(main);
        if (!preRelease.isEmpty()) {
            stringBuilder.append("-");
            for (String s : preRelease) {
                stringBuilder.append(s).append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (!build.isEmpty()) {
            stringBuilder.append("+");
            for (String s : build) {
                stringBuilder.append(s).append(".");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

