/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.shadow.org.semver4j.internal.range.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.eln.shadow.org.semver4j.Range;
import mods.eln.shadow.org.semver4j.internal.Tokenizers;
import mods.eln.shadow.org.semver4j.internal.range.processor.Processor;
import mods.eln.shadow.org.semver4j.internal.range.processor.RangesUtils;

public class HyphenProcessor
implements Processor {
    private static final Pattern pattern = Pattern.compile(Tokenizers.HYPHEN);

    @Override
    public String process(String range) {
        Matcher matcher = pattern.matcher(range);
        if (!matcher.matches()) {
            return range;
        }
        String rangeFrom = this.getRangeFrom(matcher);
        String rangeTo = this.getRangeTo(matcher);
        return String.format(Locale.ROOT, "%s %s", rangeFrom, rangeTo);
    }

    private String getRangeFrom(Matcher matcher) {
        String from = matcher.group(1);
        int fromMajor = RangesUtils.parseIntWithXSupport(matcher.group(2));
        int fromMinor = RangesUtils.parseIntWithXSupport(matcher.group(3));
        int fromPatch = RangesUtils.parseIntWithXSupport(matcher.group(4));
        String fromPreRelease = matcher.group(5);
        String fromBuild = matcher.group(6);
        boolean minorIsX = RangesUtils.isX(fromMinor);
        boolean patchIsX = RangesUtils.isX(fromPatch);
        if (minorIsX) {
            return String.format(Locale.ROOT, "%s%d.0.0", Range.RangeOperator.GTE.asString(), fromMajor);
        }
        if (patchIsX) {
            return String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor);
        }
        return String.format(Locale.ROOT, "%s%s", Range.RangeOperator.GTE.asString(), from);
    }

    private String getRangeTo(Matcher matcher) {
        String to = matcher.group(7);
        int toMajor = RangesUtils.parseIntWithXSupport(matcher.group(8));
        int toMinor = RangesUtils.parseIntWithXSupport(matcher.group(9));
        int toPatch = RangesUtils.parseIntWithXSupport(matcher.group(10));
        String toPreRelease = matcher.group(11);
        String toBuild = matcher.group(12);
        boolean minorIsX = RangesUtils.isX(toMinor);
        boolean patchIsX = RangesUtils.isX(toPatch);
        if (minorIsX) {
            return String.format(Locale.ROOT, "%s%d.0.0", Range.RangeOperator.LT.asString(), toMajor + 1);
        }
        if (patchIsX) {
            return String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.LT.asString(), toMajor, toMinor + 1);
        }
        return String.format(Locale.ROOT, "%s%s", Range.RangeOperator.LTE.asString(), to);
    }
}

