/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.shadow.org.semver4j.internal.range.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.eln.shadow.org.semver4j.Range;
import mods.eln.shadow.org.semver4j.internal.Tokenizers;
import mods.eln.shadow.org.semver4j.internal.range.processor.Processor;
import mods.eln.shadow.org.semver4j.internal.range.processor.RangesUtils;

public class TildeProcessor
implements Processor {
    private static final Pattern pattern = Pattern.compile(Tokenizers.TILDE);

    @Override
    public String process(String range) {
        String to;
        String from;
        Matcher matcher = pattern.matcher(range);
        if (!matcher.matches()) {
            return range;
        }
        String fullRange = matcher.group(0);
        int major = RangesUtils.parseIntWithXSupport(matcher.group(1));
        int minor = RangesUtils.parseIntWithXSupport(matcher.group(2));
        int path = RangesUtils.parseIntWithXSupport(matcher.group(3));
        String preRelease = matcher.group(4);
        String build = matcher.group(5);
        if (RangesUtils.isX(minor)) {
            from = String.format(Locale.ROOT, "%s%d.0.0", Range.RangeOperator.GTE.asString(), major);
            to = String.format(Locale.ROOT, "%s%d.0.0", Range.RangeOperator.LT.asString(), major + 1);
        } else if (RangesUtils.isX(path)) {
            from = String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.GTE.asString(), major, minor);
            to = String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.LT.asString(), major, minor + 1);
        } else if (RangesUtils.isNotBlank(preRelease)) {
            from = String.format(Locale.ROOT, "%s%d.%d.%d-%s", Range.RangeOperator.GTE.asString(), major, minor, path, preRelease);
            to = String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.LT.asString(), major, minor + 1);
        } else {
            from = String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GTE.asString(), major, minor, path);
            to = String.format(Locale.ROOT, "%s%d.%d.0", Range.RangeOperator.LT.asString(), major, minor + 1);
        }
        return String.format(Locale.ROOT, "%s %s", from, to);
    }
}

