/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.misc.FunctionTable;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.state.VoltageState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\bJ\u0006\u00109\u001a\u00020\bJ\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\bH\u0016R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001f\"\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010&R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0011R\u001a\u0010+\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0011\"\u0004\b-\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006<"}, d2={"Lmods/eln/sim/BatteryProcess;", "Lmods/eln/sim/IProcess;", "positiveLoad", "Lmods/eln/sim/mna/state/VoltageState;", "negativeLoad", "voltageFunction", "Lmods/eln/misc/FunctionTable;", "IMax", "", "voltageSource", "Lmods/eln/sim/mna/component/VoltageSource;", "thermalLoad", "Lmods/eln/sim/ThermalLoad;", "(Lmods/eln/sim/mna/state/VoltageState;Lmods/eln/sim/mna/state/VoltageState;Lmods/eln/misc/FunctionTable;DLmods/eln/sim/mna/component/VoltageSource;Lmods/eln/sim/ThermalLoad;)V", "Q", "QNominal", "getQNominal", "()D", "setQNominal", "(D)V", "charge", "getCharge", "setCharge", "dischargeCurrent", "getDischargeCurrent", "energy", "getEnergy", "energyMax", "getEnergyMax", "isRechargeable", "", "()Z", "setRechargeable", "(Z)V", "life", "getNegativeLoad", "()Lmods/eln/sim/mna/state/VoltageState;", "setNegativeLoad", "(Lmods/eln/sim/mna/state/VoltageState;)V", "getPositiveLoad", "setPositiveLoad", "u", "getU", "uNominal", "getUNominal", "setUNominal", "getVoltageFunction", "()Lmods/eln/misc/FunctionTable;", "setVoltageFunction", "(Lmods/eln/misc/FunctionTable;)V", "getVoltageSource", "()Lmods/eln/sim/mna/component/VoltageSource;", "setVoltageSource", "(Lmods/eln/sim/mna/component/VoltageSource;)V", "changeLife", "", "newLife", "computeVoltage", "process", "time", "Eln"})
public class BatteryProcess
implements IProcess {
    @Nullable
    private VoltageState positiveLoad;
    @Nullable
    private VoltageState negativeLoad;
    @NotNull
    private FunctionTable voltageFunction;
    @JvmField
    public double IMax;
    @NotNull
    private VoltageSource voltageSource;
    @NotNull
    private ThermalLoad thermalLoad;
    @JvmField
    public double Q;
    private double QNominal;
    private double uNominal;
    @JvmField
    public double life;
    private boolean isRechargeable;

    public BatteryProcess(@Nullable VoltageState positiveLoad, @Nullable VoltageState negativeLoad, @NotNull FunctionTable voltageFunction, double IMax, @NotNull VoltageSource voltageSource, @NotNull ThermalLoad thermalLoad) {
        Intrinsics.checkNotNullParameter(voltageFunction, "voltageFunction");
        Intrinsics.checkNotNullParameter(voltageSource, "voltageSource");
        Intrinsics.checkNotNullParameter(thermalLoad, "thermalLoad");
        this.positiveLoad = positiveLoad;
        this.negativeLoad = negativeLoad;
        this.voltageFunction = voltageFunction;
        this.IMax = IMax;
        this.voltageSource = voltageSource;
        this.thermalLoad = thermalLoad;
        this.life = 1.0;
        this.isRechargeable = true;
    }

    @Nullable
    public final VoltageState getPositiveLoad() {
        return this.positiveLoad;
    }

    public final void setPositiveLoad(@Nullable VoltageState voltageState) {
        this.positiveLoad = voltageState;
    }

    @Nullable
    public final VoltageState getNegativeLoad() {
        return this.negativeLoad;
    }

    public final void setNegativeLoad(@Nullable VoltageState voltageState) {
        this.negativeLoad = voltageState;
    }

    @NotNull
    public final FunctionTable getVoltageFunction() {
        return this.voltageFunction;
    }

    public final void setVoltageFunction(@NotNull FunctionTable functionTable) {
        Intrinsics.checkNotNullParameter(functionTable, "<set-?>");
        this.voltageFunction = functionTable;
    }

    @NotNull
    public final VoltageSource getVoltageSource() {
        return this.voltageSource;
    }

    public final void setVoltageSource(@NotNull VoltageSource voltageSource) {
        Intrinsics.checkNotNullParameter(voltageSource, "<set-?>");
        this.voltageSource = voltageSource;
    }

    public final double getQNominal() {
        return this.QNominal;
    }

    public final void setQNominal(double d) {
        this.QNominal = d;
    }

    public final double getUNominal() {
        return this.uNominal;
    }

    public final void setUNominal(double d) {
        this.uNominal = d;
    }

    public final boolean isRechargeable() {
        return this.isRechargeable;
    }

    public final void setRechargeable(boolean bl) {
        this.isRechargeable = bl;
    }

    @Override
    public void process(double time) {
        double lastQ = this.Q;
        double wasteQ = 0.0;
        this.Q = Math.max(this.Q - this.voltageSource.getCurrent() * time / this.QNominal, 0.0);
        if (this.Q > lastQ && !this.isRechargeable) {
            System.out.println((Object)"Battery is recharging when it shouldn't!");
            wasteQ = this.Q - lastQ;
            this.Q = lastQ;
        }
        double voltage = this.computeVoltage();
        this.voltageSource.setVoltage(voltage);
        if (wasteQ > 0.0) {
            this.thermalLoad.movePowerTo(Math.abs(this.voltageSource.getCurrent() * voltage));
        }
    }

    public final double computeVoltage() {
        double voltage = this.voltageFunction.getValue(this.Q / this.life);
        return Math.max(0.0, voltage * this.uNominal);
    }

    public final void changeLife(double newLife) {
        if (newLife < this.life) {
            this.Q *= newLife / this.life;
        }
        this.life = newLife;
    }

    public final double getCharge() {
        return this.Q / this.life;
    }

    public final void setCharge(double charge) {
        this.Q = this.life * charge;
    }

    public final double getEnergy() {
        int stepNbr = 50;
        double chargeStep = this.getCharge() / (double)stepNbr;
        double chargeIntegrator = 0.0;
        double energy = 0.0;
        double QperStep = this.QNominal * this.life * chargeStep;
        for (int step = 0; step < stepNbr; ++step) {
            double voltage = this.voltageFunction.getValue(chargeIntegrator) * this.uNominal;
            energy += voltage * QperStep;
            chargeIntegrator += chargeStep;
        }
        return energy;
    }

    public final double getEnergyMax() {
        int stepNbr = 50;
        double chargeStep = 1.0 / (double)stepNbr;
        double chargeIntegrator = 0.0;
        double energy = 0.0;
        double QperStep = this.QNominal * this.life * 1.0 / (double)stepNbr;
        for (int step = 0; step < stepNbr; ++step) {
            double voltage = this.voltageFunction.getValue(chargeIntegrator) * this.uNominal;
            energy += voltage * QperStep;
            chargeIntegrator += chargeStep;
        }
        return energy;
    }

    public final double getU() {
        return this.computeVoltage();
    }

    public final double getDischargeCurrent() {
        return this.voltageSource.getCurrent();
    }
}

