/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.server.SaveConfig;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.BatteryProcess;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lmods/eln/sim/BatterySlowProcess;", "Lmods/eln/sim/IProcess;", "batteryProcess", "Lmods/eln/sim/BatteryProcess;", "thermalLoad", "Lmods/eln/sim/ThermalLoad;", "(Lmods/eln/sim/BatteryProcess;Lmods/eln/sim/ThermalLoad;)V", "lifeNominalCurrent", "", "getLifeNominalCurrent", "()D", "setLifeNominalCurrent", "(D)V", "lifeNominalLost", "getLifeNominalLost", "setLifeNominalLost", "maximumVoltage", "getMaximumVoltage", "getThermalLoad", "()Lmods/eln/sim/ThermalLoad;", "setThermalLoad", "(Lmods/eln/sim/ThermalLoad;)V", "destroy", "", "process", "time", "Eln"})
public abstract class BatterySlowProcess
implements IProcess {
    @NotNull
    private BatteryProcess batteryProcess;
    @NotNull
    private ThermalLoad thermalLoad;
    private double lifeNominalCurrent;
    private double lifeNominalLost;

    public BatterySlowProcess(@NotNull BatteryProcess batteryProcess, @NotNull ThermalLoad thermalLoad) {
        Intrinsics.checkNotNullParameter(batteryProcess, "batteryProcess");
        Intrinsics.checkNotNullParameter(thermalLoad, "thermalLoad");
        this.batteryProcess = batteryProcess;
        this.thermalLoad = thermalLoad;
    }

    @NotNull
    public final ThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    public final void setThermalLoad(@NotNull ThermalLoad thermalLoad) {
        Intrinsics.checkNotNullParameter(thermalLoad, "<set-?>");
        this.thermalLoad = thermalLoad;
    }

    public final double getLifeNominalCurrent() {
        return this.lifeNominalCurrent;
    }

    public final void setLifeNominalCurrent(double d) {
        this.lifeNominalCurrent = d;
    }

    public final double getLifeNominalLost() {
        return this.lifeNominalLost;
    }

    public final void setLifeNominalLost(double d) {
        this.lifeNominalLost = d;
    }

    @Override
    public void process(double time) {
        double voltage = this.batteryProcess.getU();
        if (voltage < -0.1 * this.batteryProcess.getUNominal()) {
            this.destroy();
            return;
        }
        if (voltage > this.getMaximumVoltage()) {
            this.destroy();
            return;
        }
        SaveConfig saveConfig = SaveConfig.instance;
        Intrinsics.checkNotNull((Object)saveConfig);
        if (saveConfig.getBatteryAging()) {
            double newLife = this.batteryProcess.life;
            double normalisedCurrent = Math.abs(this.batteryProcess.getDischargeCurrent()) / this.lifeNominalCurrent;
            if ((newLife -= normalisedCurrent * normalisedCurrent * this.lifeNominalLost * time) < 0.1) {
                newLife = 0.1;
            }
            this.batteryProcess.changeLife(newLife);
        }
    }

    public final double getMaximumVoltage() {
        return 1.3 * this.batteryProcess.getUNominal();
    }

    public abstract void destroy();
}

