/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.misc.Utils;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.component.InterSystem;

public class ElectricalConnection
extends InterSystem {
    ElectricalLoad L1;
    ElectricalLoad L2;

    public ElectricalConnection(ElectricalLoad L1, ElectricalLoad L2) {
        this.L1 = L1;
        this.L2 = L2;
        if (L1 == L2) {
            Utils.println("WARNING: Attempt to connect load to itself?");
        }
    }

    public void notifyRsChange() {
        double resistance = ((ElectricalLoad)this.aPin).getSerialResistance() + ((ElectricalLoad)this.bPin).getSerialResistance();
        this.setResistance(resistance);
    }

    @Override
    public void onAddToRootSystem() {
        this.connectTo(this.L1, this.L2);
        this.notifyRsChange();
    }

    @Override
    public void onRemoveFromRootSystem() {
        this.breakConnection();
    }
}

