/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.Line;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.mna.state.VoltageStateLineReady;

public class ElectricalLoad
extends VoltageStateLineReady {
    public static final State groundLoad = null;
    private double serialResistance = 1.0E9;

    public void setSerialResistance(double serialResistance) {
        if (this.serialResistance != serialResistance) {
            this.serialResistance = serialResistance;
            for (Component c : this.getConnectedComponents()) {
                if (!(c instanceof ElectricalConnection)) continue;
                ((ElectricalConnection)c).notifyRsChange();
            }
        }
    }

    public double getSerialResistance() {
        return this.serialResistance;
    }

    public void highImpedance() {
        this.setSerialResistance(1.0E9);
    }

    public double getCurrent() {
        double current = 0.0;
        for (Component c : this.getConnectedComponents()) {
            if (!(c instanceof Bipole) || c instanceof Line) continue;
            current += Math.abs(((Bipole)c).getCurrent());
        }
        return current * 0.5;
    }
}

