/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.RegulatorProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;

public class RegulatorThermalLoadToElectricalResistor
extends RegulatorProcess {
    ThermalLoad thermalLoad;
    Resistor electricalResistor;
    double minimumResistance;

    public void setMinimumResistance(double minimumResistance) {
        this.minimumResistance = minimumResistance;
    }

    public RegulatorThermalLoadToElectricalResistor(String name, ThermalLoad thermalLoad, Resistor electricalResistor) {
        super(name);
        this.thermalLoad = thermalLoad;
        this.electricalResistor = electricalResistor;
    }

    @Override
    protected double getHit() {
        return this.thermalLoad.temperatureCelsius;
    }

    @Override
    protected void setCmd(double cmd) {
        if (cmd <= 0.001) {
            this.electricalResistor.highImpedance();
        } else if (cmd >= 1.0) {
            this.electricalResistor.setResistance(this.minimumResistance);
        } else {
            this.electricalResistor.setResistance(this.minimumResistance / cmd);
        }
    }
}

