/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.resistor.ResistorDescriptor;
import mods.eln.sixnode.resistor.ResistorElement;

public class ResistorProcess
implements IProcess {
    ResistorElement element;
    ResistorDescriptor descriptor;
    Resistor resistor;
    ThermalLoad thermal;
    private double lastResistance = -1.0;

    public ResistorProcess(ResistorElement element, Resistor resistor, ThermalLoad thermal, ResistorDescriptor descriptor) {
        this.element = element;
        this.descriptor = descriptor;
        this.resistor = resistor;
        this.thermal = thermal;
    }

    @Override
    public void process(double time) {
        double newResistance = Math.max(1.0E-9, this.element.nominalRs * (1.0 + this.descriptor.tempCoef * this.thermal.temperatureCelsius));
        if (this.element.control != null) {
            newResistance *= (this.element.control.getNormalized() + 0.01) / 1.01;
        }
        if (newResistance > this.lastResistance * 1.01 || newResistance < this.lastResistance * 0.99) {
            this.resistor.setResistance(newResistance);
            this.lastResistance = newResistance;
            this.element.needPublish();
        }
    }
}

