/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.eln.misc.Utils;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalConnection;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.RootSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.process.destruct.IDestructible;

public class Simulator {
    public RootSystem mna;
    private ArrayList<IProcess> slowProcessList;
    private List<IProcess> slowPreProcessList;
    private List<IProcess> slowPostProcessList;
    private ArrayList<IProcess> electricalProcessList;
    private ArrayList<IProcess> thermalFastProcessList;
    private ArrayList<IProcess> thermalSlowProcessList;
    private ArrayList<ThermalConnection> thermalFastConnectionList;
    private ArrayList<ThermalConnection> thermalSlowConnectionList;
    private ArrayList<ThermalLoad> thermalFastLoadList;
    private ArrayList<ThermalLoad> thermalSlowLoadList;
    private Set<IDestructible> destructableSet;
    boolean run;
    public double electricalPeriod;
    public double thermalPeriod;
    public double callPeriod;
    int electricalInterSystemOverSampling;
    int nodeCount = 0;
    int simplifyCMin = 0;
    int simplifyCMax = 100;
    double avgTickTime = 0.0;
    long electricalNsStack = 0L;
    long thermalFastNsStack = 0L;
    long slowNsStack = 0L;
    long thermalSlowNsStack = 0L;
    double timeout = 0.0;
    double electricalTimeout = 0.0;
    double thermalTimeout = 0.0;
    private int printTimeCounter = 0;
    public boolean pleaseCrash = false;

    public ArrayList<IProcess> getElectricalProcessList() {
        return this.electricalProcessList;
    }

    public double getMinimalThermalC(double Rs2, double Rp) {
        return this.thermalPeriod * 3.0 / (1.0 / (1.0 / Rp + 1.0 / Rs2));
    }

    public boolean checkThermalLoad(double thermalRs, double thermalRp, double thermalC) {
        if (thermalC < this.getMinimalThermalC(thermalRs, thermalRp)) {
            throw new IllegalStateException("Thermal load outside safe limits.");
        }
        return true;
    }

    public Simulator(double callPeriod, double electricalPeriod, int electricalInterSystemOverSampling, double thermalPeriod) {
        this.callPeriod = callPeriod;
        this.electricalPeriod = electricalPeriod;
        this.electricalInterSystemOverSampling = electricalInterSystemOverSampling;
        this.thermalPeriod = thermalPeriod;
        FMLCommonHandler.instance().bus().register((Object)this);
        this.mna = new RootSystem(electricalPeriod, electricalInterSystemOverSampling);
        this.slowProcessList = new ArrayList();
        this.slowPreProcessList = new ArrayList<IProcess>();
        this.slowPostProcessList = new ArrayList<IProcess>();
        this.electricalProcessList = new ArrayList();
        this.thermalFastProcessList = new ArrayList();
        this.thermalSlowProcessList = new ArrayList();
        this.thermalFastConnectionList = new ArrayList();
        this.thermalFastLoadList = new ArrayList();
        this.thermalSlowConnectionList = new ArrayList();
        this.thermalSlowLoadList = new ArrayList();
        this.destructableSet = new HashSet<IDestructible>();
        this.run = false;
    }

    public void init() {
        this.nodeCount = 0;
        this.mna = new RootSystem(this.electricalPeriod, this.electricalInterSystemOverSampling);
        this.slowProcessList.clear();
        this.slowPreProcessList.clear();
        this.slowPostProcessList.clear();
        this.electricalProcessList.clear();
        this.thermalFastProcessList.clear();
        this.thermalSlowProcessList.clear();
        this.thermalFastConnectionList.clear();
        this.thermalFastLoadList.clear();
        this.thermalSlowConnectionList.clear();
        this.thermalSlowLoadList.clear();
        this.destructableSet.clear();
        this.run = true;
    }

    public void stop() {
        this.nodeCount = 0;
        this.mna = null;
        this.slowProcessList.clear();
        this.slowPreProcessList.clear();
        this.slowPostProcessList.clear();
        this.electricalProcessList.clear();
        this.thermalFastProcessList.clear();
        this.thermalSlowProcessList.clear();
        this.thermalFastConnectionList.clear();
        this.thermalFastLoadList.clear();
        this.thermalSlowConnectionList.clear();
        this.thermalSlowLoadList.clear();
        this.destructableSet.clear();
        this.run = false;
    }

    public void addElectricalComponent(Component c) {
        if (c != null) {
            this.mna.addComponent(c);
        }
    }

    public void removeElectricalComponent(Component c) {
        if (c != null) {
            this.mna.removeComponent(c);
        }
    }

    public void addThermalConnection(ThermalConnection connection) {
        if (connection != null) {
            if (connection.L1.isSlow() == connection.L2.isSlow()) {
                if (connection.L1.isSlow()) {
                    this.thermalSlowConnectionList.add(connection);
                } else {
                    this.thermalFastConnectionList.add(connection);
                }
            } else {
                Utils.println("***** addThermalConnection ERROR ****");
            }
        }
    }

    public void removeThermalConnection(ThermalConnection connection) {
        if (connection != null) {
            this.thermalSlowConnectionList.remove(connection);
            this.thermalFastConnectionList.remove(connection);
        }
    }

    public void addElectricalLoad(State load) {
        if (load != null) {
            this.mna.addState(load);
        }
    }

    public void removeElectricalLoad(State load) {
        if (load != null) {
            this.mna.removeState(load);
        }
    }

    public void addThermalLoad(ThermalLoad load) {
        if (load != null) {
            if (load.isSlow()) {
                this.thermalSlowLoadList.add(load);
            } else {
                this.thermalFastLoadList.add(load);
            }
        }
    }

    public void removeThermalLoad(ThermalLoad load) {
        if (load != null) {
            this.thermalSlowLoadList.remove(load);
            this.thermalFastLoadList.remove(load);
        }
    }

    public void addSlowProcess(IProcess process) {
        if (process != null) {
            this.slowProcessList.add(process);
        }
    }

    public void removeSlowProcess(IProcess process) {
        if (process != null) {
            this.slowProcessList.remove(process);
        }
    }

    public void addSlowPreProcess(IProcess process) {
        if (process != null) {
            this.slowPreProcessList.add(process);
        }
    }

    public void removeSlowPreProcess(IProcess process) {
        if (process != null) {
            this.slowPreProcessList.remove(process);
        }
    }

    public void addSlowPostProcess(IProcess process) {
        if (process != null) {
            this.slowPostProcessList.add(process);
        }
    }

    public void removeSlowPostProcess(IProcess process) {
        if (process != null) {
            this.slowPostProcessList.remove(process);
        }
    }

    public void addElectricalProcess(IProcess process) {
        if (process != null) {
            this.electricalProcessList.add(process);
        }
    }

    public void removeElectricalProcess(IProcess process) {
        if (process != null) {
            this.electricalProcessList.remove(process);
        }
    }

    public void addThermalFastProcess(IProcess process) {
        if (process != null) {
            this.thermalFastProcessList.add(process);
        }
    }

    public void removeThermalFastProcess(IProcess process) {
        if (process != null) {
            this.thermalFastProcessList.remove(process);
        }
    }

    public void addThermalSlowProcess(IProcess process) {
        if (process != null) {
            this.thermalSlowProcessList.add(process);
        }
    }

    public void removeThermalSlowProcess(IProcess process) {
        if (process != null) {
            this.thermalSlowProcessList.remove(process);
        }
    }

    public void addAllElectricalConnection(Iterable<ElectricalConnection> connection) {
        if (connection != null) {
            for (ElectricalConnection c : connection) {
                this.addElectricalComponent(c);
            }
        }
    }

    public void removeAllElectricalConnection(Iterable<ElectricalConnection> connection) {
        if (connection != null) {
            for (ElectricalConnection c : connection) {
                this.removeElectricalComponent(c);
            }
        }
    }

    public void addAllElectricalComponent(Iterable<Component> cList) {
        if (cList != null) {
            for (Component c : cList) {
                this.addElectricalComponent(c);
            }
        }
    }

    public void removeAllElectricalComponent(Iterable<Component> cList) {
        if (cList != null) {
            for (Component c : cList) {
                this.removeElectricalComponent(c);
            }
        }
    }

    public void addAllThermalConnection(Iterable<ThermalConnection> connection) {
        if (connection != null) {
            for (ThermalConnection c : connection) {
                this.addThermalConnection(c);
            }
        }
    }

    public void removeAllThermalConnection(Iterable<ThermalConnection> connection) {
        if (connection != null) {
            for (ThermalConnection c : connection) {
                this.removeThermalConnection(c);
            }
        }
    }

    public void addAllElectricalLoad(Iterable<ElectricalLoad> load) {
        if (load != null) {
            for (ElectricalLoad l : load) {
                this.addElectricalLoad(l);
            }
        }
    }

    public void removeAllElectricalLoad(Iterable<ElectricalLoad> load) {
        if (load != null) {
            for (ElectricalLoad l : load) {
                this.removeElectricalLoad(l);
            }
        }
    }

    public void addAllThermalLoad(Iterable<ThermalLoad> load) {
        if (load != null) {
            for (ThermalLoad c : load) {
                this.addThermalLoad(c);
            }
        }
    }

    public void removeAllThermalLoad(Iterable<ThermalLoad> load) {
        if (load != null) {
            for (ThermalLoad c : load) {
                this.removeThermalLoad(c);
            }
        }
    }

    public void addAllSlowProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.slowProcessList.addAll(process);
        }
    }

    public void removeAllSlowProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.slowProcessList.removeAll(process);
        }
    }

    public void addAllElectricalProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.electricalProcessList.addAll(process);
        }
    }

    public void removeAllElectricalProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.electricalProcessList.removeAll(process);
        }
    }

    public void addAllThermalFastProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.thermalFastProcessList.addAll(process);
        }
    }

    public void removeAllThermalFastProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.thermalFastProcessList.removeAll(process);
        }
    }

    public void addAllThermalSlowProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.thermalSlowProcessList.addAll(process);
        }
    }

    public void removeAllThermalSlowProcess(ArrayList<IProcess> process) {
        if (process != null) {
            this.thermalSlowProcessList.removeAll(process);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        long stackStart;
        IProcess process;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.pleaseCrash) {
            throw new StackOverflowError();
        }
        long startTime = System.nanoTime();
        for (Object o : this.slowPreProcessList.toArray()) {
            process = (IProcess)o;
            process.process(0.05);
        }
        this.timeout += this.callPeriod;
        while (this.timeout > 0.0) {
            double dt;
            if (this.timeout < this.electricalTimeout && this.timeout < this.thermalTimeout) {
                this.thermalTimeout -= this.timeout;
                this.electricalTimeout -= this.timeout;
                this.timeout = 0.0;
                break;
            }
            if (this.electricalTimeout <= this.thermalTimeout) {
                dt = this.electricalTimeout;
                this.electricalTimeout += this.electricalPeriod;
                stackStart = System.nanoTime();
                this.mna.step();
                for (IProcess p : this.electricalProcessList) {
                    p.process(this.electricalPeriod);
                }
                this.electricalNsStack += System.nanoTime() - stackStart;
            } else {
                dt = this.thermalTimeout;
                this.thermalTimeout += this.thermalPeriod;
                stackStart = System.nanoTime();
                this.thermalStep(this.thermalPeriod, this.thermalFastConnectionList, this.thermalFastProcessList, this.thermalFastLoadList);
                this.thermalFastNsStack += System.nanoTime() - stackStart;
            }
            this.thermalTimeout -= dt;
            this.electricalTimeout -= dt;
            this.timeout -= dt;
        }
        stackStart = System.nanoTime();
        this.thermalStep(0.05, this.thermalSlowConnectionList, this.thermalSlowProcessList, this.thermalSlowLoadList);
        this.thermalSlowNsStack += System.nanoTime() - stackStart;
        stackStart = System.nanoTime();
        for (Object o : this.slowProcessList.toArray()) {
            process = (IProcess)o;
            process.process(0.05);
        }
        for (IDestructible d : this.destructableSet) {
            d.destructImpl();
        }
        this.destructableSet.clear();
        this.slowNsStack += System.nanoTime() - stackStart;
        this.avgTickTime += 0.05 * (double)((int)(System.nanoTime() - startTime) / 1000);
        if (++this.printTimeCounter == 20) {
            this.printTimeCounter = 0;
            this.electricalNsStack /= 20L;
            this.thermalFastNsStack /= 20L;
            this.thermalSlowNsStack /= 20L;
            this.slowNsStack /= 20L;
            Utils.println("ticks " + new DecimalFormat("#").format((int)this.avgTickTime) + " us  E " + this.electricalNsStack / 1000L + "  TF " + this.thermalFastNsStack / 1000L + "  TS " + this.thermalSlowNsStack / 1000L + "  S " + this.slowNsStack / 1000L + "    " + this.mna.getSubSystemCount() + " SS    " + this.electricalProcessList.size() + " EP    " + this.thermalFastLoadList.size() + " TFL    " + this.thermalFastConnectionList.size() + " TFC    " + this.thermalFastProcessList.size() + " TFP    " + this.thermalSlowLoadList.size() + " TSL    " + this.thermalSlowConnectionList.size() + " TSC    " + this.thermalSlowProcessList.size() + " TSP    " + this.slowProcessList.size() + " SP");
            this.avgTickTime = 0.0;
            this.electricalNsStack = 0L;
            this.thermalFastNsStack = 0L;
            this.slowNsStack = 0L;
            this.thermalSlowNsStack = 0L;
        }
        for (IProcess o : this.slowPostProcessList) {
            o.process(0.05);
        }
    }

    public boolean isRegistred(ElectricalLoad load) {
        return this.mna.isRegistred(load);
    }

    void thermalStep(double dt, Iterable<ThermalConnection> connectionList, Iterable<IProcess> processList, Iterable<ThermalLoad> loadList) {
        for (ThermalConnection c : connectionList) {
            double i = (c.L2.temperatureCelsius - c.L1.temperatureCelsius) / (c.L2.Rs + c.L1.Rs);
            c.L1.PcTemp += i;
            c.L2.PcTemp -= i;
            c.L1.PrsTemp += Math.abs(i);
            c.L2.PrsTemp += Math.abs(i);
        }
        if (processList != null) {
            for (IProcess process : processList) {
                process.process(dt);
            }
        }
        for (ThermalLoad load : loadList) {
            load.PcTemp -= load.temperatureCelsius / load.Rp;
            load.temperatureCelsius += load.PcTemp * dt / load.heatCapacity;
            load.Pc = load.PcTemp;
            load.Prs = load.PrsTemp;
            load.Psp = load.PspTemp;
            load.PcTemp = 0.0;
            load.PrsTemp = 0.0;
            load.PspTemp = 0.0;
        }
    }
}

