/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.misc.Recipe;
import mods.eln.misc.RecipesList;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.collections.ArraysKt;
import mods.eln.shadow.kotlin.jvm.functions.Function0;
import mods.eln.shadow.kotlin.jvm.functions.Function1;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001Bb\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000e\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010'\u001a\u00020&J\b\u0010(\u001a\u00020\fH\u0002J\u0006\u0010)\u001a\u00020\fJ\u0015\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\u0012H\u0002J\b\u00101\u001a\u00020\u0012H\u0002R\u001a\u0010\u0014\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R,\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lmods/eln/sim/StackMachineProcess;", "Lmods/eln/sim/IProcess;", "inventory", "Lnet/minecraft/inventory/IInventory;", "inputSlotId", "", "outputSlotId", "outputSlotNbr", "recipesList", "Lmods/eln/misc/RecipesList;", "energyProvidedFunction", "Lmods/eln/shadow/kotlin/Function0;", "", "energyConsumerFunction", "Lmods/eln/shadow/kotlin/Function1;", "Lmods/eln/shadow/kotlin/ParameterName;", "name", "energy", "", "(Lnet/minecraft/inventory/IInventory;IIILmods/eln/misc/RecipesList;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "efficiency", "getEfficiency", "()D", "setEfficiency", "(D)V", "getEnergyConsumerFunction", "()Lkotlin/jvm/functions/Function1;", "energyCounter", "energyNeeded", "getEnergyProvidedFunction", "()Lkotlin/jvm/functions/Function0;", "getInventory", "()Lnet/minecraft/inventory/IInventory;", "setInventory", "(Lnet/minecraft/inventory/IInventory;)V", "outSlotIdList", "", "smeltInProcess", "", "canSmelt", "getAvailablePower", "getProcessState", "getSmeltResult", "", "Lnet/minecraft/item/ItemStack;", "()[Lnet/minecraft/item/ItemStack;", "process", "time", "smeltInit", "smeltItem", "Eln"})
public final class StackMachineProcess
implements IProcess {
    @Nullable
    private IInventory inventory;
    private int inputSlotId;
    @Nullable
    private RecipesList recipesList;
    @NotNull
    private final Function0<Double> energyProvidedFunction;
    @NotNull
    private final Function1<Double, Unit> energyConsumerFunction;
    @NotNull
    private int[] outSlotIdList;
    private double efficiency;
    private boolean smeltInProcess;
    private double energyNeeded;
    private double energyCounter;

    public StackMachineProcess(@Nullable IInventory inventory, int inputSlotId, int outputSlotId, int outputSlotNbr, @Nullable RecipesList recipesList, @NotNull Function0<Double> energyProvidedFunction, @NotNull Function1<? super Double, Unit> energyConsumerFunction) {
        Intrinsics.checkNotNullParameter(energyProvidedFunction, "energyProvidedFunction");
        Intrinsics.checkNotNullParameter(energyConsumerFunction, "energyConsumerFunction");
        this.inventory = inventory;
        this.inputSlotId = inputSlotId;
        this.recipesList = recipesList;
        this.energyProvidedFunction = energyProvidedFunction;
        this.energyConsumerFunction = energyConsumerFunction;
        this.outSlotIdList = new int[outputSlotNbr];
        this.efficiency = 1.0;
        for (int idx = 0; idx < outputSlotNbr; ++idx) {
            this.outSlotIdList[idx] = idx + outputSlotId;
        }
    }

    @Nullable
    public final IInventory getInventory() {
        return this.inventory;
    }

    public final void setInventory(@Nullable IInventory iInventory) {
        this.inventory = iInventory;
    }

    @NotNull
    public final Function0<Double> getEnergyProvidedFunction() {
        return this.energyProvidedFunction;
    }

    @NotNull
    public final Function1<Double, Unit> getEnergyConsumerFunction() {
        return this.energyConsumerFunction;
    }

    public final double getEfficiency() {
        return this.efficiency;
    }

    public final void setEfficiency(double d) {
        this.efficiency = d;
    }

    @Override
    public void process(double time) {
        if (!this.canSmelt() || !this.smeltInProcess) {
            this.smeltInit();
        }
        if (this.smeltInProcess) {
            double energyConsumed = this.getAvailablePower() * time;
            this.energyCounter += energyConsumed;
            this.energyConsumerFunction.invoke(energyConsumed);
            System.out.println((Object)("consuming power " + energyConsumed));
            if (this.energyCounter > this.energyNeeded) {
                this.energyCounter -= this.energyNeeded;
                this.smeltItem();
                this.smeltInit();
            }
        }
    }

    private final double getAvailablePower() {
        return ((Number)this.energyProvidedFunction.invoke()).doubleValue() * this.efficiency;
    }

    private final void smeltInit() {
        this.smeltInProcess = this.canSmelt();
        if (!this.smeltInProcess) {
            this.smeltInProcess = false;
            this.energyNeeded = 1.0;
            this.energyCounter = 0.0;
        } else {
            this.smeltInProcess = true;
            RecipesList recipesList = this.recipesList;
            Intrinsics.checkNotNull(recipesList);
            IInventory iInventory = this.inventory;
            Intrinsics.checkNotNull(iInventory);
            Recipe recipe = recipesList.getRecipe(iInventory.func_70301_a(this.inputSlotId));
            Intrinsics.checkNotNull(recipe);
            this.energyNeeded = recipe.energy;
            this.energyCounter = 0.0;
        }
    }

    public final boolean canSmelt() {
        boolean bl;
        IInventory iInventory = this.inventory;
        Intrinsics.checkNotNull(iInventory);
        if (iInventory.func_70301_a(this.inputSlotId) == null) {
            bl = false;
        } else {
            if (this.getSmeltResult() == null) {
                return false;
            }
            ItemStack[] itemStackArray = this.getSmeltResult();
            Intrinsics.checkNotNull(itemStackArray);
            IInventory iInventory2 = this.inventory;
            Intrinsics.checkNotNull(iInventory2);
            bl = Utils.canPutStackInInventory(itemStackArray, iInventory2, this.outSlotIdList);
        }
        return bl;
    }

    private final ItemStack[] getSmeltResult() {
        RecipesList recipesList = this.recipesList;
        Intrinsics.checkNotNull(recipesList);
        IInventory iInventory = this.inventory;
        Intrinsics.checkNotNull(iInventory);
        Recipe recipe = recipesList.getRecipe(iInventory.func_70301_a(this.inputSlotId));
        if (recipe == null) {
            return null;
        }
        Recipe recipe2 = recipe;
        return recipe2.output;
    }

    private final void smeltItem() {
        if (this.canSmelt()) {
            Recipe recipe;
            RecipesList recipesList = this.recipesList;
            Intrinsics.checkNotNull(recipesList);
            IInventory iInventory = this.inventory;
            Intrinsics.checkNotNull(iInventory);
            Recipe recipe2 = recipe = recipesList.getRecipe(iInventory.func_70301_a(this.inputSlotId));
            Intrinsics.checkNotNull(recipe2);
            IInventory iInventory2 = this.inventory;
            Intrinsics.checkNotNull(iInventory2);
            Utils.tryPutStackInInventory(ArraysKt.requireNoNulls(recipe2.getOutputCopy()), iInventory2, this.outSlotIdList);
            IInventory iInventory3 = this.inventory;
            Intrinsics.checkNotNull(iInventory3);
            iInventory3.func_70298_a(this.inputSlotId, recipe.input.field_77994_a);
        }
    }

    public final double getProcessState() {
        if (!this.smeltInProcess) {
            return 0.0;
        }
        double state = this.energyCounter / this.energyNeeded;
        if (state > 1.0) {
            state = 1.0;
        }
        return state;
    }
}

