/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

public class ThermalLoad {
    public double temperatureCelsius;
    public double Rp;
    public double Rs;
    public double heatCapacity;
    public double Pc;
    public double Prs;
    public double Psp;
    public double PrsTemp = 0.0;
    public double PspTemp = 0.0;
    public double PcTemp;
    boolean isSlow;
    public static final ThermalLoad externalLoad = new ThermalLoad(0.0, 0.0, 0.0, 0.0);

    public ThermalLoad() {
        this.setHighImpedance();
        this.temperatureCelsius = 0.0;
        this.PcTemp = 0.0;
        this.Pc = 0.0;
        this.Prs = 0.0;
        this.Psp = 0.0;
    }

    public ThermalLoad(double Tc, double Rp, double Rs2, double heatCapacity) {
        this.temperatureCelsius = Tc;
        this.Rp = Rp;
        this.Rs = Rs2;
        this.heatCapacity = heatCapacity;
        this.PcTemp = 0.0;
    }

    public void setRsByTao(double tao) {
        this.Rs = tao / this.heatCapacity;
    }

    public void setHighImpedance() {
        this.Rs = 1.0E9;
        this.heatCapacity = 1.0;
        this.Rp = 1.0E9;
    }

    public void setRp(double Rp) {
        this.Rp = Rp;
    }

    public double getPower() {
        if (Double.isNaN(this.Prs) || Double.isNaN(this.Pc) || Double.isNaN(this.temperatureCelsius) || Double.isNaN(this.Rp) || Double.isNaN(this.Psp)) {
            return 0.0;
        }
        return (this.Prs + Math.abs(this.Pc) + this.temperatureCelsius / this.Rp + this.Psp) / 2.0;
    }

    public void set(double Rs2, double Rp, double C) {
        this.Rp = Rp;
        this.Rs = Rs2;
        this.heatCapacity = C;
    }

    public static void moveEnergy(double energy, double time, ThermalLoad from, ThermalLoad to) {
        if (Double.isNaN(energy) || Double.isNaN(time) || time == 0.0 || time == -0.0 || Double.isNaN(from.PcTemp) || Double.isNaN(from.PspTemp)) {
            return;
        }
        double I = energy / time;
        double absI = Math.abs(I);
        from.PcTemp -= I;
        to.PcTemp += I;
        from.PspTemp += absI;
        to.PspTemp += absI;
    }

    public static void movePower(double power2, ThermalLoad from, ThermalLoad to) {
        if (Double.isNaN(power2) || Double.isNaN(from.PcTemp) || Double.isNaN(from.PspTemp)) {
            return;
        }
        double absI = Math.abs(power2);
        from.PcTemp -= power2;
        to.PcTemp += power2;
        from.PspTemp += absI;
        to.PspTemp += absI;
    }

    public void movePowerTo(double power2) {
        if (Double.isNaN(power2)) {
            return;
        }
        this.PcTemp += power2;
        this.PspTemp += power2;
    }

    public double getTemperature() {
        if (Double.isNaN(this.temperatureCelsius)) {
            this.temperatureCelsius = 0.0;
        }
        return this.temperatureCelsius;
    }

    public boolean isSlow() {
        return this.isSlow;
    }

    public void setAsSlow() {
        this.isSlow = true;
    }

    public void setAsFast() {
        this.isSlow = false;
    }
}

