/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.Eln;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;

public class ThermalLoadInitializer {
    public double maximumTemperature;
    public double minimumTemperature;
    double heatingTao;
    double conductionTao;
    double Rs;
    double Rp;
    double C;

    public ThermalLoadInitializer(double maximumTemperature, double minimumTemperature, double heatingTao, double conductionTao) {
        this.conductionTao = conductionTao;
        this.minimumTemperature = minimumTemperature;
        this.heatingTao = heatingTao;
        this.maximumTemperature = maximumTemperature;
    }

    public void setMaximalPower(double power2) {
        this.C = power2 * this.heatingTao / this.maximumTemperature;
        this.Rp = this.maximumTemperature / power2;
        this.Rs = this.conductionTao / this.C / 2.0;
        Eln.simulator.checkThermalLoad(this.Rs, this.Rp, this.C);
    }

    public void applyTo(ThermalLoad load) {
        load.set(this.Rs, this.Rp, this.C);
    }

    public void applyTo(ThermalLoadWatchDog doggy) {
        doggy.setThermalLoad(this);
    }

    public ThermalLoadInitializer copy() {
        ThermalLoadInitializer thermalLoad = new ThermalLoadInitializer(this.maximumTemperature, this.minimumTemperature, this.heatingTao, this.conductionTao);
        thermalLoad.Rp = this.Rp;
        thermalLoad.Rs = this.Rs;
        thermalLoad.C = this.C;
        return thermalLoad;
    }
}

