/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.Eln;
import mods.eln.sim.ThermalLoad;

public class ThermalLoadInitializerByPowerDrop {
    public double maximumTemperature;
    public double minimumTemperature;
    double heatingTao;
    double TConductivityDrop;
    public double Rs;
    public double Rp;
    public double C;

    public ThermalLoadInitializerByPowerDrop(double maximumTemperature, double minimumTemperature, double heatingTao, double TConductivityDrop) {
        this.TConductivityDrop = TConductivityDrop;
        this.minimumTemperature = minimumTemperature;
        this.heatingTao = heatingTao;
        this.maximumTemperature = maximumTemperature;
    }

    public void setMaximalPower(double power2) {
        this.C = power2 * this.heatingTao / this.maximumTemperature;
        this.Rp = this.maximumTemperature / power2;
        this.Rs = this.TConductivityDrop / power2 / 2.0;
        Eln.simulator.checkThermalLoad(this.Rs, this.Rp, this.C);
    }

    public void applyToThermalLoad(ThermalLoad load) {
        load.set(this.Rs, this.Rp, this.C);
    }

    public ThermalLoadInitializerByPowerDrop copy() {
        ThermalLoadInitializerByPowerDrop thermalLoad = new ThermalLoadInitializerByPowerDrop(this.maximumTemperature, this.minimumTemperature, this.heatingTao, this.TConductivityDrop);
        thermalLoad.Rp = this.Rp;
        thermalLoad.Rs = this.Rs;
        thermalLoad.C = this.C;
        return thermalLoad;
    }
}

