/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;

public class ThermalResistor
implements IProcess {
    ThermalLoad a;
    ThermalLoad b;
    protected double thermalResistance;
    protected double thermalResistanceInverse;

    public ThermalResistor(ThermalLoad a, ThermalLoad b) {
        this.a = a;
        this.b = b;
        this.highImpedance();
    }

    @Override
    public void process(double time) {
        double power2 = (this.a.temperatureCelsius - this.b.temperatureCelsius) * this.thermalResistanceInverse;
        this.a.PcTemp -= power2;
        this.b.PcTemp += power2;
    }

    public double getPower() {
        return (this.a.temperatureCelsius - this.b.temperatureCelsius) * this.thermalResistanceInverse;
    }

    public void setThermalResistance(double thermalResistance) {
        this.thermalResistance = thermalResistance;
        this.thermalResistanceInverse = 1.0 / thermalResistance;
    }

    public double getThermalResistance() {
        return this.thermalResistance;
    }

    public void highImpedance() {
        this.setThermalResistance(1.0E9);
    }
}

