/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import mods.eln.misc.Profiler;
import mods.eln.misc.Utils;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.InterSystem;
import mods.eln.sim.mna.component.InterSystemAbstraction;
import mods.eln.sim.mna.component.Line;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.misc.ISubSystemProcessFlush;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.mna.state.VoltageState;

public class RootSystem {
    double dt;
    int interSystemOverSampling;
    public ArrayList<SubSystem> systems = new ArrayList();
    public Set<Component> addComponents = new HashSet<Component>();
    public HashSet<State> addStates = new HashSet();
    static final int maxSubSystemSize = 100;
    ArrayList<ISubSystemProcessFlush> processF = new ArrayList();
    ArrayList<IRootSystemPreStepProcess> processPre = new ArrayList();

    public RootSystem(double dt, int interSystemOverSampling) {
        this.dt = dt;
        this.interSystemOverSampling = interSystemOverSampling;
    }

    public void addComponent(Component c) {
        this.addComponents.add(c);
        c.onAddToRootSystem();
        for (State s : c.getConnectedStates()) {
            if (s == null || s.getSubSystem() == null) continue;
            this.breakSystems(s.getSubSystem());
        }
    }

    public void removeComponent(Component c) {
        SubSystem system = c.getSubSystem();
        if (system != null) {
            this.breakSystems(system);
        }
        this.addComponents.remove(c);
        c.onRemoveFromRootSystem();
    }

    public void addState(State s) {
        for (Component c : (ArrayList)s.getConnectedComponentsNotAbstracted().clone()) {
            if (c.getSubSystem() == null) continue;
            this.breakSystems(c.getSubSystem());
        }
        this.addStates.add(s);
    }

    public void removeState(State s) {
        SubSystem system = s.getSubSystem();
        if (system != null) {
            this.breakSystems(system);
        }
        this.addStates.remove(s);
    }

    public void generate() {
        if (!this.addComponents.isEmpty() || !this.addStates.isEmpty()) {
            Profiler p = new Profiler();
            p.add("*** Generate ***");
            this.generateLine();
            this.generateSystems();
            this.generateInterSystems();
            int stateCnt = 0;
            int componentCnt = 0;
            for (SubSystem s : this.systems) {
                stateCnt += s.states.size();
                componentCnt += s.component.size();
            }
            p.stop();
            Utils.println(p + " **** " + stateCnt + "   " + componentCnt);
        }
    }

    private boolean isValidForLine(State s) {
        if (!s.canBeSimplifiedByLine()) {
            return false;
        }
        ArrayList<Component> sc = s.getConnectedComponentsNotAbstracted();
        if (sc.size() != 2) {
            return false;
        }
        for (Component c : sc) {
            if (c instanceof Resistor) continue;
            return false;
        }
        return true;
    }

    private void generateLine() {
        HashSet<State> stateScope = new HashSet<State>();
        for (State s : this.addStates) {
            if (!this.isValidForLine(s)) continue;
            stateScope.add(s);
        }
        while (!stateScope.isEmpty()) {
            State sRoot;
            State sPtr = sRoot = (State)stateScope.iterator().next();
            Resistor rPtr = (Resistor)sPtr.getConnectedComponentsNotAbstracted().get(0);
            while (true) {
                for (Component c : sPtr.getConnectedComponentsNotAbstracted()) {
                    if (c == rPtr) continue;
                    rPtr = (Resistor)c;
                    break;
                }
                State sNext = null;
                if (sPtr != rPtr.aPin) {
                    sNext = rPtr.aPin;
                } else if (sPtr != rPtr.bPin) {
                    sNext = rPtr.bPin;
                }
                if (sNext == null || sNext == sRoot || !stateScope.contains(sNext)) break;
                sPtr = sNext;
            }
            LinkedList<State> lineStates = new LinkedList<State>();
            LinkedList<Resistor> lineResistors = new LinkedList<Resistor>();
            lineResistors.add(rPtr);
            while (true) {
                lineStates.add(sPtr);
                stateScope.remove(sPtr);
                for (Component c : sPtr.getConnectedComponentsNotAbstracted()) {
                    if (c == rPtr) continue;
                    rPtr = (Resistor)c;
                    break;
                }
                lineResistors.add(rPtr);
                State sNext = null;
                if (sPtr != rPtr.aPin) {
                    sNext = rPtr.aPin;
                } else if (sPtr != rPtr.bPin) {
                    sNext = rPtr.bPin;
                }
                if (sNext == null || !stateScope.contains(sNext)) break;
                sPtr = sNext;
            }
            if (lineResistors.getFirst() == lineResistors.getLast()) {
                lineResistors.pop();
                lineStates.pop();
            }
            Line.newLine(this, lineResistors, lineStates);
        }
    }

    private void generateSystems() {
        LinkedList<State> firstState = new LinkedList<State>();
        for (State s : this.addStates) {
            if (!s.mustBeFarFromInterSystem()) continue;
            firstState.add(s);
        }
        for (State s : firstState) {
            if (s.getSubSystem() != null) continue;
            this.buildSubSystem(s);
        }
        while (!this.addStates.isEmpty()) {
            State root = this.addStates.iterator().next();
            this.buildSubSystem(root);
        }
    }

    public void generateInterSystems() {
        Iterator<Component> ic = this.addComponents.iterator();
        while (ic.hasNext()) {
            Resistor r;
            block6: {
                Component c = ic.next();
                try {
                    r = (Resistor)c;
                    if (r.aPin == null) continue;
                    if (r.bPin == null) {
                    }
                    break block6;
                }
                catch (ClassCastException cce) {
                    Utils.println("WARN: RootSystem tried to treat a " + c.getClass() + " as a resistor");
                }
                continue;
            }
            try {
                new InterSystemAbstraction(this, r);
            }
            catch (NullPointerException npe) {
                Utils.println("WARN: failed to create InterSystemAbstraction for Resistor: " + r);
                SubSystem sa = r.aPin.getSubSystem();
                SubSystem sb = r.bPin.getSubSystem();
                Utils.println("... with subsystems: " + sa + ", " + sb);
                Utils.println("WARN: Did you remember to add ALL electrical components to the simulation BEFORE connecting?");
            }
            ic.remove();
        }
    }

    public void step() {
        Profiler profiler = new Profiler();
        profiler.add("Generate");
        this.generate();
        profiler.add("interSystem");
        for (int idx = 0; idx < this.interSystemOverSampling; ++idx) {
            for (IRootSystemPreStepProcess p : this.processPre) {
                p.rootSystemPreStepProcess();
            }
        }
        profiler.add("stepCalc");
        for (SubSystem s : this.systems) {
            s.stepCalc();
        }
        profiler.add("stepFlush");
        for (SubSystem s : this.systems) {
            s.stepFlush();
        }
        profiler.add("simProcessFlush");
        for (ISubSystemProcessFlush p : this.processF) {
            p.simProcessFlush();
        }
        profiler.stop();
    }

    private void buildSubSystem(State root) {
        HashSet<Component> componentSet = new HashSet<Component>();
        HashSet<State> stateSet = new HashSet<State>();
        LinkedList<State> roots = new LinkedList<State>();
        roots.push(root);
        this.buildSubSystem(roots, componentSet, stateSet);
        this.addComponents.removeAll(componentSet);
        this.addStates.removeAll(stateSet);
        SubSystem subSystem = new SubSystem(this, this.dt);
        subSystem.addState(stateSet);
        subSystem.addComponent(componentSet);
        this.systems.add(subSystem);
    }

    private void buildSubSystem(LinkedList<State> roots, Set<Component> componentSet, Set<State> stateSet) {
        boolean privateSystem = roots.getFirst().isPrivateSubSystem();
        while (!roots.isEmpty()) {
            State sExplored = roots.pollFirst();
            stateSet.add(sExplored);
            for (Component c : sExplored.getConnectedComponentsNotAbstracted()) {
                if (!privateSystem && roots.size() + stateSet.size() > 100 && c.canBeReplacedByInterSystem() || componentSet.contains(c)) continue;
                boolean noGo = false;
                for (State sNext : c.getConnectedStates()) {
                    if (sNext == null) continue;
                    if (sNext.getSubSystem() != null) {
                        noGo = true;
                        break;
                    }
                    if (sNext.isPrivateSubSystem() == privateSystem) continue;
                    noGo = true;
                    break;
                }
                if (noGo) continue;
                componentSet.add(c);
                for (State sNext : c.getConnectedStates()) {
                    if (sNext == null || stateSet.contains(sNext)) continue;
                    roots.addLast(sNext);
                }
            }
        }
    }

    private SubSystem findSubSystemWith(State state) {
        for (SubSystem s : this.systems) {
            if (!s.containe(state)) continue;
            return s;
        }
        return null;
    }

    public void breakSystems(SubSystem sub) {
        if (sub.breakSystem()) {
            for (SubSystem s : sub.interSystemConnectivity) {
                this.breakSystems(s);
            }
        }
    }

    public static void main(String[] args2) {
        int i;
        RootSystem s = new RootSystem(0.1, 1);
        VoltageState n1 = new VoltageState();
        s.addState(n1);
        VoltageState n2 = new VoltageState();
        s.addState(n2);
        VoltageSource u1 = new VoltageSource("");
        s.addComponent(u1.setVoltage(1.0).connectTo(n1, null));
        Resistor r1 = new Resistor();
        s.addComponent(r1.setResistance(10.0).connectTo(n1, n2));
        Resistor r2 = new Resistor();
        s.addComponent(r2.setResistance(20.0).connectTo(n2, null));
        VoltageState n11 = new VoltageState();
        s.addState(n11);
        VoltageState n12 = new VoltageState();
        s.addState(n12);
        VoltageSource u11 = new VoltageSource("");
        s.addComponent(u11.setVoltage(1.0).connectTo(n11, null));
        Resistor r11 = new Resistor();
        s.addComponent(r11.setResistance(10.0).connectTo(n11, n12));
        Resistor r12 = new Resistor();
        s.addComponent(r12.setResistance(30.0).connectTo(n12, null));
        InterSystem i01 = new InterSystem();
        s.addComponent(i01.setResistance(10.0).connectTo(n2, n12));
        for (i = 0; i < 50; ++i) {
            s.step();
        }
        Resistor r13 = new Resistor();
        s.addComponent(r13.setResistance(30.0).connectTo(n12, null));
        for (i = 0; i < 50; ++i) {
            s.step();
        }
        s.step();
    }

    public int getSubSystemCount() {
        return this.systems.size();
    }

    public void addProcess(ISubSystemProcessFlush p) {
        this.processF.add(p);
    }

    public void removeProcess(ISubSystemProcessFlush p) {
        this.processF.remove(p);
    }

    public void addProcess(IRootSystemPreStepProcess p) {
        this.processPre.add(p);
    }

    public void removeProcess(IRootSystemPreStepProcess p) {
        this.processPre.remove(p);
    }

    public boolean isRegistred(ElectricalLoad load) {
        return load.getSubSystem() != null || this.addStates.contains(load);
    }
}

