/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.State;

public class Capacitor
extends Bipole
implements ISubSystemProcessI {
    private double coulombs = 0.0;
    double coulombsPerStep;

    public Capacitor() {
    }

    public Capacitor(State aPin, State bPin) {
        this.connectTo(aPin, bPin);
    }

    @Override
    public double getCurrent() {
        return 0.0;
    }

    public void setCoulombs(double coulombs) {
        this.coulombs = coulombs;
        this.dirty();
    }

    @Override
    public void applyToSubsystem(SubSystem s) {
        this.coulombsPerStep = this.coulombs / s.getDt();
        s.addToA(this.aPin, this.aPin, this.coulombsPerStep);
        s.addToA(this.aPin, this.bPin, -this.coulombsPerStep);
        s.addToA(this.bPin, this.bPin, this.coulombsPerStep);
        s.addToA(this.bPin, this.aPin, -this.coulombsPerStep);
    }

    @Override
    public void simProcessI(SubSystem s) {
        double add = (s.getXSafe(this.aPin) - s.getXSafe(this.bPin)) * this.coulombsPerStep;
        s.addToI(this.aPin, add);
        s.addToI(this.bPin, -add);
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addToSubsystem(SubSystem s) {
        super.addToSubsystem(s);
        s.addProcess(this);
    }

    public double getEnergy() {
        double voltage = this.getVoltage();
        return voltage * voltage * this.coulombs / 2.0;
    }

    public double getCoulombs() {
        return this.coulombs;
    }
}

