/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.CurrentState;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class Inductor
extends Bipole
implements ISubSystemProcessI,
INBTTReady {
    String name;
    private double inductance = 0.0;
    double inductancePerStep;
    private final CurrentState currentState = new CurrentState();

    public Inductor(String name) {
        this.name = name;
    }

    public Inductor(String name, State aPin, State bPin) {
        super(aPin, bPin);
        this.name = name;
    }

    @Override
    public double getCurrent() {
        return this.currentState.state;
    }

    public double getInductance() {
        return this.inductance;
    }

    public void setInductance(double inductance) {
        this.inductance = inductance;
        this.dirty();
    }

    public double getEnergy() {
        double current = this.getCurrent();
        return current * current * this.inductance / 2.0;
    }

    @Override
    public void applyToSubsystem(SubSystem s) {
        this.inductancePerStep = -this.inductance / s.getDt();
        s.addToA(this.aPin, this.currentState, 1.0);
        s.addToA(this.bPin, this.currentState, -1.0);
        s.addToA(this.currentState, this.aPin, 1.0);
        s.addToA(this.currentState, this.bPin, -1.0);
        s.addToA(this.currentState, this.currentState, this.inductancePerStep);
    }

    @Override
    public void simProcessI(SubSystem s) {
        s.addToI(this.currentState, this.inductancePerStep * this.currentState.state);
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.states.remove(this.getCurrentState());
        this.subSystem.removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addToSubsystem(SubSystem s) {
        super.addToSubsystem(s);
        s.addState(this.getCurrentState());
        s.addProcess(this);
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        this.currentState.state = nbt.func_74769_h(str + "Istate");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        nbt.func_74780_a(str + "Istate", this.currentState.state);
    }

    public void resetStates() {
        this.currentState.state = 0.0;
    }
}

