/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.RootSystem;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.IAbstractor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IDestructor;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.mna.state.VoltageState;

public class InterSystemAbstraction
implements IAbstractor,
IDestructor,
IRootSystemPreStepProcess {
    VoltageState aNewState;
    Resistor aNewResistor;
    VoltageSource aNewDelay;
    VoltageState bNewState;
    Resistor bNewResistor;
    VoltageSource bNewDelay;
    RootSystem root;
    Resistor interSystemResistor;
    State aState;
    State bState;
    SubSystem aSystem;
    SubSystem bSystem;

    public InterSystemAbstraction(RootSystem root, Resistor interSystemResistor) {
        this.interSystemResistor = interSystemResistor;
        this.root = root;
        this.aState = interSystemResistor.aPin;
        this.bState = interSystemResistor.bPin;
        this.aSystem = this.aState.getSubSystem();
        this.bSystem = this.bState.getSubSystem();
        this.aSystem.interSystemConnectivity.add(this.bSystem);
        this.bSystem.interSystemConnectivity.add(this.aSystem);
        this.aNewState = new VoltageState();
        this.aNewResistor = new Resistor();
        this.aNewDelay = new VoltageSource("aNewDelay");
        this.bNewState = new VoltageState();
        this.bNewResistor = new Resistor();
        this.bNewDelay = new VoltageSource("bNewDelay");
        this.aNewResistor.connectGhostTo(this.aState, this.aNewState);
        this.aNewDelay.connectTo(this.aNewState, null);
        this.bNewResistor.connectGhostTo(this.bState, this.bNewState);
        this.bNewDelay.connectTo(this.bNewState, null);
        this.calibrate();
        this.aSystem.addComponent(this.aNewResistor);
        this.aSystem.addState(this.aNewState);
        this.aSystem.addComponent(this.aNewDelay);
        this.bSystem.addComponent(this.bNewResistor);
        this.bSystem.addState(this.bNewState);
        this.bSystem.addComponent(this.bNewDelay);
        this.aSystem.breakDestructor.add(this);
        this.bSystem.breakDestructor.add(this);
        interSystemResistor.abstractedBy = this;
        root.addProcess(this);
    }

    void calibrate() {
        double voltage = (this.aState.state + this.bState.state) / 2.0;
        this.aNewDelay.setVoltage(voltage);
        this.bNewDelay.setVoltage(voltage);
        double resistance = this.interSystemResistor.getResistance() / 2.0;
        this.aNewResistor.setResistance(resistance);
        this.bNewResistor.setResistance(resistance);
    }

    @Override
    public void dirty(Component component) {
        this.calibrate();
    }

    @Override
    public SubSystem getAbstractorSubSystem() {
        return this.aSystem;
    }

    @Override
    public void destruct() {
        this.aSystem.breakDestructor.remove(this);
        this.aSystem.removeComponent(this.aNewDelay);
        this.aSystem.removeComponent(this.aNewResistor);
        this.aSystem.removeState(this.aNewState);
        this.bSystem.breakDestructor.remove(this);
        this.bSystem.removeComponent(this.bNewDelay);
        this.bSystem.removeComponent(this.bNewResistor);
        this.bSystem.removeState(this.bNewState);
        this.root.removeProcess(this);
        this.interSystemResistor.abstractedBy = null;
        this.aSystem.component.add(this.interSystemResistor);
    }

    @Override
    public void rootSystemPreStepProcess() {
        SubSystem.Thevenin a = this.aNewDelay.getSubSystem().getTh(this.aState, this.aNewDelay);
        SubSystem.Thevenin b = this.bNewDelay.getSubSystem().getTh(this.bState, this.bNewDelay);
        double voltage = (a.voltage - b.voltage) * b.resistance / (a.resistance + b.resistance) + b.voltage;
        if (Double.isNaN(voltage)) {
            voltage = 0.0;
        }
        this.aNewDelay.setVoltage(voltage);
        this.bNewDelay.setVoltage(voltage);
    }
}

