/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class PowerSource
extends VoltageSource
implements IRootSystemPreStepProcess,
INBTTReady {
    String name;
    double power;
    double maximumVoltage;
    double maximumCurrent;

    public PowerSource(String name, State aPin) {
        super(name, aPin, null);
        this.name = name;
    }

    public void setPower(double P) {
        this.power = P;
    }

    void setMaximums(double Umax, double Imax) {
        this.maximumVoltage = Umax;
        this.maximumCurrent = Imax;
    }

    public void setMaximumCurrent(double maximumCurrent) {
        this.maximumCurrent = maximumCurrent;
    }

    public void setMaximumVoltage(double maximumVoltage) {
        this.maximumVoltage = maximumVoltage;
    }

    @Override
    public double getPower() {
        return this.power;
    }

    @Override
    public void quitSubSystem() {
        this.getSubSystem().getRoot().removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addToSubsystem(SubSystem s) {
        super.addToSubsystem(s);
        this.getSubSystem().getRoot().addProcess(this);
        s.addProcess(this);
    }

    @Override
    public void rootSystemPreStepProcess() {
        SubSystem.Thevenin t = this.aPin.getSubSystem().getTh(this.aPin, this);
        double U = (Math.sqrt(t.voltage * t.voltage + 4.0 * this.power * t.resistance) + t.voltage) / 2.0;
        if (Double.isNaN(U = Math.min(Math.min(U, this.maximumVoltage), t.voltage + t.resistance * this.maximumCurrent))) {
            U = 0.0;
        }
        if (U < t.voltage) {
            U = t.voltage;
        }
        this.setVoltage(U);
    }

    public double getEffectivePower() {
        return this.getVoltage() * this.getCurrent();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        super.readFromNBT(nbt, str);
        str = str + this.name;
        this.setPower(nbt.func_74769_h(str + "P"));
        this.setMaximumVoltage(nbt.func_74769_h(str + "Umax"));
        this.setMaximumCurrent(nbt.func_74769_h(str + "Imax"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        super.writeToNBT(nbt, str);
        str = str + this.name;
        nbt.func_74780_a(str + "P", this.getPower());
        nbt.func_74780_a(str + "Umax", this.maximumVoltage);
        nbt.func_74780_a(str + "Imax", this.maximumCurrent);
    }
}

