/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.Utils;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.state.State;

public class Resistor
extends Bipole {
    private double resistance = 1.0E9;
    private double resistanceInverse = 1.0E-9;

    public Resistor() {
    }

    public Resistor(State aPin, State bPin) {
        super(aPin, bPin);
    }

    public double getResistanceInverse() {
        return this.resistanceInverse;
    }

    public double getResistance() {
        return this.resistance;
    }

    public double getPower() {
        return this.getVoltage() * this.getCurrent();
    }

    public Resistor setResistance(double resistance) {
        if (Double.isNaN(resistance) || Double.isInfinite(resistance)) {
            Utils.println("Error! Resistor cannot be set to " + resistance);
            return this;
        }
        if (this.resistance != resistance) {
            this.resistance = resistance;
            this.resistanceInverse = 1.0 / resistance;
            this.dirty();
        }
        return this;
    }

    public void highImpedance() {
        this.setResistance(1.0E9);
    }

    public void ultraImpedance() {
        this.setResistance(1.0E16);
    }

    public Resistor pullDown() {
        this.setResistance(1.0E9);
        return this;
    }

    @Override
    public void applyToSubsystem(SubSystem s) {
        s.addToA(this.aPin, this.aPin, this.resistanceInverse);
        s.addToA(this.aPin, this.bPin, -this.resistanceInverse);
        s.addToA(this.bPin, this.bPin, this.resistanceInverse);
        s.addToA(this.bPin, this.aPin, -this.resistanceInverse);
    }

    @Override
    public double getCurrent() {
        return this.getVoltage() * this.resistanceInverse;
    }
}

