/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.state.CurrentState;
import mods.eln.sim.mna.state.State;

public class Transformer
extends Bipole {
    public CurrentState aCurrentState = new CurrentState();
    public CurrentState bCurrentState = new CurrentState();
    double ratio = 1.0;

    public Transformer() {
    }

    public Transformer(State aPin, State bPin) {
        super(aPin, bPin);
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.states.remove(this.aCurrentState);
        this.subSystem.states.remove(this.bCurrentState);
        super.quitSubSystem();
    }

    @Override
    public void addToSubsystem(SubSystem s) {
        super.addToSubsystem(s);
        s.addState(this.aCurrentState);
        s.addState(this.bCurrentState);
    }

    @Override
    public void applyToSubsystem(SubSystem s) {
        s.addToA(this.bPin, this.bCurrentState, 1.0);
        s.addToA(this.bCurrentState, this.bPin, 1.0);
        s.addToA(this.bCurrentState, this.aPin, -this.ratio);
        s.addToA(this.aPin, this.aCurrentState, 1.0);
        s.addToA(this.aCurrentState, this.aPin, 1.0);
        s.addToA(this.aCurrentState, this.bPin, -1.0 / this.ratio);
        s.addToA(this.aCurrentState, this.aCurrentState, 1.0);
        s.addToA(this.aCurrentState, this.bCurrentState, this.ratio);
        s.addToA(this.bCurrentState, this.aCurrentState, 1.0);
        s.addToA(this.bCurrentState, this.bCurrentState, this.ratio);
    }

    @Override
    public double getCurrent() {
        return 0.0;
    }
}

