/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.CurrentState;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class VoltageSource
extends Bipole
implements ISubSystemProcessI,
INBTTReady {
    String name;
    double voltage = 0.0;
    private final CurrentState currentState = new CurrentState();

    public VoltageSource(String name) {
        this.name = name;
    }

    public VoltageSource(String name, State aPin, State bPin) {
        super(aPin, bPin);
        this.name = name;
    }

    public VoltageSource setVoltage(double voltage) {
        this.voltage = voltage;
        return this;
    }

    @Override
    public double getVoltage() {
        return this.voltage;
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.states.remove(this.getCurrentState());
        this.subSystem.removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addToSubsystem(SubSystem s) {
        super.addToSubsystem(s);
        s.addState(this.getCurrentState());
        s.addProcess(this);
    }

    @Override
    public void applyToSubsystem(SubSystem s) {
        s.addToA(this.aPin, this.getCurrentState(), 1.0);
        s.addToA(this.bPin, this.getCurrentState(), -1.0);
        s.addToA(this.getCurrentState(), this.aPin, 1.0);
        s.addToA(this.getCurrentState(), this.bPin, -1.0);
    }

    @Override
    public void simProcessI(SubSystem s) {
        s.addToI(this.getCurrentState(), this.voltage);
    }

    @Override
    public double getCurrent() {
        return -this.getCurrentState().state;
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        this.setVoltage(nbt.func_74769_h(str + "U"));
        this.currentState.state = nbt.func_74769_h(str + "Istate");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        nbt.func_74780_a(str + "U", this.voltage);
        nbt.func_74780_a(str + "Istate", this.currentState.state);
    }

    public double getPower() {
        return this.getVoltage() * this.getCurrent();
    }
}

