/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.process;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class PowerSourceBipole
implements IRootSystemPreStepProcess,
INBTTReady {
    private final VoltageSource aSrc;
    private final VoltageSource bSrc;
    private final State aPin;
    private final State bPin;
    double power;
    double maximumVoltage;
    double maximumCurrent;

    public PowerSourceBipole(State aPin, State bPin, VoltageSource aSrc, VoltageSource bSrc) {
        this.aSrc = aSrc;
        this.bSrc = bSrc;
        this.aPin = aPin;
        this.bPin = bPin;
    }

    public void setPower(double P) {
        this.power = P;
    }

    void setMaximums(double Umax, double Imax) {
        this.maximumVoltage = Umax;
        this.maximumCurrent = Imax;
    }

    public void setMaximumCurrent(double maximumCurrent) {
        this.maximumCurrent = maximumCurrent;
    }

    public void setMaximumVoltage(double maximumVoltage) {
        this.maximumVoltage = maximumVoltage;
    }

    public double getPower() {
        return this.power;
    }

    @Override
    public void rootSystemPreStepProcess() {
        SubSystem.Thevenin a = this.aPin.getSubSystem().getTh(this.aPin, this.aSrc);
        SubSystem.Thevenin b = this.bPin.getSubSystem().getTh(this.bPin, this.bSrc);
        if (Double.isNaN(a.voltage)) {
            a.voltage = 0.0;
            a.resistance = 1.0E9;
        }
        if (Double.isNaN(b.voltage)) {
            b.voltage = 0.0;
            b.resistance = 1.0E9;
        }
        double theveninVoltage = a.voltage - b.voltage;
        double theveninResistance = a.resistance + b.resistance;
        if (theveninVoltage >= this.maximumVoltage) {
            this.aSrc.setVoltage(a.voltage);
            this.bSrc.setVoltage(b.voltage);
        } else {
            double voltage = (Math.sqrt(theveninVoltage * theveninVoltage + 4.0 * this.power * theveninResistance) + theveninVoltage) / 2.0;
            if (Double.isNaN(voltage = Math.min(Math.min(voltage, this.maximumVoltage), theveninVoltage + theveninResistance * this.maximumCurrent))) {
                voltage = 0.0;
            }
            double I = (theveninVoltage - voltage) / theveninResistance;
            this.aSrc.setVoltage(a.voltage - I * a.resistance);
            this.bSrc.setVoltage(b.voltage + I * b.resistance);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.setPower(nbt.func_74769_h(str + "P"));
        this.setMaximumVoltage(nbt.func_74769_h(str + "Umax"));
        this.setMaximumCurrent(nbt.func_74769_h(str + "Imax"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + "P", this.getPower());
        nbt.func_74780_a(str + "Umax", this.maximumVoltage);
        nbt.func_74780_a(str + "Imax", this.maximumCurrent);
    }
}

