/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.process;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;

public class TransformerInterSystemProcess
implements IRootSystemPreStepProcess {
    State aState;
    State bState;
    VoltageSource aVoltgeSource;
    VoltageSource bVoltgeSource;
    double ratio = 1.0;

    public TransformerInterSystemProcess(State aState, State bState, VoltageSource aVoltgeSource, VoltageSource bVoltgeSource) {
        this.aState = aState;
        this.bState = bState;
        this.aVoltgeSource = aVoltgeSource;
        this.bVoltgeSource = bVoltgeSource;
    }

    @Override
    public void rootSystemPreStepProcess() {
        SubSystem.Thevenin a = this.aVoltgeSource.getSubSystem().getTh(this.aState, this.aVoltgeSource);
        SubSystem.Thevenin b = this.bVoltgeSource.getSubSystem().getTh(this.bState, this.bVoltgeSource);
        double voltage = (a.voltage * b.resistance + this.ratio * b.voltage * a.resistance) / (b.resistance + this.ratio * this.ratio * a.resistance);
        if (Double.isNaN(voltage)) {
            voltage = 0.0;
        }
        this.aVoltgeSource.setVoltage(voltage);
        this.bVoltgeSource.setVoltage(voltage * this.ratio);
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }
}

