/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.nbt;

import mods.eln.Eln;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Capacitor;
import net.minecraft.nbt.NBTTagCompound;

public class NbtElectricalGateOutputProcess
extends Capacitor
implements INBTTReady {
    double voltage;
    String name;
    boolean highImpedance = false;

    public NbtElectricalGateOutputProcess(String name, ElectricalLoad positiveLoad) {
        super(positiveLoad, null);
        this.name = name;
        this.setHighImpedance(false);
    }

    public void setHighImpedance(boolean enable) {
        this.highImpedance = enable;
        double baseC = 0.1 / Eln.instance.electricalFrequency / 5.0;
        if (enable) {
            this.setCoulombs(baseC / 1000.0);
        } else {
            this.setCoulombs(baseC);
        }
    }

    @Override
    public void simProcessI(SubSystem s) {
        if (!this.highImpedance) {
            this.aPin.state = this.voltage;
        }
        super.simProcessI(s);
    }

    public boolean isHighImpedance() {
        return this.highImpedance;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.setHighImpedance(nbt.func_74767_n(str + this.name + "highImpedance"));
        this.voltage = nbt.func_74769_h(str + this.name + "U");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74757_a(str + this.name + "highImpedance", this.highImpedance);
        nbt.func_74780_a(str + this.name + "U", this.voltage);
    }

    public void setOutputNormalized(double value) {
        this.setOutputNormalizedSafe(value);
    }

    public void state(boolean value) {
        this.voltage = value ? 5.0 : 0.0;
    }

    public double getOutputNormalized() {
        return this.voltage / 5.0;
    }

    public boolean getOutputOnOff() {
        return this.voltage >= 2.5;
    }

    public void setOutputNormalizedSafe(double value) {
        if (value > 1.0) {
            value = 1.0;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        this.voltage = value * 5.0;
    }

    public void setVoltage(double U) {
        this.voltage = U;
    }

    public void setVoltageSafe(double value) {
        if (Double.isNaN(value = Utils.limit(value, 0.0, 5.0))) {
            value = 0.0;
        }
        this.voltage = value;
    }

    @Override
    public double getVoltage() {
        return this.voltage;
    }
}

